(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[   1671926,      35105]
NotebookOptionsPosition[   1633984,      33980]
NotebookOutlinePosition[   1634402,      33998]
CellTagsIndexPosition[   1634359,      33995]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Endler's method", "Title",
 CellGroupingRules->{"TitleGrouping", Inherited},
 CellChangeTimes->{{3.582533276102071*^9, 3.582533289531046*^9}, 
   3.582534318855773*^9}],

Cell[CellGroupData[{

Cell["\<\
Theory: Allele frequencies after a secondary contact (Endler 1977, Gay et al. \
2008)\
\>", "Section",
 CellChangeTimes->{{3.582524016770054*^9, 3.5825240359931297`*^9}, {
   3.5825241646649923`*^9, 3.582524169970166*^9}, {3.582524354454563*^9, 
   3.5825243695502787`*^9}, {3.582524420897971*^9, 3.5825244313181353`*^9}, {
   3.583821950101674*^9, 3.583821951771471*^9}, {3.583822012173847*^9, 
   3.583822021291452*^9}, {3.5838252327314577`*^9, 3.583825271444068*^9}, 
   3.583825305480588*^9}],

Cell[CellGroupData[{

Cell["Solution of the diffusion equation", "Subsection",
 CellChangeTimes->{{3.583821711341208*^9, 3.5838217417454987`*^9}, {
  3.58383686846311*^9, 3.583836871938221*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"x_", ",", "T_"}], "]"}], "=", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"4", 
      FractionBox[
       SuperscriptBox["\[Sigma]", "2"], "2"], " ", "\[Pi]", " ", "T"}]]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"+", "\[Infinity]"}]], 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "y"}], ")"}], "2"], 
        RowBox[{"4", " ", 
         FractionBox[
          SuperscriptBox["\[Sigma]", "2"], "2"], "T"}]]}], "]"}], 
     RowBox[{"f", "[", "y", "]"}], 
     RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.582524940490698*^9, 3.582524951359062*^9}, 
   3.582525494623603*^9}],

Cell[BoxData[Cell["with f[y] the initial frequency at T = 0", "Subsubtitle",
  CellChangeTimes->{{3.582523584104389*^9, 3.5825236101105003`*^9}}]], "Text",\

 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.582524940490698*^9, 3.582524956794283*^9}, 
   3.582525445874501*^9, 3.5825254946236887`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
After a secondary contact between two populations with allele frequencies h1 \
and hp (1 - h1)\
\>", "Subsection",
 CellChangeTimes->{{3.583821800564554*^9, 3.583821806106196*^9}, {
  3.583825301475884*^9, 3.5838253027109613`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "y", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"h1", " ", "for", " ", "y"}], " ", "<", " ", "c"}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "y", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"hp", 
    RowBox[{"(", 
     RowBox[{"1", "-", "h1"}], ")"}], " ", "for", " ", "y"}], " ", 
   "\[GreaterSlantEqual]", " ", "c"}]}]}], "Input",
 CellChangeTimes->{{3.5838217898197823`*^9, 3.583821789821348*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"4", 
        FractionBox[
         SuperscriptBox["\[Sigma]", "2"], "2"], " ", "\[Pi]", " ", "T"}]]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "\[Infinity]"}], "c"], 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "y"}], ")"}], "2"], 
          RowBox[{"4", " ", 
           FractionBox[
            SuperscriptBox["\[Sigma]", "2"], "2"], "T"}]]}], "]"}], 
       RowBox[{"(", 
        RowBox[{"h1", "+", 
         RowBox[{"hp", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "h1"}], ")"}]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "y"}]}]}]}], "+", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"4", 
        FractionBox[
         SuperscriptBox["\[Sigma]", "2"], "2"], " ", "\[Pi]", " ", "T"}]]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "c", 
       RowBox[{"+", "\[Infinity]"}]], 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "y"}], ")"}], "2"], 
          RowBox[{"4", " ", 
           FractionBox[
            SuperscriptBox["\[Sigma]", "2"], "2"], "T"}]]}], "]"}], "h1", 
       RowBox[{"\[DifferentialD]", "y"}]}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", ">", "0"}], ",", 
     RowBox[{"\[Sigma]", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5825254406863823`*^9, 3.582525452834036*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "h1"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"hp", "-", 
       RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"c", "-", "x"}], 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.582525440686468*^9, 3.582525452834128*^9}}],

Cell[TextData[{
 "this is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"h1", "+", 
    RowBox[{"hp", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "h1"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"4", 
           FractionBox[
            SuperscriptBox["\[Sigma]", "2"], "2"], " ", "\[Pi]", " ", "T"}]]], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          RowBox[{"-", "\[Infinity]"}], "x"], 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"y", "-", "c"}], ")"}], "2"], 
             RowBox[{"4", " ", 
              FractionBox[
               SuperscriptBox["\[Sigma]", "2"], "2"], "T"}]]}], "]"}], 
          RowBox[{"\[DifferentialD]", "y"}]}]}]}]}], ")"}]}]}], "=", 
   RowBox[{"h1", "+", 
    RowBox[{"hp", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "h1"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"c", ",", 
           RowBox[{"\[Sigma]", " ", 
            SqrtBox["T"]}]}], "]"}], ",", "x"}], "]"}]}], ")"}]}]}]}]],
  CellGroupingRules->{GroupTogetherGrouping, 10000.},
  CellChangeTimes->{{3.582523912572043*^9, 3.582523988866242*^9}, 
    3.582524058899681*^9, {3.582524112978524*^9, 3.582524126643218*^9}, 
    3.58252547140851*^9}],
 " "
}], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.582523854208499*^9, 3.5825238613524933`*^9}, 
   3.5825254714084063`*^9, {3.583636109310815*^9, 3.5836361209670277`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"x_", ",", "T_"}], "]"}], "=", 
  RowBox[{"h1", "+", 
   RowBox[{"hp", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "h1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"c", ",", 
          RowBox[{"\[Sigma]", " ", 
           SqrtBox["T"]}]}], "]"}], ",", "x"}], "]"}]}], ")"}]}]}]}]], "Input",\

 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.582524064356411*^9, 3.58252408679685*^9}, {
   3.5825241323137703`*^9, 3.5825241367140207`*^9}, 3.582525471408575*^9}],

Cell[BoxData[
 RowBox[{"h1", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "h1"}], ")"}], " ", "hp", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Erfc", "[", 
       FractionBox[
        RowBox[{"c", "-", "x"}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5825240666349173`*^9, 3.582524087779233*^9}, 
   3.582524140432102*^9, 3.582525471408662*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Maximum slope of the cline", "Subsection",
 CellChangeTimes->{{3.5838218412481527`*^9, 3.5838218582793503`*^9}, {
  3.583825317097066*^9, 3.583825320017467*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"x", ",", "T"}], "]"}], ",", "x"}], "]"}], "/.", 
   RowBox[{"x", "\[Rule]", "c"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.582524186814301*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "h1"}], ")"}], " ", "hp"}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   SqrtBox["T"], " ", "\[Sigma]"}]]], "Output",
 CellChangeTimes->{3.582524210442091*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Width of the cline (Endler' s result) : \[CapitalDelta]p/maximum slope\
\>", "Subsection",
 CellChangeTimes->{{3.583821881247192*^9, 3.5838218812486877`*^9}, 
   3.583821927968943*^9, {3.58382532663457*^9, 3.5838253282028646`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "hp"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "h1"}], ")"}], "/", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"x", ",", "T"}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
   RowBox[{"x", "\[Rule]", "c"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5825240739876223`*^9, 3.5838218935853357`*^9}],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  SqrtBox["T"], " ", "\[Sigma]"}]], "Output",
 CellChangeTimes->{3.582524091717514*^9, 3.5825241588741217`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Data", "Section",
 CellChangeTimes->{{3.5836361676097317`*^9, 3.583636178733576*^9}, 
   3.583636391827516*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "X", " ", "and", " ", "Y", " ", "geographical", " ", "coordinates", " ", 
    "of", " ", "the", " ", "samples"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"distX", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "58", ",", "302", ",", "340", ",", "333", ",", "369", ",", 
       "334", ",", "377", ",", "424", ",", "462", ",", "462", ",", "710", ",",
        "888"}], "}"}]}], ";", 
    RowBox[{"distY", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "99", ",", "85", ",", "84", ",", "130", ",", "120", ",", 
       "148", ",", "137", ",", "144", ",", "162", ",", "175", ",", "227", ",",
        "338"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"allele", " ", "group", " ", "frequencies"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"all", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "82", ",", "66", ",", "79", ",", "65", ",", "46", ",", "52", ",", 
         "58", ",", "50", ",", "17", ",", "8", ",", "9", ",", "33", ",", 
         "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "68", ",", "80", ",", "66", ",", "53", ",", "54", ",", 
         "72", ",", "58", ",", "29", ",", "26", ",", "51", ",", "50", ",", 
         "46"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "75", ",", "54", ",", "75", ",", "65", ",", "38", ",", "50", ",", 
         "49", ",", "36", ",", "11", ",", "0", ",", "1", ",", "1", ",", "1"}],
         "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "25", ",", "23", ",", "21", ",", "19", ",", "18", ",", "20", ",", 
         "22", ",", "21", ",", "17", ",", "10", ",", "9", ",", "7", ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "80", ",", "56", ",", "80", ",", "67", ",", "52", ",", "52", ",", 
         "63", ",", "53", ",", "32", ",", "22", ",", "52", ",", "42", ",", 
         "42"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "81", ",", "67", ",", "79", ",", "70", ",", "75", ",", "63", ",", 
         "80", ",", "67", ",", "34", ",", "40", ",", "63", ",", "65", ",", 
         "68"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "80", ",", "59", ",", "73", ",", "66", ",", "48", ",", "48", ",", 
         "57", ",", "37", ",", "10", ",", "3", ",", "3", ",", "13", ",", 
         "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "38", ",", "26", ",", "30", ",", "31", ",", "35", ",", "41", ",", 
         "25", ",", "21", ",", "9", ",", "4", ",", "5", ",", "14", ",", 
         "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "73", ",", "53", ",", "56", ",", "61", ",", "52", ",", "50", ",", 
         "58", ",", "54", ",", "16", ",", "12", ",", "7", ",", "37", ",", 
         "27"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "70", ",", "76", ",", "69", ",", "78", ",", "58", ",", 
         "76", ",", "67", ",", "47", ",", "46", ",", "68", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "69", ",", "51", ",", "70", ",", "61", ",", "34", ",", "45", ",", 
         "49", ",", "22", ",", "8", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "58", ",", "76", ",", "69", ",", "62", ",", "62", ",", 
         "71", ",", "67", ",", "37", ",", "29", ",", "39", ",", "60", ",", 
         "56"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"sample", " ", "sizes"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eff", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "82", ",", "68", ",", "80", ",", "70", ",", "76", ",", "63", ",", 
         "78", ",", "80", ",", "48", ",", "46", ",", "66", ",", "82", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "68", ",", "80", ",", "70", ",", "76", ",", "62", ",", 
         "80", ",", "76", ",", "48", ",", "46", ",", "66", ",", "82", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "78", ",", "60", ",", "78", ",", "70", ",", "76", ",", "66", ",", 
         "78", ",", "72", ",", "48", ",", "46", ",", "66", ",", "80", ",", 
         "78"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "62", ",", "78", ",", "70", ",", "78", ",", "66", ",", 
         "78", ",", "72", ",", "48", ",", "46", ",", "66", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "58", ",", "80", ",", "70", ",", "76", ",", "64", ",", 
         "78", ",", "80", ",", "48", ",", "43", ",", "66", ",", "82", ",", 
         "78"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "68", ",", "80", ",", "70", ",", "76", ",", "66", ",", 
         "80", ",", "80", ",", "48", ",", "46", ",", "66", ",", "82", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "80", ",", "60", ",", "78", ",", "70", ",", "76", ",", "66", ",", 
         "78", ",", "72", ",", "48", ",", "46", ",", "64", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "68", ",", "76", ",", "70", ",", "78", ",", "66", ",", 
         "80", ",", "72", ",", "48", ",", "46", ",", "68", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "70", ",", "72", ",", "70", ",", "78", ",", "66", ",", 
         "80", ",", "72", ",", "48", ",", "46", ",", "68", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "70", ",", "76", ",", "70", ",", "78", ",", "66", ",", 
         "80", ",", "72", ",", "48", ",", "46", ",", "68", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "58", ",", "76", ",", "70", ",", "78", ",", "66", ",", 
         "80", ",", "72", ",", "48", ",", "46", ",", "66", ",", "80", ",", 
         "80"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "82", ",", "58", ",", "76", ",", "70", ",", "78", ",", "66", ",", 
         "80", ",", "72", ",", "48", ",", "46", ",", "66", ",", "80", ",", 
         "80"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.582342036711465*^9, 3.582342083838869*^9}, {
  3.582342188778854*^9, 3.582342405706456*^9}, {3.58236202585213*^9, 
  3.582362190370633*^9}, {3.5823622327272863`*^9, 3.582362344788159*^9}, {
  3.583636275095954*^9, 3.583636323925617*^9}, {3.583636472560158*^9, 
  3.583636474144259*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Parameters, function and Loglikelihood", "Section",
 CellChangeTimes->{{3.58363640362878*^9, 3.583636405243298*^9}, {
   3.58363658977109*^9, 3.583636600624736*^9}, 3.583637069639008*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle2", ",", "angle3", ",", "angle4", ",", "angle5", ",",
      "angle6", ",", "angle7", ",", "angle8", ",", "angle9", ",", "angle10", 
     ",", "angle11", ",", "angle12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", "c6", ",", "c7", 
     ",", "c8", ",", "c9", ",", "c10", ",", "c11", ",", "c12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3", ",", "\[Sigma]4", ",", 
      "\[Sigma]5", ",", "\[Sigma]6", ",", "\[Sigma]7", ",", "\[Sigma]8", ",", 
      "\[Sigma]9", ",", "\[Sigma]10", ",", "\[Sigma]11", ",", "\[Sigma]12"}], 
     "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"transformed", " ", "sample", " ", "coordinates"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coord", "=", 
    RowBox[{"Table", " ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{"distX", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
         " ", 
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{"distY", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
       "*", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"angle", "[", 
          RowBox[{"[", "j", "]"}], "]"}], "-", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"distY", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/", 
           RowBox[{"distX", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "vector", " ", "of", " ", "transformed", " ", "coordinate", " ", "and", 
    " ", "allele", " ", "group", " ", "frequencies"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gen", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"coord", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
         RowBox[{"eff", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"The", " ", "cumulative", " ", "Gaussian"}], " ", "=", " ", 
     RowBox[{
     "allelic", " ", "frequencies", " ", "as", " ", "a", " ", "function", " ",
       "of", " ", "geographic", " ", "coordinate", " ", 
      RowBox[{"x", ".", " ", "Note"}], " ", "that", " ", "in", " ", "the", 
      " ", "compagnon", " ", "paper"}]}], ",", " ", 
    RowBox[{
     SqrtBox["2"], 
     SqrtBox["T"], "\[Sigma]", " ", "is", " ", "replaced", " ", "by", " ", 
     "b"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"cline2", "[", "x_", "]"}], "=", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "h1"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"hp", "-", 
          RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{"c", "-", "x"}], 
          RowBox[{
           SqrtBox["2"], " ", 
           SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "vector", " ", "of", " ", "LogLikelihood", " ", "per", " ", "locus"}], 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"llcline2", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], 
        RowBox[{"Length", "[", "distX", "]"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"all", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"eff", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
            RowBox[{"all", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
          RowBox[{"Log", "[", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"cline2", "[", 
              RowBox[{"coord", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Total", " ", "LogLikelihood"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, 3.5823657032809877`*^9, 3.5836364428546963`*^9, 
   3.583636631055472*^9, {3.58363676307978*^9, 3.583637051725963*^9}, 
   3.5837329615374947`*^9, {3.5841069822352257`*^9, 3.5841070112549*^9}, {
   3.584107057007677*^9, 3.58410706631936*^9}, 3.58410710109695*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit per locus = model M8 = 12 angles, 12 centers, 12 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.583637193206162*^9, 3.5836372203392897`*^9}, {
   3.58363854667647*^9, 3.583638577306347*^9}, {3.5838109868700247`*^9, 
   3.583810990280385*^9}, 3.583811032690954*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c2", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c3", "<", "1000"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c9", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]2", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]3", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.5823628388876543`*^9, 
   3.58236284295965*^9}, 3.582371861531541*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "403.9543088948377`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "287.5074502383199`"}], ",", 
     RowBox[{"c2", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c3", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c4", "\[Rule]", "630.6170109449722`"}], ",", 
     RowBox[{"c5", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c6", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c7", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c8", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c9", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c10", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c11", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"c12", "\[Rule]", "596.4840554312397`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.6079841129246`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "50.28066862452472`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.23761984610068065`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9837810504927944`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h111", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.3282219616735991`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.6717780383263998`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.103306113572063`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "0.8221155874338643`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "0.8221155874338643`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582358385430276*^9, 3.582360237291751*^9, 
   3.582360574781094*^9, 3.582360614455263*^9, 3.582362375285884*^9, 
   3.582362887902732*^9, 3.582371893745598*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.5823719192204423`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, 
   3.5823629074165363`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c8lt/7AHAilZUkKaOsloxSksq5CGmpkL333jzLY2VXkkqSNKwUoqRC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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3433493420628184`, 1.}, {114.51504904691252`, 
      0.9705882352941176}, {211.97513974254707`, 0.9875}, {
      228.20703178767823`, 0.9285714285714286}, {266.1167991245863, 
      0.6052631578947368}, {273.4130775965459, 0.8253968253968254}, {
      282.6360846257607, 0.7435897435897436}, {292.1941914761075, 0.625}, {
      319.6235254727975, 0.3541666666666667}, {352.8167579310533, 
      0.17391304347826086`}, {364.4218855821386, 0.13636363636363635`}, {
      522.6029055204312, 0.4024390243902439}, {701.9080458981732, 
      0.1875}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.24},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582360639235702*^9, 3.582360719005457*^9, 
  3.58236238462577*^9, 3.58236290967097*^9, 3.5823719239316506`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c2", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c3", "<", "1000"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c9", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]2", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]3", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, 3.582362926922491*^9, 3.582371933244867*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "377.867967579721`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c2", "\[Rule]", "302.1220833735058`"}], ",", 
     RowBox[{"c3", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c4", "\[Rule]", "495.1825983291215`"}], ",", 
     RowBox[{"c5", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c6", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c7", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c8", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c9", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c10", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c11", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"c12", "\[Rule]", "475.7730336362016`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "20.22915515678223`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "51.47934045768179`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6280663907204096`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h111", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.286789882263203`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.7132101177367963`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "0.9900846999268104`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "0.7502860502299183`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "0.7502860502299183`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.582362388463517*^9, {
   3.582362921910174*^9, 3.582362928237615*^9}, 3.582371936645673*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.5823719419808826`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, 3.5823629156345043`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k4lN37AHAkLRRJIksJZcmWLFE9N0myZc2+7/vOjDEzyJZXlAqhVLYk
S6usSXbtEiIVY4kYWQvxO4/v73pff4zrc50zZ+Y5577vc4+Qo5+RCxMDA4MX
esH/dzapLHMyTGOli2voj44tM3TX7vUQBv75//mmiXCyoMdhYPjxPweVyJ8X
6lWFE0X/s8iG/cdS89TBNWR13WNv1DTj2E6D6a0/6y7JdDAID9aBkxdH1r3v
mAKffvNZ+K10e93tvsyzHGxG0LWvdBV3nVuw75ySMXjxe/3F/cCe9qPbyQR+
MzIv45awyS5s+2MC/nl8f3DnWZi4VKeYQqx25ALu72ayGo8/m4LEg/453ILn
2IRLRM+Bo/vsDG4rkzHGAv9z0G9WOY07w6jx283qc/CtQmhq/fu0Xx9LYzQD
vi2mE7j/qvtNJ582AzYX/jHcstUav+MumsHHo+403I7yexionWaw78OBb7hJ
dGZm0oIZjC22f8F9tZi+KYzXHLZv1+jDXer2mTXomDn07E/pwd0i3MTuZ2cO
7juLunB/+1q20yvaHB4lJH/AvZSVudst3xw051Tf4j7E5b/XbsIcprW/tuBW
DnQR+rJiDreGBppwn3pnKWy13QJu0F69xG2bdOqgmZwFTLUFPMftNa4i3qVu
AVVhB2txE7RkJY1NLCBsX1sV7svMfDJnwyxgqO71k/Xzd+SQe51gAa6mMo9w
36vfKK+TaQFKYuHluBsjphVP11rAx7jWe7gX5ppOYBssQWNG7iZuJuNqqOWy
hL9WLZm42R+Uq6sesIQSNywdt5hPlqbSGUsITe9Mwa3QcUnriaUlHGyY/Ae3
unictry3JVzOGolfP79hf32ZFEuY4vCn4nY/6WpQcssSJINWw3EH37Yyknxo
CSocbqG4k200zx3ssgTZAw3euOu7+Gz38llBRD/JDPcnWrYWl7QVSFeqGOL+
OSsgv0XNCrhT6rVx83Du2zzragUzJrzHcUsL3Z4ZJVrBDfkxBdwasvu/9CdZ
wfRoiDRuf32Rh80PrYBpplEQd5xNfnZ1kxXY34vixp3tfSC+vMcKEldmt+Fu
TRSzzly1ghZb+vIqslDLIRZfbWvQ4V/oxK38qWTa0cYayOK72nDrD0v3mflb
Ay+1sxZ3+Aa5crU0axAWFCrAfYnzYaZiERp/XHQdd4GQfKxkjTUwSTQm4f6A
KVjuGrSGg0K3AnCP6T/V2DpvDQR2SyfcqzZKMmubbEDlaZoJbomIo8w/pGxA
4Em8Au7oZ8dLa4g2cOXX6+m/eP601GU8SLKBs9PCA7hLP2HnC3JsgPd4Tzvu
z3Nq5peabID0WvMO7ukNL9Vje2yAIreQhJtlp4ZU+IQN8OyfCsV9WE6TyXmH
LThy3NLCrQUtP81FbGHwrZ4sbtuzWt16SrbAeUNyN+5EH+37Sja24NZpPbiC
PFikf461yBaOxr/zwf372VtgqLGFN59U9HFvbzWQnH9jC1OlmVK4VUaMGL7O
2cKdIN4fy8gG853jnZvsYGrtQBNuV2bTrtY9dtBqsOkW7tT9Zvcegh0o5+0x
wn1XrudqobEduIuriOOuAwtqtqsdXA3euLaEPG5rZRKXZAffjoQU4D6ZZbdq
0WMH3fTIoT/I5cQht4VxO9gh21CGm9/c7X3qXzt4Q3AMx01KVPrgssMeLBSS
t+J+SPzD8niPPRzuXHv7Gz8/92pVJhF72NmWfQW36Wks/6aiPfCzCu3CnaTI
+PknZg/cCRMfFpEbRF9uVz1jD5WVhcm4pZlPE7qt7MFNomJtAXnzC30djih7
+HrHrXke+UQ5R6Rtoj1Y/VoMwB2S8+Hx/Sv2kK05swf3IPmc4JkCeygQ73Ge
w/PFh8c4vcweMlezNuLWt/4cP/zMHiQcw3NnkatVbH9FdaD1vOU+zSDPiO87
8O6jPRya+eKJW4x30FJwwB5GanVXfuH1c9GlsWoarW/CuQu372Of9NldDjB4
MJqPjtf/XJlXansdoDb/wpUp5L7UXwyXxBzgXUvMJtxaASGeh1QdwMXn++BP
PL+kycdd7B3gbUyv0ziyuQAW+MjDAaZcxZ79wOsFG2MhY5ADJNj4bMK9NB7D
cTPWAV5/1E4bRf5YmDT06Z4DpBKPBtCQt6br84g+doDcJJHrQ8hqcRx6QbUO
wFn9tmoQzwfnq0/Z3zmAkcWz8W/I8ULZF7TmHYA55sNiPx4vHLZ1aasO8OpC
01gf8tza3lnaJkcQPrT2/jOy/UCuddQeR6huCEzqweM1q1imCnOEmaNnsjqR
yyqTzrhrOcKPGaLdB/w+7vFx4jZ0hAxLN773eLzvkk0PdHQE35W7xDfIQ8mP
VyViHeGmXV9bK/78Jdd4ei86gh7vNs0W5DcdoYfj0xzhxMjxZ03IzzYfdR0q
dAT9yXxyAx5P0bWvs9od4df587HVyIy3b46e6XQEgbJ79yqRQ59TGX/3OQLn
n7qXFfj3X1FTMJl0BOPfF949Qj4S2pzNxuEEh1f0dIuRi64WPq3icYLB+aTN
Rfh9/SjhnbuQEyT80HhagMfjtDZz02En+KrQRLuN/MXjrRfZ1AmYQw7EpCMb
JZTHSto6gVCkecNVvJ4WXM7pdXWCxhgB+mU8X4aMOxUITtA53cKZtF6Pe1Sm
Mp2AJ2I5lIq8TKo0yc51AoHLsoIReP3OzPTVvu8EdP6UcgKyZbf1nYJaJxjJ
GrsagOeL4fctdt+cQM3XWd8ROdevQXjbDyfgvqurZovHf3Lu8epfTqD4jw2f
JX7/dbgE7N7gDDf1W6INkbs1xnveijrD3IH67RiyrlPHDFnaGTbd2iipgudn
1H22Q0rOYJ/VJK6AfL/OFxK0nIHBRvSVBHKk8mwheDlDhu7Ly1x4/ZfZo3gv
2BlM3PKlt+P33wG1xp0UZ0hnMr2zCdmNK+XbyCVnyBvT27q0ivJxWoL34lNn
+HRiuL4fWWvUsHDhuTMEJl75/RFZfYCgYN/mDA0+P1dfISu+ajaU73eGv4UH
gmqQBe46JvYyuoDXSeXeDGTunAs8J1ldoL6r3yUFmSOtvOA+lwuk6uRXxCIz
x6w2UA+6gGCkZ34A8k+7zGVRPRcgnO06r4k8cu7FhZRzLtBe2blTFfmb3tju
P3YusOH+ZxsZ5E5VxSOvAl1gluEX727kqt0fvAMzXIDllQTL0F869nj7n6W+
2y7wjiNRpQu5dOO+C6eKXaDlHht/C/LtWZ98njoXWNgZ8rUIOeHtloG6IRfg
J3Qe8UKObpb1Fpt0gWfXY3MskSNqzZYuL7hAc3rg3TPIfsX53C5bXGGyfTDp
APK5eLWzrDKusLzDxqVvBd0XFPcvwcqusIC5xLcga4ekeA2ouUL1dqriI+Tj
Tl/iH5ig8crrhy8gi2DEerNwV2CS32ongyyoeEv/xXlXuJtyvmA3Mo9US7/E
RVdoNHVyW1umY2x8u/78zXEFc/lH2q+RZxfK5fKaXOHL2B1tR+RDAot5Pm9c
4bRC3vxpZOeTx3mUul3h8qfZ3VLIXSltq21jrjCuW/RsfomOVYgNdtBZ3eDb
mQvCkcjT+mJYJZcbXC2wUHdAFgvxfRgt4AaHL3e9VEO+/mIpY5eMG9xyfTnE
gEyy3OmqauQGqc0Dp8P+oP2PtOhltnKDAO7KQ8bIPwtydN84uUGa9m4baWSb
WUl5hxA3+NnAcHXwNx3DkjQY4jPcoFo8hlEdeUNdSOaHATewqXkw2btAx47R
qrdlj7qBs4MiQxFy8FamKJdpNxAeTDkYhjx8LtntN6M7fK71z+dAbqEXHBEU
dQfr45N0pXk6xsA9WTgq5Q4nNgeprs2h/umYPN8DRXe4uzBAakIuSnjOqKHl
DjN+xHZ95H+Eet54eLmDJKuyqMks6mdPC6rLB7vDq+j2m5zIKz7OT1Yi3KH1
DtP42xk65lM1nZWS7A4WErWDmshnjbd4PHngDgXFD7tFf9GxnbEqGxh/u0Nj
yFJg7hTqhzmZFG8yeIBQKmugPvLnW23uqls8gN84l+H3JB27U2P+JmSPB0Q/
tqvQRD48F3p9/JgHOHvUz72fQPkVfeJV/CkPyAGBz/7IS+wsayL6HsCpHym8
HfmF5DVnOzsPkM6I7zg5juLR6ZHMxyj0/tvlrzPHUL39Fe4YkOgBaexVsoeQ
eajq17Zf8YCNT++1Vo+ifMt8v6SV5wF+FzMpXSMo3j/Qm2qbPcBVc8hohobu
Q7VD1oWsnkB1yZ3s+EbHAt/OJmtweULKuafZx5HP2VS/+M7vCcxWRrtLvqJ4
Jmof5Jf2BBZCg1HsAPr9V+4+c8nAE7idE3j29KP+9ISsqLSFJ0xrGlkS+9D5
vlo063DwhDwBK6lPn9H5j8XVbgzyBD6HcfeEXjr2am9+Qvg1T1DZzGb35hPq
l0q8q3ff9IR5dXUTXuSrqkemHhd4gnl0dbZDFx2zNntpTK/whJEB503jnXRs
Ivm7oPNnT7AVmbXrfYfu61WBJ3p7vWD1yJcPEu3oeZwlrQvEvGDrsZks+TbU
P7Qrb1iT84KBN8k5yq2o/qYbG5ZreMGP+8tiSs2ofspdmOT09IJ2Ea4NGxvo
2BXnOdGex17wvWvrpd5nKF7aGV/L1nlBmHxS0q0KlI9y7MEXWrygUcKLxekp
qqer4g0qn72gL7wbPj+iYz3pdrY31rxAlD066FIp6v862tMctb2BkqX/nCOX
jsXI9RyvNvYGlwbC/Qu36dhk+jBtp4032J59rPM3B/UPzgzyTX7eMM7K5/0x
m445rCq8PXjNGyyTWZsgDfX/crc3TX71BjVn6VMsCagfyCgtPfXDG/Knj4iK
xNGxsNVq05sz3rDU6D6kGoPug45PuWc3+sBsc3+jeSTqX53Z4KGED5yxisnX
JNAxmYwwQliID5Se+iM96op+P0nlMctSfEAxeki00ZmOUV6+uzQW5wMCBzW2
ZTmi85sSL7LI8AE/qbvRirZ0zPNUf69qtQ9sqpAd2G+K+rcZUGVg9AWenGaR
VjU6ppPg0/Jsiy9s1m2QxTDUHwpkGgdw+sKRPVvjyo6h/urMrNegsC8sNsrT
SEp0bCAnP7tR0xeYNrGYNxxC8a23dTUhyRcu9Xhm/t1Fx54PKiaqXfMFAlf0
HeadqJ8nOHEv3UDrb+a0ZOagY09ya6S9ynzhw5eaR5NbUD+x5Gun98EXNkay
8rn9ncKSCjvrd/D4wRh9k9nk4BTGwHTjfGauHzC972PlvDuFHfJnj9le4gd7
I68ZtudOYeYDUTHRT/1g+YTtOCFnCiuvco31bPMD04knS8/SpjD7INl4Fbof
2BeF/HgZgzzjcMpHwB/SXiufZbCbwuqd5rW2efiDcSNFYIl1CvuUKX2mxccf
FE5WagWzTGE/37udiQr0B8NWI1cawxTGA5/PzJP8IZiLkVIwP4n58z/X/pLs
D0dEv5s8HJjE9nUl6JY89ofHS2NqE6WTGFWT30CPIQBmaTs+s2hNYp5y3LK/
mAPgZeVecTe1SewcPwfHtS0BMHFajlynMolJz2x4188ZAOmf99oaSU1i/Tcm
znqLBoCp3D0lDs5JTGW+6uw/2gFwHFS/TfX+xOZyLc62XQ2Au5auT7OcfmKe
jOn6p8QDoTEtRvmR4wQmmbc4ffREEOwcFdzz3e4H9pszjzyhHgQPnPi/ipn9
wJqjDLbeOB0EtRQPjiD9H5i9XZEwg2EQjB/dLsV+/AeWtsfqXLNTEDSVGEV4
7PmBMV6uqza6EAQHuawjnneNYd3k2Divj0FA+LqU8+DsGJb3U26nQG8Q9CvD
fvLpMSzQaiDnzZcg2H90V5A+NoaxHVWqlBsNgnM5it+YZMYw9bmxicU/QbBP
YJn4ZPsYVuKpaxizNxhmrQ76m74dxc6b7eS/4RkMG5hWxHacG8Wmbc5mrfoG
w7080+fHzo5i1s7/7LEPCgb+1corflqjmGLABl7hiGAo7WYSn1AZxcYSZ3cV
XQwGX658C9V9o5h+XSf7k/JgsOkgPznzcwTbI3p1w+uFYGDNZXZxSBzB4iXf
RUsvB4Mes3F3QswINifHxnRpLRia+yyKn1FGsNcnYhiMN4cAx8Xii3JBI1ik
efDfHt4QyH0a0JBgPYKN/GOySDsWAkmtwh7vZEewBzNcEyvRISBWtY+36+sw
Zj8cJFITHwJ7DoVvK/o8jHH0fLAhJYXAia82++O7hjHf2kvv/lwLgR7B5XyH
jmFMIoHt6cLdEDjwPORtSsUwdkeAOWr6TQi4kBxLX18exgw5nKrKOkPgsB1N
Rf3iMMawoWHWtycEok6XFtcnDGO2Y1TXye8hgA3U7u+jDmN8j5Z1xudCAGB7
RazvMHZVa5abticUKBVcOsV6w9hJVSOD3L2hcEbcg151ZhibkXpwwVEkFF46
XWH6eGoYM9jpt/JNKhRoX20M958YxtgGxr9/gVCI751PlJYZxmKDBu93u4bC
eNeOyhXOYSz05nv1joehEFDMMr//Ow1b1vhlFVwRCgvP0owsBmhY5ARHiEAN
+nyDa37pfTTsgrJBoV9TKDBtqXwq8YmGZX94w8rVgz5P97PA/Q4a1sDy6qP1
31AwcKUC+zMadrpkYnIjUxg0br71sPoJDXtlzLqpjCUM9txk5vV7RMO6bmkf
ZeQIg/ZuneTxUho2ptJ2I39/GMgJKBYfLqBh2/2aXadOh4Hm/RihlWs07Mqu
EWq6bhikvy0r3nGVhvHUbLwOhmHgvbn7nFQqDRPacqoj1TIM7irt6AtNpmFH
cl/KKPmg99/1FjOMp6HfL/W/qalhMG7mpLs7nIZ9JX/bIZ4eBmaHWZ4mEGiY
swiD5IesMDh2V9N3LZSG+QRgNiL5aD3mkbSVILQfrHUvWivC4H15gv0RXxpW
iFUn7vgSBu7NTU+TndDzkT3TPL+HgdudVBtnRxo2Xc175+VwGGycvD573IGG
KSsTKkOmwsD10v2mFVsa1iqrMNa7FgZ7D2VMFVqi5xcqO3VnPwGqori+FhvR
MDZ7W8PlAwTADrNOVBvSMNmb22xMJAmgmfBR960BDSPs8Q5mOUIANTHVyTV9
GrZlp3iu5ykCLEq/y43XoWESzLkM8u4E4Ou1FBc/RcP01Y3YkrwJcHqh1clT
g4YFRjLyDPsTIKOw1a30JA2rWrGTSScSgIvRtfiEOg3Tmee3XU4kwM1D9ceo
GA3zl3/lYZJCgITBpYGuEzTsagAppOQKAa4M7dsqg9w/2Ztkl02AMNWVvrFj
NMx7JK36ZQkBvJkn0ogqNOySiGYL/0MCdIyzFw0dpWGPHec/hDwlQABBZ5MB
8sqA8fjB5wRgkWhIlFGmYRe7OXiT3hHAMFuBtlmRhpW2JoaazBKgmCO8VfAw
DeOatT7G+psAlB1y127J0TCSgAxTwwoB6l2PXxFB1grsvCjDQoQnG1k2yMvS
sEE+/vytvETYd7et010ajWtOeb4QIEKV52a9ZSkaVuZfL0vYT4SIbqHKFOSI
JueaYUkitPUq6NYdomHcfiWd9SeI8MjjdqqcJBq/Tr0edpIId0a/f/ogQcOG
XhraSWsRQWL16ccQ5HKehfEsQyLws699rxenYdoNJ5jCnImQpBd/wVOMhpF3
vZOVSiQCwyRLFMsBGtrhOwtDyUTQ/vnYol4UzfcMrsm8QoTVb+YJJGTu5zxa
m28Q4cOg/Pt5EbS+u4PdUBkRHp/fTPwjjMavyItmPiaCB/mpey0yuXbjhEEl
Ed4TL5+PRtbmvBda10AEg+eVBziQadUzF693EeH1DYZM5f1ofKTR2OAzEdL2
tVlsRH7Akc676SsRNv/SE+wUomEUF9X84DEizOxJyQ1A5mGPqTm7TIRp3yiR
qn00TNdx18RGoXCIPVhsF7KXhhmJhOV6i4bDhgyOL0bI5iM9Vp3i4eBtYLJR
DtnJM/vVrcPhoHi8T5suSMPCA4VLVTXCQTd9yjIIOfJIrOsdrXB43MH0zRQ5
bmFEcIteOCTItv9RRk4Nv5fyyTQcFoz4vjMgF0XLBQS4hcOR62TldAEULxpX
xHu8wuHX3Wx+CvJjlvnvJ/zD4U/n0ygX5PrEZ0ZsxHDIMCprUkDuScWOFCaG
Q9Wy/UIfPw1jydVb7C8Jh6hN3CLHkdlcyspOPgyH8vtnuSWROQ/ucL/3NBxY
F3LceZEFij/2hD0PB7ufdgcW+VD9eWRVxfk+HPzd57qeIquE1AYSu8LhZMCp
jEJkUNor+a0XrScjWJKBrFs9mFUyGA59bftbSchOLz3IWnPh4GvJev0Usnts
h0LZ73BY1P7bqIzse1pqatffcNj2PE3pEHJ4x7Tt0EYSMPhqTuxETu0MA8pu
EvDvSnYb2UPDMq71/qbxkSDMLy63D/mmmeoDnX0kWLZt43uPXNS3KsQrToJd
iZ41Ncj1Q7EbHquQgN3z+4005GyLu1nMGAk4jl5vvYgc9rZd3vQkCQIrckRi
kaWr2Z0XdEiw5c5D72B8fur1RmUbEkTFpO83RSZsrrG+4EACzou6tXrIxpSB
uV4XEqhkzURpIm/1FBYl+ZLA4FZ5rDI+X60ktpZKgsfHhe0FkU0q3gpsjyFB
s26QPA+yjNTME9sEEkTImEhwIo/wKI2sXSKBuNgXKgs+f7peU/0OCVpZrJ5O
86L66To0kFpAgvp5t9QJZNb+jWFD90iw0h2bNILc0KJdGPOIBEXHAnr68fk5
Hze1NJKgVGt3XTsy267FnN1taH/uFhCbkUcTeZXdX5PgZ3uSfgPyzVBb9y2f
SOCcqaBehc/XH2vVGSXBp7ch6sXIYy+3OmRPoP0iiVQVIr88KvXnJ50Et1UF
Tuchh4sGiif/JsEb/V05N/D5K8sX3m2JgEGJKpXLyI2BgvuFtkfAnx0nDZKR
c8agKoAzAq5suh32D/K5j7HjnHwRYKClvRSLzy9m1zE9FAECxY2NJORbQoeH
8mUjQGbcwpaITEo3IS0ciYCXKp0sYciHz18vTj8eAZPf+M8H4vMthdk+60dA
UhDPPk/kuhp32wTjCPiRkPbXDblfsLRc0TwC9I3zfrgg8wwpm15xiACXi2sT
DsgpXvo3dYMjoJ+V75Il8v3XV6aXCBGQt8W3xxy5XaZXvYgcAT79+YfMkFnm
nEY3xkeAc0bqojEyJYIo+/x6BPDT3dj1kbMH6qJ9bkZAlHR/qS5yFTB38eVG
QHzGqpkO8jxzCpFwPwIidxs2ayF7X8xrkHseAeekrrFpICfSf3B9exkBytAz
o45811DGLbk1AnbwzH9TQ6btqmKdeB8BdRkTnRiy1c23Jnm0COi5asN+DJnA
sKvQ6EcEaBktSqsipzla/mGYioAl8R8mKsgfDgzfsFmMAJZh8UfKyNplSyPc
W8nw8Pq9xwrI7jvgaNN2MgxHJTDhjguK/SdoJxnm5KJNjyC/UOKQfcdPBrnm
Y1vlkZXrRYkXZMjgslWiWBY/3/1eHUpHyPCIVVUQd3BMucCIMhkUHV2uySCX
a6k2qKuTobLzSoo08pt7kVy/NMngcdueE/dPtmbXHB0ysAn1ZEghH3xvwLpi
QgZWFfvyQ8ga8mk29yzIUL58Qg2347W+MnNbMoxXOHdJ4vFt4WryxI0Mx23F
NuHmHiTd8A0ng7KcWLI4cmefweArChnUn6Yew32pS/Sg5HkyxPlrTIrh+db2
tnz0H7QfFmCKm6FcuNH+BhmSrzGdOIhcW/R78/PbZGBPY/t7AM+H3Nd6AgVk
oH7+WYt7Li2su7cUfT+JVQ3cP8gd40b1ZCjbsttNFLkg7JbMg0YyzKycl8ft
HBASzN5GBubfnoy4B5z3rna8J8MLNcptEfy8dIJ2nBpC5ij+JYzH6ymtc7mj
ZMjT7G7FrYsJZDH+JMNL/8O3cbccbhGpmyODaoyJKe4aXj5lJRYKYLe92vcj
E3dOR1zbSgHrAbl7uBW3Nb2Y3U6B5wfGE3E/YPDTKd9NAcUt3Gdx+y6dvLSd
nwLniyMO4z40x9PlvY8CRm7V3LgLRhtsxcUpEMdZ9F0I2el7em68FAV4rXRb
ce/r8x4blqPARZ/yMtxZb7gD76hQwF03PxL3pSeesXy6FPjk8lACt14Z1k40
oMCofQc37q1FXOw9JujzAskbcMdm12VctaHAuF/WwD5k9bQrX2YcKLB5dvUV
boZL7vsNXSnQ+2y8Gnf4ec772/wocDNYJwu3Enl02isIrTf47B/cc6E1Cu1h
FPgcmROB29fT9XlcJAXAqt0Ot5Nh1Ye1yxRw5lKRxO2o9PB9dRoFPqbtFFy3
wL13YVkUOHLIZse6f1x/Q8+jwILn4T97cb+9/Lq4iAJDpyomcTs8ufDKrZQC
utduDuK2jyK2f62ggBZ7wut1uwW0ZdVQ4IRCzEvcdnoerWYv0H42farEbctr
0fy2nQJ/uIILcVs/UG54/oUC/1Rqxq07XfYFaZACHe/vU3BbkcXqlUYpsKpn
Gobb8gxPXdk0Bfy7nT3WLcNR6zVPgYEXLY64LXZtrjm4hParzdkat/n3xcqc
DVRQyj5lsO4W+jOrzVTwaYjVxm1WMlqxexsVXlX/1sB9jtj9JIWbCskkfxXc
JjsqHlDFqWBsQTq47sXSclVpKpQMiArjNv5SULZ4mAoi4ouCuI2K0kr8jlHB
aHjz7nWnJN+XVKOCxhfNnbgNQ+KKR0+h+QUF7LgN1EKL7M5SYVq4ZfO6D/re
5TOhwpP7sRtxn93mWthtToXEEgcm3Pq9pvlnHdHz7PVdEcTjLUDhNhZCBeua
ul+4dc2kbi0TqdD7Qp++7uOiORUUKkjwzv9c95ZdN2QSqLDwIGps3XS27Ikk
KtSRXUdw63QxZxVepkJ8mS0Nt/btuYy9WVTIzYr7tu74n+l9OVQ4wf5kAPcZ
H1paeh4VdlrN9ePWOvrxKnspFZjFcntxa75/dGmtngrutg87cU8zi+rrtFNB
tZT7Pe4s5TTW9E4qCMrce7M+33tT22A/FW4Xebxan59DiJMeoYI8v1E77szO
HyfD6VRoq7BvxX1qkxVj828qlPenNq/vR4VgXenGSKgUNH+J+/d4CmlpeyRM
SVyqx31HkPGoJk8kpKZK1q0/v1HgwmWhSDg6yl+DezF26NEXiUhgI5lXrY9P
NkmHHI8EfqH4Cty3Te4WsRlEQrRXyBPcC9WJInmOkXD62a9H6/sn7JOjGhIJ
vrRPD3FfVZl+lFEVCb+Jr8txDxgGtc6vRUK5pMK69aREqdI6UeC9acu6azZ3
K7ilRYFD4moZ7n220bty+qPgEbay7thHUvOf9kfDzcfL69bQpL277xYN3tf+
Z+bezPvR96OBlPw/j8tEShxZjIa5pP/5bZzL3WG181D2/75npnE2Lf485P2/
Y8WEFzRfn4fb/++4WlmskyfmPxudSLBz/s+B/rreob/+M9eWAK02Uuy/ZpSY
de/cEfevP59w7+u78Z9X+1RSsxTi/3XPrLBaevt/vrG2pnbZNOFfl1w5Gq/+
8z8X8bkKzhAu/GsrwaKSL0yJ/9q86ExUZMZ/BrEvBUIi//xr36ayNxyB//mG
Y/TC2vP//H/gsf3i
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3846914968669417`, 1.}, {114.59107725158087`, 1.}, {
      236.74911049221345`, 1.}, {256.76056183904427`, 0.9428571428571428}, {
      291.3795611893856, 0.6973684210526315}, {302.7691223953341, 
      0.8709677419354839}, {306.9774843293274, 0.9}, {321.3713064166033, 
      0.7631578947368421}, {353.00890878564394`, 0.6041666666666666}, {
      388.90573667473495`, 0.5652173913043478}, {399.77467851943936`, 
      0.7727272727272727}, {579.3079696222834, 0.6097560975609756}, {
      769.766201941892, 0.575}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.63},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.582360639235702*^9, {3.582360719005457*^9, 3.5823607561928797`*^9}, 
   3.582362393679514*^9, {3.582362917040278*^9, 3.582362932198719*^9}, 
   3.582371945522088*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c2", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c3", "<", "1000"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c9", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]2", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]3", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, 3.582371951668499*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "309.83216573863535`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c2", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c3", "\[Rule]", "258.23159975132523`"}], ",", 
     RowBox[{"c4", "\[Rule]", "547.3184670830867`"}], ",", 
     RowBox[{"c5", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c6", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c7", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c8", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c9", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c10", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c11", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"c12", "\[Rule]", "522.2934692139695`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "15.356956992597057`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "50.51415567146318`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009376756160534603`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9430684575903102`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h111", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.2760485254137748`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.7239514745862254`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "1.2155995224511844`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "0.749518749588369`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "0.749518749588369`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, 3.582365367556697*^9, 
   3.5823719552565055`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.582371966457325*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxN1nc8Vu3/AHB7J0RJEqFEVqRCXR+SkBCS7bb33qOo205mRsiokCKzZac0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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.2853529547726747`, 0.9615384615384616}, {
      112.99117197488845`, 0.9}, {184.72215259056946`, 0.9615384615384616}, {
      197.0000204005931, 0.9285714285714286}, {237.69418707566936`, 0.5}, {
      240.83830253257415`, 0.7575757575757576}, {254.91836710769198`, 
      0.6282051282051282}, {259.55932874106435`, 0.5}, {282.4677950806744, 
      0.22916666666666666`}, {312.5596460946832, 0.}, {324.74816091846253`, 
      0.015151515151515152`}, {459.7503932820281, 0.0125}, {625.7254889859321,
       0.01282051282051282}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.582360639235702*^9, {3.582360719005457*^9, 3.5823607561928797`*^9}, 
   3.582360826724854*^9, 3.582362402698875*^9, 3.582362943999839*^9, 
   3.582371970326132*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "4", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c4", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.5823653612844353`*^9, 3.5823654105051517`*^9}, {
   3.582365471582787*^9, 3.5823655244677963`*^9}, {3.5823655599036016`*^9, 
   3.582365578449512*^9}, 3.5823719764569426`*^9, 3.5823720365014486`*^9, {
   3.582372604306465*^9, 3.5823726341181173`*^9}, 3.582372664319771*^9, {
   3.58237270959105*^9, 3.582372738622701*^9}, {3.5823728007888107`*^9, 
   3.5823728386032767`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "459.5318408524895`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c4", "\[Rule]", "233.1277322877228`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "30.69349114501292`"}], ",", 
     RowBox[{"h14", "\[Rule]", "1.1008615040053822`*^-11"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.3095097582568042`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "1.4999999994498248`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.58237274355231*^9, 3.5823728044080167`*^9, 
  3.582372839695279*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.5823719977665806`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "4", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.5823654982722483`*^9, 
   3.582365500785478*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF1nk8VG0bB/AhLYSHLC1ESMlTUU9lKd0XRdkKSSQSZV+yL3Nm5kT2bCVb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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3720791435806172`, 0.3048780487804878}, {100.6841928621238, 
      0.3709677419354839}, {302.67322453268264`, 0.2692307692307692}, {
      334.73807348036877`, 0.2714285714285714}, {352.4137861661762, 
      0.23076923076923078`}, {378.1314227354539, 0.30303030303030304`}, {
      362.5361395313572, 0.28205128205128205`}, {393.7405540014166, 
      0.2916666666666667}, {437.639393228293, 0.3541666666666667}, {
      479.48396042365005`, 0.21739130434782608`}, {486.17534659310917`, 
      0.13636363636363635`}, {725.5654596461802, 0.0875}, {935.3091723301637, 
      0.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.04},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582365591052944*^9, 3.5823720020097876`*^9, 
  3.582372226216386*^9, 3.5823727714919586`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "5", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823724562154055`*^9, 3.58237255591518*^9}, {
  3.5823726837106047`*^9, 3.5823726862534094`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "419.0008366251904`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c5", "\[Rule]", "226.46045507196956`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "13.305430778965295`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5992785130987822`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9513370245311629`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "1.2586398100918805`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5823725578027835`*^9, 3.582372688889814*^9, 
  3.58237286295492*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.5823723058467407`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "5", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.5823658202841988`*^9, 
   3.582365821907732*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF0ns01HkfB3CXHGqVa/S45raLLo5OLNbj+2msS0tC0QVJRZLrfH/ua3Pf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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3366671260281537`, 0.975609756097561}, {114.39663997503841`,
       0.9655172413793104}, {208.53253483140503`, 1.}, {224.2544729387477, 
      0.9571428571428572}, {262.558953624026, 0.6842105263157895}, {
      269.31268853643826`, 0.8125}, {279.18315961131987`, 
      0.8076923076923077}, {288.0994284712159, 0.6625}, {314.9521037209728, 
      0.6666666666666666}, {347.76011467325947`, 0.5116279069767442}, {
      359.4505855671685, 0.7878787878787878}, {514.6877024216756, 
      0.5121951219512195}, {692.3635624014632, 0.5384615384615384}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.59},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582365823990773*^9, 3.5823723078279448`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "6", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582365829276966*^9, 3.582365856344453*^9}, {
   3.582365889939595*^9, 3.58236592054307*^9}, {3.582365953122541*^9, 
   3.582365987910283*^9}, {3.582372875481742*^9, 3.5823729035773907`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "213.00170632146634`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c6", "\[Rule]", "366.7068897117548`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "1.0002044451368357`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8383084582666908`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9457489882650024`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "0.6583828873781936`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, {3.582365853563912*^9, 
   3.582365859397491*^9}, {3.582365893931019*^9, 3.5823659227396107`*^9}, {
   3.58236595708976*^9, 3.582365996823018*^9}, 3.5823729089126005`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c6", "\[Rule]", "359.3696892892266`"}], ",", 
   RowBox[{"\[Sigma]6", "\[Rule]", "1.0199154229116074`"}], ",", 
   RowBox[{"h16", "\[Rule]", "0.8383084114058181`"}], ",", 
   RowBox[{"hp6", "\[Rule]", "0.9457489137777477`"}], ",", 
   RowBox[{"angle6", "\[Rule]", "0.7108514159302055`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.582365866033083*^9, 3.582365929369907*^9, 3.5823660006099358`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "6", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "6", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.582365869921318*^9, 
   3.582365872258019*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF0ns81PkaB/BhSEpyq0hybTes3WpzkjbfBxstyi1lCYWs+7j0+05LIVYu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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.4102858355948837`, 0.9878048780487805}, {108.5482263231891, 
      0.9852941176470589}, {284.3183324634396, 0.9875}, {312.4625047894904, 
      1.}, {337.17190239179814`, 0.9868421052631579}, {357.9281485342006, 
      0.9545454545454546}, {349.6743349005067, 1.}, {375.08274816354924`, 
      0.8375}, {415.2670137938885, 0.7083333333333334}, {455.8082912251839, 
      0.8695652173913043}, {464.2905210340355, 0.9545454545454546}, {
      686.155481912727, 0.7926829268292683}, {893.4702531722273, 
      0.85}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.84},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582365878769026*^9, 3.582365930794922*^9, 
  3.582366001883451*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "7", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366009624846*^9, 3.582366027938717*^9}, {
   3.582372922562624*^9, 3.582372944839463*^9}, {3.582372984385533*^9, 
   3.5823730101567783`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "368.06980522903626`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c7", "\[Rule]", "335.6098620679307`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "20.09148376927839`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.14327052370242166`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9860993804084437`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "0.8850888277835093`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, 3.582366031125976*^9, 
   3.582372946929867*^9, 3.582373012278382*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c7", "\[Rule]", "335.60986004693126`"}], ",", 
   RowBox[{"\[Sigma]7", "\[Rule]", "20.091483264529398`"}], ",", 
   RowBox[{"h17", "\[Rule]", "0.14327052387009123`"}], ",", 
   RowBox[{"hp7", "\[Rule]", "0.9860993761675882`"}], ",", 
   RowBox[{"angle7", "\[Rule]", "0.8850888398454779`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.582366034540392*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "7", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "7", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.5823660399483967`*^9, 
   3.582366041435528*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c81d0fAHAkSRIVSZJIoYxKCDkfQrLJKptrbzLutS7ZRdPIzIhIVqVC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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.4071919899189052`, 1.}, {113.34995647740965`, 
      0.9833333333333333}, {257.02022069993495`, 0.9358974358974359}, {
      280.30863774557497`, 0.9428571428571428}, {311.47876982326454`, 
      0.631578947368421}, {326.535004171145, 0.7272727272727273}, {
      326.04347298527915`, 0.7307692307692307}, {344.7582812992528, 
      0.5138888888888888}, {379.9374550087456, 0.20833333333333334`}, {
      417.9313257173161, 0.06521739130434782}, {427.9929519077422, 
      0.046875}, {625.2782013058215, 0.1625}, {823.9023020684212, 
      0.25}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.15000000000000002`},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582366042584867*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "8", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366049340494*^9, 3.5823660940738583`*^9}, {
   3.5823730603888664`*^9, 3.582373087548514*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "533.8111994547962`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c8", "\[Rule]", "229.29547890106443`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "1.3391954413730207`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.1521739131129389`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.35932400938767683`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "1.3099941071009307`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, {3.58236607127101*^9, 
   3.5823661108422747`*^9}, 3.58237309094932*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c8", "\[Rule]", "228.50922608373958`"}], ",", 
   RowBox[{"\[Sigma]8", "\[Rule]", "1.0025000214800925`"}], ",", 
   RowBox[{"h18", "\[Rule]", "0.15217391349741943`"}], ",", 
   RowBox[{"hp8", "\[Rule]", "0.3593240098306671`"}], ",", 
   RowBox[{"angle8", "\[Rule]", "1.3125986264573364`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.58236611387846*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "8", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "8", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.582366122573277*^9, 
   3.5823661240520763`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF0nlUU3cWB/AgIJaClaUele1ENsFxJI5UCMrvIhAdF2SRTSkiBiu899gF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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.2221901554899004`, 0.4634146341463415}, {
      110.52795054379182`, 0.38235294117647056`}, {159.2945983968051, 
      0.39473684210526316`}, {168.03060626908658`, 0.44285714285714284`}, {
      210.71841764029168`, 0.44871794871794873`}, {210.2420829899435, 
      0.6212121212121212}, {228.3770874526455, 0.3125}, {228.72126993455535`, 
      0.2916666666666667}, {247.4901374617245, 0.1875}, {274.5963284799126, 
      0.08695652173913043}, {287.1654011586908, 0.07352941176470588}, {
      400.76561779399077`, 0.175}, {553.536398588259, 0.2125}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.15},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.58236611504954*^9, 3.582366126100182*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "9", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"200", "<", "c9", "<", "400"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "40"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c9", ",", "221"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1.3"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366140847068*^9, 3.582366183271599*^9}, 
   3.582373053010053*^9, {3.5823730967681303`*^9, 3.5823731192009697`*^9}, {
   3.582373163364647*^9, 3.582373190742695*^9}, {3.5823732427063866`*^9, 
   3.5823732728456397`*^9}, {3.5823733462905684`*^9, 3.582373361547395*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "512.6004340531318`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c9", "\[Rule]", "221.78563831910023`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "2.8465686955092973`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.30290617802106207`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.6954289155479275`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "1.3574795079017388`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, {3.582366167477119*^9, 
   3.582366196869463*^9}, 3.5823731597454405`*^9, 3.5823732296803637`*^9, 
   3.5823733149501133`*^9, 3.5823733658686028`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c9", "\[Rule]", "221.78562354982054`"}], ",", 
   RowBox[{"\[Sigma]9", "\[Rule]", "2.8465680460985507`"}], ",", 
   RowBox[{"h19", "\[Rule]", "0.302906178351202`"}], ",", 
   RowBox[{"hp9", "\[Rule]", "0.6954289120505757`"}], ",", 
   RowBox[{"angle9", "\[Rule]", "1.357479551035095`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.5823662004401207`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "9", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "9", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.582366205341642*^9, 
   3.582366206886334*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF1Hk0lW33B3CUBqWENJBZESmJMuTalFJKUiki4uDMB5mnMiZ5UcZIE5nH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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.1890367780902473`, 0.8902439024390244}, {
      109.03483211460217`, 0.7571428571428571}, {147.00760259728347`, 
      0.7777777777777778}, {154.07496942253374`, 0.8714285714285714}, {
      197.55042042040188`, 0.6666666666666666}, {195.39837483831127`, 
      0.7575757575757576}, {215.3541372655959, 0.725}, {213.70667615738228`, 
      0.75}, {230.49803986385047`, 0.3333333333333333}, {256.1347549993931, 
      0.2608695652173913}, {268.84009858011945`, 0.10294117647058823`}, {
      372.1637317140108, 0.4625}, {518.3308920672541, 0.3375}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.3},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5823662019574337`*^9, 3.582366208443493*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "10", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366221575227*^9, 3.582366244338175*^9}, {
   3.5823662806862173`*^9, 3.582366282150181*^9}, {3.582373384635436*^9, 
   3.582373424758706*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "92.43754184663244`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c10", "\[Rule]", "523.301034112735`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "10.035876157787715`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.54087001282317`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9548224714796483`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "1.4849593802599572`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, 3.582366249338421*^9, 
   3.582366282832837*^9, 3.5823734278787117`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c10", "\[Rule]", "347.4139197468966`"}], ",", 
   RowBox[{"\[Sigma]10", "\[Rule]", "37.18927464218809`"}], ",", 
   RowBox[{"h110", "\[Rule]", "0.9792576405149448`"}], ",", 
   RowBox[{"hp10", "\[Rule]", "8.840329084472536`*^-8"}], ",", 
   RowBox[{"angle10", "\[Rule]", "1.463895753202421`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.58236061897169*^9, 3.5823607352760477`*^9, 3.582360815798418*^9, 
   3.582362400708293*^9, 3.582362939747641*^9, {3.5823662601669407`*^9, 
   3.582366287623032*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "10", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "10", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.5823662656687107`*^9, 
   3.5823662672527227`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF0X0w23ccB/CgazvVrVY2jnlKu0MZ22rT1OQT1aymaJ2nTktRJR5SokHj
IckvDyweVtaScZEdWlOUompouVspulEPFc/bDXdr7VaTYjc92fr9/k7+eN/7
Xv++39aRl/yjdSkUSsj/ed1jvbTNdygr9M7pHEujoBf0TYrqviWLCjWkKwKo
hRasj0FCOqXhE5H11FFgkj6gZ+NWXO0BU1PYfwwxmFKDL8CZdENZxCneZW+w
msS2cnMx8+3zg/QJ7EH2DvU+A39YGMO+c37xmSoqAIhhbLn/w98qOoOgqh/b
wSjJMnw5BJYeYPc8NQuzNAuFzCZsov3z211XzkHgd9jHysO3zkyGw540bHZr
YqnaOALsmdi08jqnDnokSCnYc6zh+KzAKODelCILXNU1EH8BKh2wO94bTeDI
o+EQT4KsXm/6qLr3IhjIxMh6D7hlo/MxsBUlQt4voenp/BMLJstC5EKGw9ma
PXHwgakAWX/r/bs+lvFwdyIL2fzxYEnklwlwdpiH7CRPS0/jJoKnSRqyiY/+
Vm4+G+AFB5miqxCVVV2COn023iNq7cReVhJYTccg85nmp3woyXCv+Tzyy6oz
fgPXksGpPQQ5TqfU97gdB1hDfvgP/0fK7hYOVDYxkQ9Vb6wccU+Bc7NuyKLg
/eaKuMswnnsQ/7VqtPyK4ML1w28hp1aMeDxuToX25pcWr11D75QZzqUBc3UW
+Xa/LDVAnQ6DpgPIWcZPnB1lV2C8oBv5ZKTx8hvWPGhVtyHvrPLZmG3gwcTP
jcg9CxK9VloG2PFrkZ2V47sePcwAN4tq5O+/ohpM+2YCPVuJHFoxHFC9mAle
nuXI7/6eoWDzsgAGSpG7TM1cP9uZDfE215GjTneMaoqyYferYuQAw3t3+HZ8
4FKLkJkjLVc1PXzgt32DvCFZaJmzF0DhjUJkb2qi8ihXAMGTBcjXaCst8g4B
uHlhz59O6V/TCKBsPh/Zx/Eg/0NvIdTJsLt2q1xiSoTA98O2CiOMlbNC+NEW
W9LiuDZhQ0DeXmxP5uKT+hgC3t7MQ94xVVZP1BMQ+hf2cyeB/eENAuyWsIel
0T8sMUTg+iv2rWBPv5IcEdyYwZbYUteZv4ggaApbet+ZPmYihl4VaX/33PAL
YhidwM6MOP7v81ti8CLNSTqZkPq3GDaeYv/UFTat/FQCfaSN3kw+MZAhgVrS
MtPmkKE+CZSQ1rFXx44ZSiGfNLvVsVIVLIUc0tPusTMzCimISScUjLR1PpMC
QXprhlZc7pIDQtLLMY0sU4HWk2oqo3RQa4VGwygKzN12w7dHcjz+1LrW7KLF
avrX2w61qG2Y05VtO6TWSyiQaw22czetD+Rtm93bOLSPo7UikljXdGv9H43J
b/o=
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.100988657691051, 1.}, {104.62329663861019`, 1.}, {
      116.73730328418911`, 1.}, {119.79750092989688`, 0.9857142857142858}, {
      164.78803369445095`, 1.}, {158.68621301385699`, 0.8787878787878788}, {
      182.7919790929468, 0.95}, {176.44274643228204`, 0.9305555555555556}, {
      188.4175504242208, 0.9791666666666666}, {210.3692879567103, 1.}, {
      223.29507840556107`, 1.}, {301.45911720719226`, 1.}, {430.8175628859688,
       1.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.9792576405000001},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.582366262333308*^9, 3.5823662885716553`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "11", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366304856998*^9, 3.582366335292238*^9}, {
   3.582373436099926*^9, 3.582373465677578*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "334.520986323923`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c11", "\[Rule]", "286.82039597039903`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "15.942368829545222`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8796601768272798`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "1.099369343600928`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, {3.582366326860291*^9, 
   3.582366335844215*^9}, 3.5823734711843877`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c11", "\[Rule]", "286.8203956536713`"}], ",", 
   RowBox[{"\[Sigma]11", "\[Rule]", "15.942368809547721`"}], ",", 
   RowBox[{"h111", "\[Rule]", "8.479121314966501`*^-12"}], ",", 
   RowBox[{"hp11", "\[Rule]", "0.87966017669484`"}], ",", 
   RowBox[{"angle11", "\[Rule]", "1.0993693447532296`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.582366339905179*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "11", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "11", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.582366344331088*^9, 
   3.582366347557522*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c8Vf//AHCrZSUre2soK4Vwzvttleydyt577yIJiYooZGcmIyQJIZRZ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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.345079195860737, 0.8414634146341463}, {114.54235928313406`, 
      0.8793103448275862}, {212.8840340929461, 0.9210526315789473}, {
      229.25111985259946`, 0.8714285714285714}, {267.05438484572545`, 
      0.4358974358974359}, {274.49486437310907`, 0.6818181818181818}, {
      283.54512308291777`, 0.6125}, {293.27378802069995`, 
      0.3055555555555556}, {320.8556654230216, 0.16666666666666666`}, {
      354.15025246416303`, 0.}, {365.7322270251813, 0.}, {524.6913280632925, 
      0.}, {704.4237098812558, 0.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582366349888043*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"llcline2", "[", 
       RowBox[{"[", "12", "]"}], "]"}], "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582349227641554*^9, 
   3.582349255696924*^9}, {3.582360791030731*^9, 3.582360808207068*^9}, 
   3.582362936818439*^9, {3.582366304856998*^9, 3.5823663836810293`*^9}, {
   3.582373482541208*^9, 3.582373510761657*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "312.5694893981429`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c12", "\[Rule]", "202.66449032968868`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "15.456428969662944`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6818762035889939`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999996775414`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "1.3907638209027298`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582349261808329*^9, 3.5823583897949*^9, 
   3.582360239437022*^9, 3.582360734101433*^9, 3.58236081308438*^9, 
   3.5823623985371103`*^9, 3.582362938039165*^9, {3.582366326860291*^9, 
   3.582366335844215*^9}, 3.582366386111876*^9, 3.582373513850463*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"estim1", "=", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c12", "\[Rule]", "202.66549268778678`"}], ",", 
   RowBox[{"\[Sigma]12", "\[Rule]", "15.456483978667762`"}], ",", 
   RowBox[{"h112", "\[Rule]", "0.6818761378767805`"}], ",", 
   RowBox[{"hp12", "\[Rule]", "0.9999999995870265`"}], ",", 
   RowBox[{"angle12", "\[Rule]", "1.390760947758879`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.58236061897169*^9, 3.5823607352760477`*^9, 
  3.582360815798418*^9, 3.582362400708293*^9, 3.582362939747641*^9, 
  3.582366339905179*^9, 3.582366395463378*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClineGen", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cline2", "[", "x", "]"}], "[", 
        RowBox[{"[", "12", "]"}], "]"}], "/.", 
       RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"First", "[", "distX", "]"}], ",", 
       RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".02", "]"}], ",", 
        RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlotGen", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"gen", "[", 
       RowBox[{"[", "12", "]"}], "]"}], "/.", "estim1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"ClineGen", ",", "PlotGen"}], "]"}]}], "Input",
 CellChangeTimes->{{3.582341639640217*^9, 3.582341643599588*^9}, 
   3.582341728480423*^9, {3.5823417795085382`*^9, 3.5823417821403522`*^9}, {
   3.582358906240758*^9, 3.582358935025899*^9}, {3.582358974694372*^9, 
   3.582358976061802*^9}, {3.5823605516757936`*^9, 3.58236055394811*^9}, 
   3.5823606327815866`*^9, {3.582360704436459*^9, 3.582360708429042*^9}, {
   3.5823607430729027`*^9, 3.582360754863721*^9}, {3.5823608213687477`*^9, 
   3.582360823641323*^9}, 3.582362942259286*^9, {3.582366344331088*^9, 
   3.582366347557522*^9}, {3.5823663999649363`*^9, 3.582366402251563*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k8VN//B3B7RIjSroSSilRSpPuWJfu+77vsYzZKtCGkksi+lSUhQlIk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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.1629017390338858`, 1.}, {107.78563255339083`, 1.}, {
      137.70361844176222`, 1.}, {143.52422755218177`, 0.9857142857142858}, {
      187.52729536771403`, 0.7948717948717948}, {184.13523949211515`, 
      0.9393939393939394}, {205.41543219748533`, 0.8875}, {
      202.29298962889428`, 0.9305555555555556}, {217.59587703234018`, 
      0.7708333333333334}, {242.10939595005433`, 0.6304347826086957}, {
      254.8992816076771, 0.5909090909090909}, {350.4667906654615, 0.75}, {
      491.54619720882243`, 0.7}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.68},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.582366349888043*^9, 3.5823664058112917`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M1 = 1 angle, 1 center, 1 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582350230846575*^9, 3.582350244356709*^9}, {
   3.58363732371876*^9, 3.583637361063974*^9}, {3.5838109978580647`*^9, 
   3.583810998656052*^9}, 3.583811034986814*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.5836374095447073`*^9, 3.583637425292088*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",",
      "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", 
     ",", "angle1", ",", "angle1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", 
     ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, {3.582349294302116*^9, 3.5823494116368856`*^9}, 
   3.582369745063218*^9, 3.583637400664949*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.583637451638151*^9, 3.583637464865089*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"250", "<", "c1", "<", "350"}], "&&", 
      RowBox[{"15", "<", "\[Sigma]1", "<", "23"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0.8", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823745976311665`*^9, 3.582374623152811*^9}, {
  3.582374677908907*^9, 3.5823746960361395`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4395.167099876065`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "292.7566045078848`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.263524442109716`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.24012093904109857`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9833299889310563`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.5953734767766128`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999800016967`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.010338051609753545`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9526969736875126`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.12526521277191008`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.23661002051600552`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5514778768449795`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9393409548887351`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8446176761852404`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9505748309280684`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.13885277711516505`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9811835293380836`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.15544137842793157`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.37841775534061717`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3309825023295864`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7818041134825114`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.957972796867025`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9579728063404385`"}], ",", 
     RowBox[{"h111", "\[Rule]", "1.864976543692108`*^-10"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8821057277608165`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6917159989024888`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999991486084`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.0810672027369257`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.582374627130818*^9, 3.5823746489396563`*^9}, 
   3.582374702806551*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", 
     RowBox[{
      RowBox[{"200", "<", "c1", "<", "400"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]1", "<", "40"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5823736600695195`*^9, {3.582373701378392*^9, 3.5823737356516523`*^9}, {
   3.5823737835749364`*^9, 3.5823737954777575`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4395.167122928825`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "292.75650863556143`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.263509496043653`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.24012092669420582`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9833299449319647`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.5953736891714262`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999991772039724`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.010338062744906352`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9526969287304915`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.1252651984144954`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.23661003531635721`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5514778691291453`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9393408857447236`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8446176581842175`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9505747986439402`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.13885277878325464`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9811834506734438`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.15544136154395186`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.37841776026795854`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3309824877761883`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7818040714517703`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9579727677024439`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9579731809749911`"}], ",", 
     RowBox[{"h111", "\[Rule]", "8.806499621215753`*^-9"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8821056662201573`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6917159780228255`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999598751079`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.0810676052254875`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.582373742936865*^9, 3.582373801982969*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Estimates and graphics", "Subsection",
 CellChangeTimes->{{3.583637489509635*^9, 3.5836375043593817`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"estim1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "292.75650863556143`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.263509496043653`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.24012092669420582`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9833299449319647`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.5953736891714262`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999991772039724`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.010338062744906352`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9526969287304915`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.1252651984144954`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.23661003531635721`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5514778691291453`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9393408857447236`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8446176581842175`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9505747986439402`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.13885277878325464`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9811834506734438`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.15544136154395186`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.37841776026795854`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3309824877761883`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7818040714517703`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9579727677024439`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9579731809749911`"}], ",", 
     RowBox[{"h111", "\[Rule]", "8.806499621215753`*^-9"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8821056662201573`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6917159780228255`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999598751079`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.0810676052254875`"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.582360576598627*^9, 3.5823606114429626`*^9}, 
   3.582964895246058*^9, 3.583637526145331*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "13"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"ClineGen", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"cline2", "[", "x", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "/.", 
         RowBox[{"T", "\[Rule]", "4"}]}], "/.", "estim1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"First", "[", "distX", "]"}], ",", 
         RowBox[{"Last", "[", "distX", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.1"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", ".02", "]"}], ",", 
          RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotGen", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"gen", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "/.", "estim1"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"PointSize", "[", ".012", "]"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Show", "[", 
      RowBox[{"ClineGen", ",", "PlotGen"}], "]"}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.582964948770933*^9, 3.5829650148579473`*^9}, {
  3.5829650804753847`*^9, 3.582965085321822*^9}, {3.582965123344833*^9, 
  3.582965125878248*^9}, {3.582965162171122*^9, 3.582965162674317*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k4Vd33AHCikZAQIopKCilJlL1IJUmmJPM8z9O91x2STEmoFBnLWDJV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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 1.}, {114.64600693572409`, 
      0.9705882352941176}, {217.0658691486482, 0.9875}, {234.0580961452382, 
      0.9285714285714286}, {271.3585734069022, 0.6052631578947368}, {
      279.4678829063734, 0.8253968253968254}, {287.7132488621885, 
      0.7435897435897436}, {298.23280345575165`, 0.625}, {326.51819304355257`,
       0.3541666666666667}, {360.2771694792396, 0.17391304347826086`}, {
      371.7491559375691, 0.13636363636363635`}, {534.2929569908707, 
      0.4024390243902439}, {715.9748714461863, 0.1875}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163189259*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k4VV0XAHCJJpKIZCpToYQSopxFkXkOGa55nuc7mkqEShJFqBRRytRI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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 1.}, {114.64600693572409`, 1.}, {
      217.0658691486482, 1.}, {234.0580961452382, 0.9428571428571428}, {
      271.3585734069022, 0.6973684210526315}, {279.4678829063734, 
      0.8709677419354839}, {287.7132488621885, 0.9}, {298.23280345575165`, 
      0.7631578947368421}, {326.51819304355257`, 0.6041666666666666}, {
      360.2771694792396, 0.5652173913043478}, {371.7491559375691, 
      0.7727272727272727}, {534.2929569908707, 0.6097560975609756}, {
      715.9748714461863, 0.575}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163311532*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c4l+/3AHChSdIgFTIryUpGqPtQdrYke++998obSVFJQkZWiYwoRUiK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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.9615384615384616}, {
      114.64600693572409`, 0.9}, {217.0658691486482, 0.9615384615384616}, {
      234.0580961452382, 0.9285714285714286}, {271.3585734069022, 0.5}, {
      279.4678829063734, 0.7575757575757576}, {287.7132488621885, 
      0.6282051282051282}, {298.23280345575165`, 0.5}, {326.51819304355257`, 
      0.22916666666666666`}, {360.2771694792396, 0.}, {371.7491559375691, 
      0.015151515151515152`}, {534.2929569908707, 0.0125}, {715.9748714461863,
       0.01282051282051282}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163444438*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c81d0fAHAkpWQVoexRoZBNOR9EspIUZe+913UHUhJJQ6mQhpCeFJJk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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.3048780487804878}, {
      114.64600693572409`, 0.3709677419354839}, {217.0658691486482, 
      0.2692307692307692}, {234.0580961452382, 0.2714285714285714}, {
      271.3585734069022, 0.23076923076923078`}, {279.4678829063734, 
      0.30303030303030304`}, {287.7132488621885, 0.28205128205128205`}, {
      298.23280345575165`, 0.2916666666666667}, {326.51819304355257`, 
      0.3541666666666667}, {360.2771694792396, 0.21739130434782608`}, {
      371.7491559375691, 0.13636363636363635`}, {534.2929569908707, 0.0875}, {
      715.9748714461863, 0.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.5829651635636053`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k4Vd33AHBERTJGZA7NSFSi7EWTVOakzPM8T3dESoSkiTIWRYoQTaaE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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.975609756097561}, {114.64600693572409`,
       0.9655172413793104}, {217.0658691486482, 1.}, {234.0580961452382, 
      0.9571428571428572}, {271.3585734069022, 0.6842105263157895}, {
      279.4678829063734, 0.8125}, {287.7132488621885, 0.8076923076923077}, {
      298.23280345575165`, 0.6625}, {326.51819304355257`, 
      0.6666666666666666}, {360.2771694792396, 0.5116279069767442}, {
      371.7491559375691, 0.7878787878787878}, {534.2929569908707, 
      0.5121951219512195}, {715.9748714461863, 0.5384615384615384}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163691642*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c8ld8fAHAiJZKVPRIqVIgQ8nxIEhmhsue197ybkhEVlZHKqIiGFVpW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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.9878048780487805}, {
      114.64600693572409`, 0.9852941176470589}, {217.0658691486482, 0.9875}, {
      234.0580961452382, 1.}, {271.3585734069022, 0.9868421052631579}, {
      279.4678829063734, 0.9545454545454546}, {287.7132488621885, 1.}, {
      298.23280345575165`, 0.8375}, {326.51819304355257`, 
      0.7083333333333334}, {360.2771694792396, 0.8695652173913043}, {
      371.7491559375691, 0.9545454545454546}, {534.2929569908707, 
      0.7926829268292683}, {715.9748714461863, 0.85}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163811409*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c8lt3/AHArFRJCFKJoKCuSB3U+RImSlWTvvdftXkSRPJRUCKEU1SNR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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 1.}, {114.64600693572409`, 
      0.9833333333333333}, {217.0658691486482, 0.9358974358974359}, {
      234.0580961452382, 0.9428571428571428}, {271.3585734069022, 
      0.631578947368421}, {279.4678829063734, 0.7272727272727273}, {
      287.7132488621885, 0.7307692307692307}, {298.23280345575165`, 
      0.5138888888888888}, {326.51819304355257`, 0.20833333333333334`}, {
      360.2771694792396, 0.06521739130434782}, {371.7491559375691, 
      0.046875}, {534.2929569908707, 0.1625}, {715.9748714461863, 
      0.25}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965163938526*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c41t/7AHAyGmaUjISinZFRUc5NklSyQvbeez6egchMS0WZhUjZadnx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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.4634146341463415}, {
      114.64600693572409`, 0.38235294117647056`}, {217.0658691486482, 
      0.39473684210526316`}, {234.0580961452382, 0.44285714285714284`}, {
      271.3585734069022, 0.44871794871794873`}, {279.4678829063734, 
      0.6212121212121212}, {287.7132488621885, 0.3125}, {298.23280345575165`, 
      0.2916666666666667}, {326.51819304355257`, 0.1875}, {360.2771694792396, 
      0.08695652173913043}, {371.7491559375691, 0.07352941176470588}, {
      534.2929569908707, 0.175}, {715.9748714461863, 0.2125}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965164062374*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13k8lcsbAHBbUslWIkJCWbJljWoeokR2SfZ93x3L2ZBCJKlQSVQKudb2
7FvShujYQrJ3qJRo12/ee3+fe/855/P9PO/MmZn3mZnnSLqHWHmxsbCweOMP
4rvnkc5PAZZ5xFbNoS9rM4t+svTVSfhJwfzDf5xnI5Uu7rcDKP93RJnaMckB
XYB7/1iafcuus9f1IezqP57p0NuXxL0f0tX/cVmOmwWFZALxa9n+9uZdGqJm
bebAIvdNj/DTYI4FPm4r6Ot8/rerXCfe9XnYwFmjn0D4glXraF6NLWS89d5N
+Ld+yHz6/sPQdi5Fl7C7mghLXM9hGMtZ0Cac+dfHldEb7WCMaaZF+LHUI94Q
FzsoeO6qQfjHpRwhnxt28Glhkxrh7etDJVxm7UBcLFKFsHOa4bbDqkcgpdFO
kfAZDlFl8+gjYFxzR45wSeMKNZOcI9DGe3Mb4VbavOb+uiMQNBsuQ3jpy6M9
iN0eNOrJmwnzVlXq6261B0fbCjHCskGX9mkdsIdj5X+JENaXSzJWC7SHby7+
QoQdJkPNlE/bg1PV1DrCvnu9Lcqu2MNGz9UChElXHawUbtnDTIYoH+F0p322
2xj2YJTOzk24kSHqLCHqAHObGWyEeydyjdYrOcC3W8IshOcWxNRW6TmAHy/6
vQ1bWGAz14K3A3wIUf5KWEny6udpsgOY/VxaIGygsmV4KM0Bup1z5wmHmknf
aruF26tT3xFOcrqRW/PIATTbqyYJ5wZuTa7sd4CSqMa3hNtTZR1zlh1g4onL
AGHJx9s5g40dYcw3qo2wdm/ZvLuTI6yw3tNE2GxS6fXhUEfY/KuzhjCFXbVS
L9sRmriMKglnCNzK0bzpCPHf5EoIF0qqJSrUOoJO/fMCwt1Iw15wzBGUloyz
Cc+Y3TNYvegID/dKnia87KSl/GelE5htKk8mLE/byfFO0QnK149GE054sLu8
luwEFxrNbQhfeFx/oSrNCZLKE40Jl/eiY4X5TiBw3g4ID37Rs8t4hNsbtskT
nmdv0U/sd4JfCkckCHOuM1CkzDrBWhPyOsI7VPexefI7w8Fh8x9bsY3g8Zyd
tDPk6f+eI+xsbtRnquUMts0ybwinBhmXajk5Q53MqybCYzfNbNfcdIZCNv54
wt8edAJLrTOUjrEFE+Zpt1BY7HCGYKW9DoR1pqxY3nxxBm5Gphphi8UeZs9K
F/A6fkGcsDfHIUa7iAuUGHRyET675XDJLXCBtK/3B2Wwi1X7M4usXYBhYN9M
uB6OxOV6u4C8Dd9NwkxnB5ukNBeI8suKILz3ksvykX4XyD7D9ksau5I87rPE
dIGui29eE95k5/Py7G/8e7qnqwlTU7W6vfhdQX3lLhLhW+TvnHdEXEFKRcqc
8IxvjS6btCu0z1bKEj60H93I03SFeO6MPinsNE3WwTnkCoMh7aWEm2VaeHQP
uIKvY2Q8YSWO/TF9Dq7QvHtpC2GuJjMTvqOuwMPy22oL9p5KvnjnVFcw8zYU
IRyZ332n9JwrdIinvJEk1ptuK36g0BUs3Go9CAsHCVufr3AFpcjkLYTNHAeT
Jx+4QuUUx5vN2DU6zp+OPnMF8bjHFoQ/y23e2vXKFa57ja8gLLtxzF58xBV6
JVweSBDn1Vev1up5V2gy3yRIOPhO0PkFQTfgLuT/Swz7eoHycz0JN3hVk2lE
+PXZTywZsm7gJlg1tonIn7BI/+26bnDdcC834VhXrXyKgRuUPaZfEsW+Y/69
p93UDUr6BrcSllSi7/ZydQOfQaqqCLadGAq/7ecGJ3/SKjcS5wk3axFrhBuU
fxdRIPyDeZwvL9ENwq7lCghjvypKG+8tcQOu8wmFgtirz5sJy9xxg8MFu5fX
Y+sl8ZlG1LkBn5KtBeFyz8x7vF1u4Dw8MyaAPWFtO+s04Abi2hxShEX2Cm8u
HXMDx4AGR37sZMncFKNFN+g3MKrlJfKNz7k+e9kNSMV/veXB/vJHYmFipTtY
mgz+WYvtOlLgeFTEHX5l3pbhJvL90l/K1cgdJvwq+biwKx6mHfA1cof8cPFV
K4n7qj/IY4OlO8jdzfy+gtgvgirnw93d4WxqVRM79jE1/qrNAdiSoxfYiP1l
+flpR4Q7GM9s9WHFHk+/syyf6A66qT+nl63x+pVlCQ+ccodwGkfOb+yOZ1E7
krPdIeqBqP4v7AdcO73Hi9xBcJVdxHfstIS6F5eeusMDSYblAjbr1bzpAz24
/1S50k/YUQ1xrN9eu8PT+5t/fMR2/aWnYfMez2fHpZA5bPWotlxuPg8w0mu4
N4F9M7PoXrWwB/C81bw+hi1++0SXr6QHpLc6JYxic80bczza4QHetfy8Q9jD
fp0B9EMeEB76zqkb2+pEZaKCsweYhLW0dmK3F57JH/D2AL6t94VfYN8at+7R
iPGAniBm4mNr4rzv1/mQ4wFK5e3eNdg/qQ9tcgs84Dn7i20PsENzcoKNSz3g
296sl3ew7fscrxXWecCGPZzDZdhKlm9XuYx6QOCt0qY87IKQZqm17zygQ0Hh
fg62cHrB7ppPHrCnXz0jG5vtmVeYELsnbK1kZZ7C7jNg9nfKeMKSqeY2KvZB
j2ef6Uqe0P30jVQUdvPRUu7tWp6wLP3ydyh2aX0wnDDyhDtC/Pu8seO1F4og
wBM20s/ymGNTlEU0S0ie4AH+NkbYpK16retiPYG5O8VXD9tn/enRqQxPuPLJ
fGkHttm8/MZT9zzBKX/T0XXYRtOWRUsNnlC+M15gDbb+SIyG6xP8+6wPvNmw
NZ+3WaoNeQJJZ6/lvNUsEit2Tx1g9YLCk2tYnmBvyE8R3rvGC27VnyXXY/Nl
VxaWrvcC9pNKxbexOY4vN8dt84K30yxil7HnXHJ+yph6QXGXomIg9pRtU8pp
Wy/I2Nso5II9ajoj9N3FC6h2PwotsXt0NdWfh3vB9bSDJRrY1ULdgeEXvKA/
c471uyU+H3i+/3h91Qu2n8zsnMEuX7E5xfAvL7AZd1Lqx766EHRDuN4L/JvS
Mu9in+hcNVI/7gXZqiV3/LET2lQCZd97gSI/T50tNq3u8I8zS16gUkRD+tgh
f93Y4LXKG9p+tdwQwrZN1jNfo+wNGp3Wl2os8H0U6ztM0vaG9CGGUAG2ceTp
gBE9b5hCOxdSsHd7DCdX2XhDV0nN/UPY0ojceJjiDWlicmsmzXG+a14xazrm
DZyKFQKPsYUVHw/Jn/IGDpLpkWJsblHB77/zvaHZLvisL/bCUqXq9Ufe8KDq
pcYbM1z/iX29HtThDauvsm2vw/bcu1tYq88bRkkS9jnYjNNPlp/MeMMv3WpT
K+z7smPPPq7xgfTP7aIPTPF9byaLHq73gbQ1sg6nsWUjg28liPnA6msdFV7Y
F5t+XBBU9oEpFs0kXmyq/TpvXSsfqFuadDl8EK9//JEBDgcfkLoZ37wVe64w
/2CHhw9sDh0UWDSZRU4LCmpukT6gIkv2ScdGaQYsyRd8oCTcbt9t41nEXh+Z
0z3iA+U7njU0Gs2iXRM1a3OnfWDLIxELGjZpNdtRr3kfsHVOCtbEnrRN9/nG
6gtBNjSdwv24Pv5YqC4u4wt07ufGEftmEcuG90XTir4g+v7ciS3Y2rvURKs0
fUG9wle0yxCfNycaWA2MfIFv3X3JrdgnJfs7/AJ8IY/dilG7F9fD+8X11Ui+
oMJTPOqE/SvI8+4vmi98jFVj/a0/i4Kq5y+dTvcFSt6Yiwa2ufUqv7tVvnDd
gSX/FMyidYk67KzffOF42/CmV7twPS3AppnH4geONlwMG+zBK098dVf5QdSu
Dpke3Vl0rdauI1LED66IMv3adXB99SXqInOXH3ww4vfI1Mb7K2HP82RDPxjz
OPeYBfsHL+cfaTM/EPuzJcJfaxY1KWR5urj4QfyIJ0lDE+ejx23lV0f9YETi
zGyxGj5vP1Hcw1L9YEEl/NDyDpxfcfpZPOf8gMalVmaBPZrz8ofRdT+wpQd/
nVXB+d798VFdmx+cVSwq+qmI71O97Y5Fa/xhiMs/m7RtFoV3LqQbrPcHWxZp
8XNb8X5wqml6u8kfskRePymTwflMNt62SckfElhJtn1S+P9Tpe/nDAt/oD3t
rPsugevfPSoySkf8YeuWrjdfxfH7ff718DM3f2jcyHr3kxh+/zNJdSsi/CE/
QXdPv+gsei5x4wQlyx96d+jKhwjheqwssEYozx/mi1oNDmzA9Yeu+oc7hf7Q
Pc68KC44ixwPt1h/vO8PKrpH71YLzKLZ9LfinoP+wCNFWby3Ft/3y2J3TSUC
4OaSjG0VG56Pp4JjoWwAVHvc2ybEiuuTp9rsf1QDYNfRSqmoP0xUet7astIg
AJY7JvQkfjGRmWrKewH/APgyduOK6CIT3TufnRkQEQDvZkfMjRaYSGK5QLeV
FgBxh1lIQZ+YaP5pfQo+EuBAaWvdlfdMdM7zi0z/nQAwURFpLZ5kol9PWV+o
1AeAyk+9E9njTOSpyktKeRwAzsKv2WlvmUhzWa5ZZzAABkPPNSoOM1H/eRfn
y38CgBmx7obcKyba9OxptrtxIEy8nCIHNTLRcdX+3TXWgdBrqab0rI6J3p+f
nFjnFAhpK9eulahhonpPFrVHIYHQ/GZhovguE7kta3RuywqEJV17Df0SJipU
vbry/ZtAcBQ/xRF5hol4LpSXG74LhCtX7obKpTNR9HLNobzPgeA9EhrSncpE
Rs96C8xXBIH88Gg963EmYnpywy35IIDRF2+6I5lI+UJ0THRkEIwYJyrKHWai
XsXrHCqx2O4Nr1ytmSi2pStjJikI5n2oSqfMmej5B7mbRy4EASn8W0nLfiby
Nxwa0K0JAq6Xu4pvaDHR9c+gy8IaDMZxt4QUBZnI5ETQ4wergsHl+4r5Qj4m
+iyWYx0mEAy2pGqz9dxMpHdgIWBMKhhyM42PPGFjopH8G7mt+4JheTV7S87H
d0jYdPXyibRgOH0sPeV52zvUMKaZqpcVDHVb/3yNanqHvGM8Nvy4HAyLsuGz
62rfobsFtUoBFcGwfWOtrEzVO2T1I9jFtDsYRJTOxhbkvENpRT2N/MIh0Giw
nMgR8A6xsF0+llMQAkErvXl4Wd+h7aG8x3nKQsAyeXe+/fcZZDdy9HjCvRBQ
OdTwPvPTDKqs9k70fxICY0MClYy3M8g1QiVZ52MIVAhnOSc3YX92MwwSCwUT
5qfhm/QZ1OixaLTWLxQ2vfsmvTwzjXpzlA48DgqF+WDJ6i1vptHcS58DR8ND
oYOmfkqTMY2EYfDAIjUUrn/m3ra9aRqFbmowHk4Phe0WH8ctLkyjzYwTB8vu
hIITf0lcxt5pFLdvk4UpSxgcbVJoS02fQv6qG1Q+cYRBTrDTh6WEKWS7iY8v
a1UYBOx8OXYoegopfWbvGhIIA926obtzLlNo6PKseaBMGFBKK58cVZlCOovV
5ieNw2C/4cErfp2T6EvBEfMnmWGQ5s7DYbJiEvmznjczlAuHLRF7W3IcxtHi
sc2SFxXDwWm68+pXs3EUz1myMKcaDmuL1MFafxxlr6m7kKkTDjJqfWEr5cZR
s+D42LhJOBT5deT7Lo0hEXnl6ITgcJi7fGZO48wYemr1OL/hdjjsd9/Vpt3+
Fh1iWISvexAOGR9X6z2qeYtGDw8a+NSGQ73WYSHbirdoyfH9O55HuL1eVkJi
9lu0xWedunNvOKTs+vxbwustolBd2n99C4chznlpX/a3SOH61/mdeyKAYsO8
7Wg4ir4JXKfP6keAnB5fW7v2KGo7arH68v4I+LZvewPaPopcXW5KsVhGgE7R
9nXm60ZRtoiDbZtHBIidH6j/2PIGsZ6pr7FKiYDp818Py7O/QX30xKSAVxGQ
IGkGC1nD6Pqc6jqxgQhI35OXLxQ/jMIdRvI7hiPgoHl8qL3/MOLeqfVQdToC
bJKuyO1Cw0j/y8zs1+8R0LtRjiOSOYTK/A9aHpcgQUX1fsroviF07PC6TZf9
SdDOIStPE36N5p3MLy0Hk2CD3tyfsZWvkaPnSRHXCBLw0MRSfL4OIs0w9o1S
NBI4/nB4+aR3EM2kLgjePEUC/gzJ9oXsQWRW38N7t5IE9TG54yObBlFNK+/p
DXdJ4Jv9/PAWnkEk+8yEJ+YhCUpGbU8c+zOAWPtbuHWbSaAnZsmePzaA7ny6
vaqphwTCHUFRO0sGkIhMJvuLJRLs83CifN4zgJIVuhKUfpLgdMreOe4dA+iL
Kjdbxh8SVL0sPGQgM4Be7DnOYs0VCdsF81tXcQ+geDvS7/6NkVCadWtqbrAf
TZ20+TqxKxJqt0m1s8T2o6rP62d/JeD4iqVLN/r7kOtkhHRtciTM5vcneXf0
Ib7+bidqWiRkcNqGGbb2oeC6jK7vWZHgWBV/1rGyD8mf4L63VBwJQYyLXLMp
feiaGMfR+Y5IKOR+EOGi34cs+TyqK3oigSSwP565sw+xsDcvBPdHgpCA6pkM
1T7kPBPn/f5tJEivVlvcLtmHRG//NGF+iYSOsBsKV1n7UKbRwoYJkShYvPO6
88DjXrRX18qiQCIKztxgmw5s7EWfFatS3KWjwEYkpaHoYS+yWBfya1QxCiJm
dd54lPYi7hHm22GIAtbp138+nu1FiRFjpX3eUTB48umsrGcvUvfWm8oOiIJq
Tn3OCudeNGF3RcI2NArk45pTDxzpRfp7nM++IkfBUE3y72qzXrTMNRj9Mi0K
rtF6mlJ0elFU3kv9Z7ei4NaX2i/Fgr3op8EnB9L9KMiiC3wK5e9F8bN8kWK1
UfBA4m7MgbW9KEXboijkURQIZ7b4K6zoRbndHWvW90cBNEiUli0ykCT5g3Td
UBRw8V7s+fKJgQolePZ4v42CPFLfWpMPDFQRaBr6gBkFPy53sUlPM1Az5/NX
jr+jQPmM8lLCAAPtL5t9v4ItGnze5D7c3ctAz63XrKzgjAb62MxWzh4GYlwx
3snKFw3HczrNG54z0IzOk8s3tkRDLe9ziY5GBuIJafP+sD8ags58HtD+i4HO
CU7FnT8YDS9lQw5WFzOQcO2Ki2AZDQvcezr2FeLxrjJ8dtY+Gr5vl/GMv8pA
6gUtylpB0dBwt/Jm2AUGenhg3Gg0LBrcy9d77c9moD3zbO4pUdFAObXMsi0T
j3e3fubruGhgHjU/wJ7BwP8/G7/FnY2GNL4dWttPMNAb+ii/3Hls4Ye8pkkM
5CnNotB9KRpyZtwroo4zUFAYcpK+EQ3zLUN14/EMFL+mvqn9fjS0euTHSlIY
qAjVpPIPR4O8+OtJ3mC8HnT/bP+30XA783jZo0AGmq/ZeK1lMhrW/LbxOxrA
QNraMQ8jP0TDUfFnbqv9GKhdRWNm4E80HDMsH3PxZKC54ImFHRwxkBEf2Kvv
wUB8Zef+nOSKgd1CJ9cquDOQndznDXv4YyDfQ/3zale8vpIVhte2xECZb48d
pyMDcbs6W/7cGgM9ETFy/A4MpJK31slGIQa+e9vmbrZnoBiRQBKnegyMXi3d
ZGrHQKvWyRX4G8bAz8sW8YM2DCTPUcCi5hsD3xzUDt83YyAzfSvutMAYSD1Q
M8iOHR7PKjwZGgOOs8lMa1MGqv7lonyeHAPBeiJhyyYMZLK4yflnagy8E1kk
UQ8wUKjacz+b0zEwvLR0e8yIgTLDqJFl52KgueEDlyn20PuBNJfcGBB7EVgn
v5+BAqeya1rKYkA/fk8/lyEDZUjve7zpVgzM1cqYJhsw0B33xe7IezEg+Mgx
mAv714g1c1tDDOT+jj4usJeBTvXxbUzrigGX7tJKAz0GuiXYKD35CvcXzavd
BwzUax2ismcgBlS2ja4NxBbverF//m0MXKrbSs5FDFTenhplsxADfk3rtgrt
YaD1C4671nyLgf2PLpnc3s1AVDFltuZfMTBdX9BqiW0U3nNKmZMMt28bxGft
YqAx0U03Vm8kw9i2X92auji+74N/kxgZRIVUjCZ08P4KbVSJ2UKG9DaPO+ew
aY88aycVyBDIYbP/204G2hBS1tO4hww6oqXafdo4fjHuYvReMkREdRuewx5v
sXRRMiJDgvrodwvsSuEl5iVLMrj6cO94qcVAxs172KI9yVAwnTk7ronjc3zt
in5k6NMo1irFFhIaPzURRAbFruLJSOyJgOSNVtFkaOD/vX8tNl2wS0UxlQxK
56StTDRwHF1bGk8ng7VBbb8YtrE/qTbnHBm+dCgkfVLH420QNuK6TIbirns6
udiVvm4u4xVkYB4aO7SshuPn1GRy7pDhrFeh0wA2vW7FrMVDMnztYR65i20s
UBJV34znoyCzMRR7oubzqYsMMnzsUto4vwPHp1qtLQbJ0DLBlO/GruI7v3Hl
GzIsK9A472LHeuneIM2Q4Y5X/0o6tjDv8Vrzn2QocVS7JUjEd9omcLJQIO9e
dsZvVQaa9JA1quOgAPfSq/VT2LcePO+R58Hxd+XLD7APugvOrpCkwFdVm1kv
bCvp6IJAGQqUvVDsssa2m+p36JGjgHJdnII+tod/7vMrOyhwKjhWZzM2JVyq
XNeAAsEt90PequDzQj3R+5oRBdY+eFDXjZ20NCW+ypQCv1NSg1qxz1JKTvce
osCPNIt3xdg3E1TDwnxw+2PfBKKwyw3OyfUHUKCfdFfFH/sO5+LbPaEU6MiZ
yHPGbkx9YMVNxu2bn3gaYfefRepFqRTQOuHmLoE9YnN1bu1pCgQ183cKYk9s
YL9BOkeBlwvFdG7sjzltgvq5FDi0mzPnhzIDcRaYfh0qo0Bl4GDBADa3V0XF
3lsUKDj9euEltsA2ft+SexRYc7OA/BRb7K9X/dENFMjZtkmyFlv9tkO1wEsK
7AwIrbmKrRNZF05mUKD0vkrWJWzQklAYHaDAoGNRThb2wZqxS2VjFJhepSOd
iu3R4kc3+kIB9ss/10Vi+yY+06j4RoGZm3sVQ7GD9yt+EPxNgSWXeb8AbMqz
eefxFVS4w9p6wB37bE80xApRIWXseqol9oWsgW8TolS4IrCz0BQ777Bulclm
KrzZfGTkAPbN18uSG+WoINu146o+duN4IvsdHSrYBvI4aWDnHim+xIGokDM4
dngHdnTnU7VDe6lQ7vTIVxlbqYbXc8mECp2Djk/liOfPXmzVdqKCwWpdugR2
DFetY4obFc6ZPRUWw7aOHfky4IXHa72+TQR7tb+UDDWYChc9P1hvIJ7XK0us
i6OCxstfyjzYNvc7xXiOU0H66qmD3NjKip/vOp+ggssJy+jV2FPCWlN/Mqiw
LWl8kRO7Of1IrEUWFSTC541WYF/moG24epEKzazlxexEf/ON+/SvUcHxaE8a
C7aK9/jI2UIqtMWc4vujxEBrhlZEj5dQoZ4zN/83dvNj46Ljt6kgZB4x8gNb
Jf/VyseteH5tN3oXsbkFv+YLPaFC/LqM0i/Y06kbtX1fUEHdlnZyATsvytl3
VS8Vvngf8viETZmLZ7EfpELXmxaHeexD7gUXSkaoIJWu5fiR6M9spt1kmgqT
qw1I77FnWla75c5S4XJiwMk57Jadit/nPlLhDOXuzVmiP5lwufRvVHh0aeTH
O+L5Xz9TulbR4HLSeuYUdmu4+BZJHhpUirxSJ5w/A9VhAjS4wKOROIlt+yqR
KSBKg5CiHZoT2DuMixM8JGjQ9Z2ePY69tvGpyB0pGvR9ffxzjOjvL16TQ9tp
MBbQ9Oot9hXJHeM3VGggpS1rRJh63oa6pE6D52a/GkaJ/o5d/Ov8bhoc+uhV
+4Z43l6Ke9CMBh69jyaGsetrfZ1PWNNgw+6VIYSHxMsrNe1osK3N/vcQtvC4
9qFzbjQY8ayUIaxpGFuk540tH9bwGtumqOX7R38apHs2ORI+HWCWd5BEA93w
C1cHsUtfnJv/EUODIw8njQg/VR7Qv0mnwZWD5gsD2JxfPKZXJNNAfHqtJeFY
Glml4SINdlofV+zHzh2pTwjKo8GA+ndmH3Y1cDBEC2igNPeshPAix2lyTCkN
dLx3qhIW8Hn1bGsVDcbXln3tJfLlyUZxxl0cN1FpJBx46nqzagMNbnCLHyac
+vHd+tEWGpzf6y1DuNhS2Se9nQZrg8iLDOwJweo1sy9pMPqpKYewQ16nzfUJ
GtxX1Pv2CjuGRbDI6h0NZDP1ewhnu9t/Z/lAA3a5vArC3VsnLzt9pcGuGbVA
wvMn5OfX/KIBc/3hg4R5ZkP0q1noYB9cqEjYuOLH1IbVdICW/IUebF9+2PmI
hw4n/9LoJ5wUkXgyYh0dKjM76wg3afGpdG2iQ/sQ8yRh7UYZcooyHa7ode0g
bLsl4JmWOh3KRzPFCZOOV4pNadPh57zoGsKVRrrN+vp06C05NNWN3VESv/7T
Pjo48vx8RXiOu80734QO0tZGrYS3vbRY88uGDoqezdcJG6hlO5UcocOjwvEs
wu5ZryvsnOnw5nZWMuG8I942d33weHadDyS8YYx6OZhCh/VeybsI97y2GHse
S4fEGocdhDMYMtsUjtFh0/NTsoTXPOmsnD6J4/rLgoTbm68vGmbQAcVpriWc
VEvWuZ5Jh71bGjkIs1RKtbpepsM219ovL7Hrbn7jarhKh28X5N4TphS8MBUr
pAMpfHiS8Jfs6L6Bcjp80ubtJ/yO/oxp1UgHr1n7BsKF0VeUq1rpMOBR+5Cw
Z1gkifcJHUzHrO4QHvGUWH72kg6naUIlhC85f9GX76WDDaf+DcJ2dk+STwzS
YTk05wrhbpMIfsNxOmgFdJwnfNrQyLZgmg6qbwrPET6IxC6xztGB5VfhacKP
dzyWrv9Ch4JU4ROEazeKamtxxoKhWC6FMHndPC1rdSx8v5QWTVhz7aOmBZ5Y
IBXnkAhXsYSYVArFgqnsmhDCwT/2ZvBsigXRswGBhLd/EWYEbo6Fj5GTfn/P
d7rZWU4uFt5/l/QivPl14MykaiyMX3vo+vf8OjaEX9OJhatDNxwJZ9z1TxQ9
GAvkzx6HCK++uZ633yYWVLvkrQgn5tZfyHSKhT41FXPCLBm+Wyy9Y2H6RMjB
v9/HMYHStSGxkH1q4sDf4/P3bkiKjwVWUVdDwh6W1d1/zuDxxyTpEXZ/d7Hj
4/VYaHq8vJuw61Hy0zf3Y0HnCJcuYeeNR9o6n+LxxKZpE3as0m5uGI4Fsa/R
mn+/j7dfH+azxwEI71MjbMN/vypOLg7IP9eoEjYN07iKIuMgtyJYifC+l7cz
/jTGwV0LVUXCXxPHbw/Lx0OPmMN2wiZSQfm6kfGQtqj4tzN15m9fqI6HnP0y
f3vEMqJ98U88/IyR+tumijJxSiZHQUr0H9dy9Wn4ZB+F1dz/eLNzgmD+0FHo
XvWPE28rLvZuSYCo/9tg30RXqU8C+P3fHAM5pQmlCeDzfzOV4+XVvyaA9//d
meRVPKl37F8nykot7Xvxn5Os9pxw8Tz+r8NDDwZGffrP61eFGT2hJv5rVvkF
3x7+pH89uMf39evL/3n5tc7ZSxrJ/7p/QUrv/NP/fPnPH70zh07867JzO5P1
5/7zTVFv8c8xKf/aQfxm2TBb6r+2u3ngaPyF/wyyw4WS0if/dfCjig6+8P98
2T1h6U/Df/4ftL8DUA==
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.8902439024390244}, {
      114.64600693572409`, 0.7571428571428571}, {217.0658691486482, 
      0.7777777777777778}, {234.0580961452382, 0.8714285714285714}, {
      271.3585734069022, 0.6666666666666666}, {279.4678829063734, 
      0.7575757575757576}, {287.7132488621885, 0.725}, {298.23280345575165`, 
      0.75}, {326.51819304355257`, 0.3333333333333333}, {360.2771694792396, 
      0.2608695652173913}, {371.7491559375691, 0.10294117647058823`}, {
      534.2929569908707, 0.4625}, {715.9748714461863, 0.3375}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965164181509*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c8lt0bAHAkDV5pkBFSFEmopIjnIpUUWWnYPPaezzRLMkJGJCMRKSKj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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 1.}, {114.64600693572409`, 1.}, {
      217.0658691486482, 1.}, {234.0580961452382, 0.9857142857142858}, {
      271.3585734069022, 1.}, {279.4678829063734, 0.8787878787878788}, {
      287.7132488621885, 0.95}, {298.23280345575165`, 0.9305555555555556}, {
      326.51819304355257`, 0.9791666666666666}, {360.2771694792396, 1.}, {
      371.7491559375691, 1.}, {534.2929569908707, 1.}, {715.9748714461863, 
      1.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965164381682*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c4l9//B3CrUiSkMiJCoawUSp1zzOyE7L333lkpGQkhyogyolIqGhKy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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 0.8414634146341463}, {
      114.64600693572409`, 0.8793103448275862}, {217.0658691486482, 
      0.9210526315789473}, {234.0580961452382, 0.8714285714285714}, {
      271.3585734069022, 0.4358974358974359}, {279.4678829063734, 
      0.6818181818181818}, {287.7132488621885, 0.6125}, {298.23280345575165`, 
      0.3055555555555556}, {326.51819304355257`, 0.16666666666666666`}, {
      360.2771694792396, 0.}, {371.7491559375691, 0.}, {534.2929569908707, 
      0.}, {715.9748714461863, 0.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965164582633*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], Thickness[0.005], 
     LineBox[CompressedData["
1:eJxF13c81d8bAHCrISopQqFBGQnRonweQjLKSvbee7vuQEpGQiUko7IiK6RB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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.012], 
     PointBox[{{1.3528470097783847`, 1.}, {114.64600693572409`, 1.}, {
      217.0658691486482, 1.}, {234.0580961452382, 0.9857142857142858}, {
      271.3585734069022, 0.7948717948717948}, {279.4678829063734, 
      0.9393939393939394}, {287.7132488621885, 0.8875}, {298.23280345575165`, 
      0.9305555555555556}, {326.51819304355257`, 0.7708333333333334}, {
      360.2771694792396, 0.6304347826086957}, {371.7491559375691, 
      0.5909090909090909}, {534.2929569908707, 0.75}, {715.9748714461863, 
      0.7}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{1, 888}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{3.5829650867857533`*^9, 3.5829651300479794`*^9, 
  3.582965164589587*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M7 = 1 angle, 12 centers, 12 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367625254587*^9}, 3.582367787809677*^9, {3.582370748630659*^9, 
   3.5823707509394627`*^9}, 3.582431709485823*^9, {3.583637641532021*^9, 
   3.583637671799189*^9}, {3.583811002240328*^9, 3.5838110054158373`*^9}, 
   3.5838110364102793`*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.583637696518804*^9, 3.58363771573104*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",",
      "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", 
     ",", "angle1", ",", "angle1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", "c6", ",", "c7", 
     ",", "c8", ",", "c9", ",", "c10", ",", "c11", ",", "c12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"{", 
    RowBox[{
    "\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3", ",", "\[Sigma]4", ",", 
     "\[Sigma]5", ",", "\[Sigma]6", ",", "\[Sigma]7", ",", "\[Sigma]8", ",", 
     "\[Sigma]9", ",", "\[Sigma]10", ",", "\[Sigma]11", ",", "\[Sigma]12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, {3.582367633450643*^9, 3.582367666820457*^9}, 
   3.5823697252643824`*^9, {3.5836377434257936`*^9, 3.583637748873405*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.5836377548301697`*^9, 3.583637771326756*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c2", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c3", "<", "1000"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c9", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]2", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]3", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.582367686821156*^9, {3.58236779839286*^9, 
   3.5823677984495*^9}, {3.582368228777401*^9, 3.58236823693262*^9}, {
   3.5823685769520807`*^9, 3.582368694658296*^9}, {3.58236872520315*^9, 
   3.5823687284791555`*^9}, {3.582369057354416*^9, 3.5823690651388297`*^9}, {
   3.582369100991296*^9, 3.5823691093685107`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4339.000386230516`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "276.97536206361895`"}], ",", 
     RowBox[{"c2", "\[Rule]", "264.8257045683147`"}], ",", 
     RowBox[{"c3", "\[Rule]", "279.468818472671`"}], ",", 
     RowBox[{"c4", "\[Rule]", "406.18443884296295`"}], ",", 
     RowBox[{"c5", "\[Rule]", "258.7337436514228`"}], ",", 
     RowBox[{"c6", "\[Rule]", "278.5980322107506`"}], ",", 
     RowBox[{"c7", "\[Rule]", "274.84277715581425`"}], ",", 
     RowBox[{"c8", "\[Rule]", "278.61926272489643`"}], ",", 
     RowBox[{"c9", "\[Rule]", "293.4826825336199`"}], ",", 
     RowBox[{"c10", "\[Rule]", "217.79293754325994`"}], ",", 
     RowBox[{"c11", "\[Rule]", "275.33114032748716`"}], ",", 
     RowBox[{"c12", "\[Rule]", "280.3696243352345`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.106372749886766`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "19.61777901451889`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "16.625995309837407`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "61.07817013678496`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "13.802229217026312`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "1.0000000000674358`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "17.15088559916729`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "4.128157950790673`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "5.185124955302272`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "1.5115978345645489`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "15.32487442001296`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "19.597983856922212`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.23738662694452065`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9833701845473702`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6264634455450061`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999993457`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009389837236342203`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9442151747396639`"}], ",", 
     RowBox[{"h14", "\[Rule]", "7.090598999916056`*^-13"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.31519373557883745`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.6002330864879521`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9522473379609173`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8358602298916372`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9181503943605317`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.14301267527368652`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9809701570803704`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.15304233204896567`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.3521026391641462`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.30141718418311614`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.689449433528436`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9708737867499183`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9999999999930252`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8790603336855641`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6824727168679079`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999992485`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.142140109471292`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.582367750413134*^9, 3.5823682504512444`*^9, 
  3.582368469414255*^9, 3.5823688999278836`*^9, 3.582369290796644*^9, 
  3.582369903227706*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with Model M6 = 12 angles, 1 centre, 12 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367590394992*^9}, {3.5823703724203978`*^9, 3.5823703727167983`*^9}, {
   3.582370421856885*^9, 3.58237045867295*^9}, 3.5824317220126452`*^9, {
   3.583637843246521*^9, 3.58363786743674*^9}, 3.5836379036294394`*^9, {
   3.5838110093441753`*^9, 3.583811037538742*^9}}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.583637949104644*^9, 3.583637958890727*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle2", ",", "angle3", ",", "angle4", ",", "angle5", ",",
      "angle6", ",", "angle7", ",", "angle8", ",", "angle9", ",", "angle10", 
     ",", "angle11", ",", "angle12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", 
     ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3", ",", "\[Sigma]4", ",", 
      "\[Sigma]5", ",", "\[Sigma]6", ",", "\[Sigma]7", ",", "\[Sigma]8", ",", 
      "\[Sigma]9", ",", "\[Sigma]10", ",", "\[Sigma]11", ",", "\[Sigma]12"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, 3.5823697356564016`*^9, {3.582370432542904*^9, 
   3.582370452261338*^9}, 3.583637930529232*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.5836379637115173`*^9, 3.5836379721931477`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]2", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]3", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]4", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]5", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]6", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]7", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]8", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]9", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]10", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]11", "<", "100"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]12", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.5823700404533796`*^9, {3.582370603971605*^9, 
   3.582370611054017*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4338.2124752862355`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "276.53028426961714`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.07639763078617`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "19.71634000767843`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "16.441696633092896`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "37.83389197471077`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "14.09039959291221`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "1.0000000000812463`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "17.348472033785622`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "4.1398180041297366`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "4.867043240279378`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "1.6593795833739653`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "15.400279522475618`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "19.601365207157382`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.2377205207628081`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.983412403554465`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6279530444485711`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999990368`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009342512553131184`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9437692773342032`"}], ",", 
     RowBox[{"h14", "\[Rule]", "9.506732863053217`*^-13"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.3098005836464621`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5997958880834571`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9525505492319636`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8357095074171645`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.918186798505471`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.144332922303469`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9824531004469838`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.1523740722618287`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.35208774902695217`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3011402613905926`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.6919728631435658`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9708737873726312`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9999999999896444`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8794282278089088`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6796681642551908`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999988625`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.1433837418271409`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "1.0957996281243687`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "1.15306650338677`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "1.4207150876292927`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "1.0730389522430748`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "1.1496462250599482`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "1.1337755920528365`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "1.1509608225001773`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "1.1961003286931216`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "0.9032428215327335`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "1.137455619581878`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "1.1597378314378926`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582358385430276*^9, 3.582360237291751*^9, 
   3.582360574781094*^9, 3.582360614455263*^9, 3.582361384624217*^9, 
   3.582362419961706*^9, 3.582362968595953*^9, 3.582363049169897*^9, 
   3.5823633847438707`*^9, 3.582363426477371*^9, 3.58236479353304*^9, 
   3.582364931381997*^9, 3.582366682008963*^9, 3.5823668862816887`*^9, 
   3.582367211871785*^9, 3.582370262098569*^9, 3.582370539652692*^9, 
   3.5823706899121556`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M5 = 12 angles, 12 centers, 1 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367590394992*^9}, {3.5823703724203978`*^9, 3.5823703727167983`*^9}, {
   3.5823707989407473`*^9, 3.5823708083475637`*^9}, 3.5824317330418644`*^9, {
   3.58363804570798*^9, 3.583638070416368*^9}, 3.5838110387870913`*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.583638092140658*^9, 3.583638101386568*^9}, 
   3.5836383067987003`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle2", ",", "angle3", ",", "angle4", ",", "angle5", ",",
      "angle6", ",", "angle7", ",", "angle8", ",", "angle9", ",", "angle10", 
     ",", "angle11", ",", "angle12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", "c6", ",", "c7", 
     ",", "c8", ",", "c9", ",", "c10", ",", "c11", ",", "c12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, 3.5823697356564016`*^9, {3.5823708149151754`*^9, 
   3.582370832309206*^9}, 3.5836380875750713`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max Likelihood", "Subsection",
 CellChangeTimes->{{3.583638108321581*^9, 3.583638116729458*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"200", "<", "c1", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c2", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c3", "<", "400"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c5", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c6", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c7", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c8", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c9", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c10", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c11", "<", "400"}], "&&", 
      RowBox[{"200", "<", "c12", "<", "400"}], "&&", 
      RowBox[{"5", "<", "\[Sigma]1", "<", "40"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "2"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.5823700404533796`*^9, {3.582370880903291*^9, 
   3.5823708900605073`*^9}, 3.5823711624525857`*^9, {3.582373946517223*^9, 
   3.582373951478031*^9}, {3.582432570154935*^9, 3.5824325959105797`*^9}, {
   3.5824326601202927`*^9, 3.5824326704475107`*^9}, {3.582432718261595*^9, 
   3.582432725905608*^9}, {3.5824333776279535`*^9, 3.582433430215646*^9}, {
   3.582433477795729*^9, 3.5824334918357534`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4356.314479504893`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "274.07102385486724`"}], ",", 
     RowBox[{"c2", "\[Rule]", "295.42372759228437`"}], ",", 
     RowBox[{"c3", "\[Rule]", "269.7472739529867`"}], ",", 
     RowBox[{"c4", "\[Rule]", "251.63854536815074`"}], ",", 
     RowBox[{"c5", "\[Rule]", "281.60913678076116`"}], ",", 
     RowBox[{"c6", "\[Rule]", "360.6422707767572`"}], ",", 
     RowBox[{"c7", "\[Rule]", "312.3594631835283`"}], ",", 
     RowBox[{"c8", "\[Rule]", "311.91334770459036`"}], ",", 
     RowBox[{"c9", "\[Rule]", "336.37127457525213`"}], ",", 
     RowBox[{"c10", "\[Rule]", "304.8113840259125`"}], ",", 
     RowBox[{"c11", "\[Rule]", "292.3035970980101`"}], ",", 
     RowBox[{"c12", "\[Rule]", "254.33656411906696`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "16.316747277648382`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.24077861040196982`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9796144873107395`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6404830224897183`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009251578419679904`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9444100856526878`"}], ",", 
     RowBox[{"h14", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.27866751135690276`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5920165054653965`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9543037099649195`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8351929207468523`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9515637784471599`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.14545132595362195`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9735110130171695`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.1426624629368694`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.3612975941170946`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.2982371453309407`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7469852871395117`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.3157435120735371`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9696862821987294`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8800964919593955`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6848448961703019`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.1509081129881438`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "1.0006046358822378`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "1.1765165300328242`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "1.508013815753279`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "1.0601248601291755`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "0.7922051502668639`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "0.994579622563995`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "1.063101043072528`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "0.9726695887905735`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "1.8285441038827523`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "1.0783529716148743`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "1.2268337455070515`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5824329390019827`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M3 = 1 angle, 1 centre, 12 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367625254587*^9}, 3.582367787809677*^9, {3.582370748630659*^9, 
   3.5823707509394627`*^9}, {3.5824282387325087`*^9, 3.5824282491065264`*^9}, 
   3.5824317477838907`*^9, {3.583638180560768*^9, 3.583638214200593*^9}, 
   3.583811039978907*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.583638216816815*^9, 3.583638240864065*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",",
      "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", 
     ",", "angle1", ",", "angle1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", 
     ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3", ",", "\[Sigma]4", ",", 
      "\[Sigma]5", ",", "\[Sigma]6", ",", "\[Sigma]7", ",", "\[Sigma]8", ",", 
      "\[Sigma]9", ",", "\[Sigma]10", ",", "\[Sigma]11", ",", "\[Sigma]12"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, {3.582367633450643*^9, 3.582367666820457*^9}, 
   3.5823697252643824`*^9, {3.5824282551437373`*^9, 3.5824282707905645`*^9}, 
   3.583638236580249*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.583638245125222*^9, 3.583638252221517*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]1", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]2", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]3", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]4", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]5", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]6", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]7", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]8", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]9", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]10", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]11", "<", "300"}], "&&", 
      RowBox[{"0", "<", "\[Sigma]12", "<", "300"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]3", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]4", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]6", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]7", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]8", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]9", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]11", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "20000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.582367686821156*^9, {3.58236779839286*^9, 
   3.5823677984495*^9}, {3.582368228777401*^9, 3.58236823693262*^9}, {
   3.5823685769520807`*^9, 3.582368694658296*^9}, {3.58236872520315*^9, 
   3.5823687284791555`*^9}, {3.582369057354416*^9, 3.5823690651388297`*^9}, {
   3.582369100991296*^9, 3.5823691093685107`*^9}, {3.582428324281459*^9, 
   3.5824283335634756`*^9}, {3.582428448691678*^9, 3.5824284720137186`*^9}, {
   3.5824287581358213`*^9, 3.5824287801786604`*^9}, 3.5824304031707287`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4360.007039961964`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "275.44703495966314`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "18.113730093363777`"}], ",", 
     RowBox[{"\[Sigma]2", "\[Rule]", "25.20208324111591`"}], ",", 
     RowBox[{"\[Sigma]3", "\[Rule]", "16.489275304200447`"}], ",", 
     RowBox[{"\[Sigma]4", "\[Rule]", "114.50268509013524`"}], ",", 
     RowBox[{"\[Sigma]5", "\[Rule]", "23.331275643419048`"}], ",", 
     RowBox[{"\[Sigma]6", "\[Rule]", "0.4593111297385071`"}], ",", 
     RowBox[{"\[Sigma]7", "\[Rule]", "16.642303195269015`"}], ",", 
     RowBox[{"\[Sigma]8", "\[Rule]", "3.9499451718064917`"}], ",", 
     RowBox[{"\[Sigma]9", "\[Rule]", "12.131545877929891`"}], ",", 
     RowBox[{"\[Sigma]10", "\[Rule]", "103.73070548906183`"}], ",", 
     RowBox[{"\[Sigma]11", "\[Rule]", "15.064036392565875`"}], ",", 
     RowBox[{"\[Sigma]12", "\[Rule]", "18.884848150249322`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.23441863570578497`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9827617783772024`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.5915660011208401`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009977434499082496`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9474624501908122`"}], ",", 
     RowBox[{"h14", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.47135953175286066`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5430001402757803`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9508477827112156`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8383050483389691`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9170662439783158`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.13671851784337946`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9738539271622415`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.15432491325810374`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.35358526822269426`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.3305812942648899`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7628555480362998`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9606524408662509`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.9606524408687429`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8696363798848711`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6883547230125172`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.1507838176937657`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.582428912648511*^9, 3.582430695296842*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M4 = 12 angles, 1 centre, 1 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367590394992*^9}, {3.5823703724203978`*^9, 3.5823703727167983`*^9}, {
   3.5823738290022163`*^9, 3.582373838502633*^9}, {3.5824309951917686`*^9, 
   3.582431011540597*^9}, 3.5824317992171807`*^9, {3.583638351037352*^9, 
   3.5836383827678213`*^9}, 3.583811041122468*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.583638384980461*^9, 3.583638392547017*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle2", ",", "angle3", ",", "angle4", ",", "angle5", ",",
      "angle6", ",", "angle7", ",", "angle8", ",", "angle9", ",", "angle10", 
     ",", "angle11", ",", "angle12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1", 
     ",", "c1", ",", "c1", ",", "c1", ",", "c1", ",", "c1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, 3.5823697356564016`*^9, {3.582431023100218*^9, 
   3.582431056468676*^9}, 3.583638405832479*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.583638411949396*^9, 3.583638420121698*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle2", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle3", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle4", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle5", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle6", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle7", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle8", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle9", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle10", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle11", "<", "1.5"}], "&&", 
      RowBox[{"0", "<", "angle12", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle6", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle7", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle8", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle9", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle11", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle12", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.5823700404533796`*^9, {3.5824310941739426`*^9, 
   3.582431119180786*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4376.405288748211`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "304.80942743884134`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "17.203371933593875`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.24230307109732785`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.9803273865207667`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6375668059937362`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.99999999999642`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.00968645709477318`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9415256723841298`"}], ",", 
     RowBox[{"h14", "\[Rule]", "3.0849902441795314`*^-12"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.27616033241100846`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5908225092453181`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9545120263685576`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8377732211697183`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9498244123629312`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.14455794412577372`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9783138243811348`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.142785177173105`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.36402114331740365`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.298888747032678`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7598351524057712`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.8769321949985391`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.8769321950029445`"}], ",", 
     RowBox[{"h111", "\[Rule]", "9.381995285975433`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8810903218177193`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6892170942335851`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999949886`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.0327096261883506`"}], ",", 
     RowBox[{"angle2", "\[Rule]", "0.9625089796993638`"}], ",", 
     RowBox[{"angle3", "\[Rule]", "1.048821196616208`"}], ",", 
     RowBox[{"angle4", "\[Rule]", "1.4321067272479033`"}], ",", 
     RowBox[{"angle5", "\[Rule]", "0.9606996447704119`"}], ",", 
     RowBox[{"angle6", "\[Rule]", "1.0546432945992008`"}], ",", 
     RowBox[{"angle7", "\[Rule]", "1.025581124776309`"}], ",", 
     RowBox[{"angle8", "\[Rule]", "1.0877839416789914`"}], ",", 
     RowBox[{"angle9", "\[Rule]", "1.0902278786568724`"}], ",", 
     RowBox[{"angle10", "\[Rule]", "1.4999999999956706`"}], ",", 
     RowBox[{"angle11", "\[Rule]", "1.0285509154049886`"}], ",", 
     RowBox[{"angle12", "\[Rule]", "1.0364797191658122`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582358385430276*^9, 3.582360237291751*^9, 
   3.582360574781094*^9, 3.582360614455263*^9, 3.582361384624217*^9, 
   3.582362419961706*^9, 3.582362968595953*^9, 3.582363049169897*^9, 
   3.5823633847438707`*^9, 3.582363426477371*^9, 3.58236479353304*^9, 
   3.582364931381997*^9, 3.582366682008963*^9, 3.5823668862816887`*^9, 
   3.582367211871785*^9, 3.582370262098569*^9, 3.582431140490424*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fit with model M2 = 1 angle, 12 centers, 1 \[Sigma]\
\>", "Section",
 CellChangeTimes->{{3.582363134501287*^9, 3.582363142020606*^9}, {
   3.582367247174806*^9, 3.58236725669407*^9}, {3.5823675847542267`*^9, 
   3.582367590394992*^9}, {3.5823703724203978`*^9, 3.5823703727167983`*^9}, {
   3.5823738290022163`*^9, 3.582373838502633*^9}, {3.582431175247285*^9, 
   3.582431191252913*^9}, 3.5824318117596025`*^9, {3.583638436520657*^9, 
   3.5836384658778687`*^9}, 3.583811042234823*^9}],

Cell[CellGroupData[{

Cell["parameters and functions", "Subsection",
 CellChangeTimes->{{3.5836384950016823`*^9, 3.583638503872423*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", 
   RowBox[{"{", 
    RowBox[{
    "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",",
      "angle1", ",", "angle1", ",", "angle1", ",", "angle1", ",", "angle1", 
     ",", "angle1", ",", "angle1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{"{", 
    RowBox[{
    "h11", ",", "h12", ",", "h13", ",", "h14", ",", "h15", ",", "h16", ",", 
     "h17", ",", "h18", ",", "h19", ",", "h110", ",", "h111", ",", "h112"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hp", "=", 
   RowBox[{"{", 
    RowBox[{
    "hp1", ",", "hp2", ",", "hp3", ",", "hp4", ",", "hp5", ",", "hp6", ",", 
     "hp7", ",", "hp8", ",", "hp9", ",", "hp10", ",", "hp11", ",", "hp12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
    "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", "c6", ",", "c7", 
     ",", "c8", ",", "c9", ",", "c10", ",", "c11", ",", "c12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "=", 
    RowBox[{"{", 
     RowBox[{
     "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", 
      "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1", ",", "\[Sigma]1"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cline2", "[", "x_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "h1"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "hp"}], ")"}]}], "+", "hp", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"hp", "-", 
         RowBox[{"h1", " ", "hp"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         RowBox[{"c", "-", "x"}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox["T"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coord", "=", 
   RowBox[{"Table", " ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", ")"}], "^", "2"}], " ", "+", 
        " ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], " ", "]"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"angle", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"distY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"distX", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"coord", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"all", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], "/", 
        RowBox[{"eff", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "distX", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], 
       RowBox[{"Length", "[", "distX", "]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"all", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"cline2", "[", 
            RowBox[{"coord", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"eff", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "-", 
           RowBox[{"all", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"cline2", "[", 
             RowBox[{"coord", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"llcline2tot", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "12"], 
    RowBox[{"llcline2", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.582342949467092*^9, 3.582342999403928*^9}, {
   3.582344410317514*^9, 3.582344431783246*^9}, {3.5823445584718227`*^9, 
   3.58234458379073*^9}, {3.5823448631984463`*^9, 3.582345044104063*^9}, {
   3.58234509519633*^9, 3.582345128257081*^9}, {3.582346219988337*^9, 
   3.582346247467472*^9}, 3.5823697356564016`*^9, {3.5824311983977256`*^9, 
   3.582431236976593*^9}, 3.583638490774444*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Max likelihood", "Subsection",
 CellChangeTimes->{{3.5836385086051493`*^9, 3.583638515527121*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"llcline2tot", "/.", 
      RowBox[{"T", "\[Rule]", "4"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"50", "<", "c1", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c2", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c3", "<", "1000"}], "&&", 
      RowBox[{"100", "<", "c4", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c5", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c6", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c7", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c8", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c9", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c10", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c11", "<", "1000"}], "&&", 
      RowBox[{"50", "<", "c12", "<", "1000"}], "&&", 
      RowBox[{"1", "<", "\[Sigma]1", "<", "100"}], "&&", 
      RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
      RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
      RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
      RowBox[{"h11", "<", "hp1"}], "&&", 
      RowBox[{"h12", "<", "hp2"}], "&&", 
      RowBox[{"h13", "<", "hp3"}], "&&", 
      RowBox[{"h14", "<", "hp4"}], "&&", 
      RowBox[{"h15", "<", "hp5"}], "&&", 
      RowBox[{"h16", "<", "hp6"}], "&&", 
      RowBox[{"h17", "<", "hp7"}], "&&", 
      RowBox[{"h18", "<", "hp8"}], "&&", 
      RowBox[{"h19", "<", "hp9"}], "&&", 
      RowBox[{"h110", "<", "hp10"}], "&&", 
      RowBox[{"h111", "<", "hp11"}], "&&", 
      RowBox[{"h112", "<", "hp12"}], "&&", 
      RowBox[{"0", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c3", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c4", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c6", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c7", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c8", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c9", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c10", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c11", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c12", ",", "300"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h11", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h12", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h13", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h14", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h15", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h16", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h17", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h18", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h19", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h110", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h111", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h112", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5823488076883097`*^9, 3.582348834254637*^9}, {
   3.582348912706046*^9, 3.58234908010995*^9}, {3.582361359524391*^9, 
   3.582361376552932*^9}, 3.58236296437893*^9, {3.582363190551777*^9, 
   3.5823632256616993`*^9}, {3.582363321440591*^9, 3.5823633477141953`*^9}, 
   3.582363420435803*^9, {3.582363460519561*^9, 3.582363747935584*^9}, {
   3.5823647117535467`*^9, 3.5823647766636868`*^9}, {3.5823648953496428`*^9, 
   3.5823649031263113`*^9}, {3.582366492610282*^9, 3.582366521434025*^9}, {
   3.5823665526900454`*^9, 3.582366552937007*^9}, {3.5823667624250593`*^9, 
   3.5823667655044518`*^9}, {3.582366931824294*^9, 3.582366946616996*^9}, {
   3.5823669778507977`*^9, 3.582366988299822*^9}, {3.5823670705076303`*^9, 
   3.5823670797666883`*^9}, 3.5823700404533796`*^9, {3.582431277614665*^9, 
   3.582431306474715*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4359.6672042507935`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", "290.049818774362`"}], ",", 
     RowBox[{"c2", "\[Rule]", "274.4954095763006`"}], ",", 
     RowBox[{"c3", "\[Rule]", "293.68301564846234`"}], ",", 
     RowBox[{"c4", "\[Rule]", "367.28798462579397`"}], ",", 
     RowBox[{"c5", "\[Rule]", "274.25498685966454`"}], ",", 
     RowBox[{"c6", "\[Rule]", "298.34351042844935`"}], ",", 
     RowBox[{"c7", "\[Rule]", "289.12153476334515`"}], ",", 
     RowBox[{"c8", "\[Rule]", "304.9837048577189`"}], ",", 
     RowBox[{"c9", "\[Rule]", "306.2437722228161`"}], ",", 
     RowBox[{"c10", "\[Rule]", "229.3507971598931`"}], ",", 
     RowBox[{"c11", "\[Rule]", "289.2861571078872`"}], ",", 
     RowBox[{"c12", "\[Rule]", "289.49634417941564`"}], ",", 
     RowBox[{"\[Sigma]1", "\[Rule]", "16.401902741058294`"}], ",", 
     RowBox[{"h11", "\[Rule]", "0.2434753554064618`"}], ",", 
     RowBox[{"hp1", "\[Rule]", "0.979388647436947`"}], ",", 
     RowBox[{"h12", "\[Rule]", "0.6391394103611209`"}], ",", 
     RowBox[{"hp2", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"h13", "\[Rule]", "0.009953810939195487`"}], ",", 
     RowBox[{"hp3", "\[Rule]", "0.9417721576214406`"}], ",", 
     RowBox[{"h14", "\[Rule]", "0.04298424871160716`"}], ",", 
     RowBox[{"hp4", "\[Rule]", "0.26294654972284204`"}], ",", 
     RowBox[{"h15", "\[Rule]", "0.5917659047569276`"}], ",", 
     RowBox[{"hp5", "\[Rule]", "0.9545148089341738`"}], ",", 
     RowBox[{"h16", "\[Rule]", "0.8343383845662473`"}], ",", 
     RowBox[{"hp6", "\[Rule]", "0.9486361655346908`"}], ",", 
     RowBox[{"h17", "\[Rule]", "0.14391118818629128`"}], ",", 
     RowBox[{"hp7", "\[Rule]", "0.9759038095297254`"}], ",", 
     RowBox[{"h18", "\[Rule]", "0.14226658731701583`"}], ",", 
     RowBox[{"hp8", "\[Rule]", "0.3620967274524388`"}], ",", 
     RowBox[{"h19", "\[Rule]", "0.29692738891676246`"}], ",", 
     RowBox[{"hp9", "\[Rule]", "0.7544317262932753`"}], ",", 
     RowBox[{"h110", "\[Rule]", "0.9712848519242243`"}], ",", 
     RowBox[{"hp10", "\[Rule]", "0.999999999998181`"}], ",", 
     RowBox[{"h111", "\[Rule]", "5.863377320745637`*^-13"}], ",", 
     RowBox[{"hp11", "\[Rule]", "0.8809586695946153`"}], ",", 
     RowBox[{"h112", "\[Rule]", "0.6934922851743522`"}], ",", 
     RowBox[{"hp12", "\[Rule]", "0.9999999999994137`"}], ",", 
     RowBox[{"angle1", "\[Rule]", "1.0896892620182097`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.582348836772189*^9, 3.5823489607335653`*^9, {3.582349014739852*^9, 
   3.58234908078209*^9}, 3.582358385430276*^9, 3.582360237291751*^9, 
   3.582360574781094*^9, 3.582360614455263*^9, 3.582361384624217*^9, 
   3.582362419961706*^9, 3.582362968595953*^9, 3.582363049169897*^9, 
   3.5823633847438707`*^9, 3.582363426477371*^9, 3.58236479353304*^9, 
   3.582364931381997*^9, 3.582366682008963*^9, 3.5823668862816887`*^9, 
   3.582367211871785*^9, 3.582370262098569*^9, 3.582431465470195*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Support limits of parameter estimates, including \[Sigma], with model M1\
\>", "Section",
 CellChangeTimes->{{3.5836387061380463`*^9, 3.5836387471052933`*^9}, {
  3.5836568232022467`*^9, 3.583656831143742*^9}}],

Cell[CellGroupData[{

Cell["Support limits of sigma and w", "Subsection",
 CellChangeTimes->{{3.5836390641799097`*^9, 3.583639079584248*^9}}],

Cell["\<\
We compute the maxLogLikelihood for 100 values of sigma between 16 et 22, \
with all other parameters variable, and we plot the support limit\
\>", "Text",
 CellChangeTimes->{{3.582652410930936*^9, 3.582652516619972*^9}, {
  3.582653541989184*^9, 3.582653550699667*^9}, {3.583638787470213*^9, 
  3.583638872568653*^9}, {3.584080994160482*^9, 3.5840809947501163`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"minim", "=", "16"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxim", "=", "21"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nbpoint", "=", "100"}], ";"}], "\n", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "0"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"(", 
     RowBox[{"nbpoint", "+", "1"}], ")"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "1"}], "]"}], "=", 
      RowBox[{"(", 
       RowBox[{"minim", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"maxim", "-", "minim"}], ")"}], "/", "nbpoint"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "2"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"FindMaximum", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"llcline2tot", "/.", 
              RowBox[{"\[Sigma]1", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"minim", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"maxim", "-", "minim"}], ")"}], "/", 
                   "nbpoint"}]}]}], ")"}]}]}], "/.", 
             RowBox[{"T", "\[Rule]", "4"}]}], ",", 
            RowBox[{
             RowBox[{"250", "<", "c1", "<", "350"}], "&&", 
             RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
             RowBox[{"h11", "<", "hp1"}], "&&", 
             RowBox[{"h12", "<", "hp2"}], "&&", 
             RowBox[{"h13", "<", "hp3"}], "&&", 
             RowBox[{"h14", "<", "hp4"}], "&&", 
             RowBox[{"h15", "<", "hp5"}], "&&", 
             RowBox[{"h16", "<", "hp6"}], "&&", 
             RowBox[{"h17", "<", "hp7"}], "&&", 
             RowBox[{"h18", "<", "hp8"}], "&&", 
             RowBox[{"h19", "<", "hp9"}], "&&", 
             RowBox[{"h110", "<", "hp10"}], "&&", 
             RowBox[{"h111", "<", "hp11"}], "&&", 
             RowBox[{"h112", "<", "hp12"}], "&&", 
             RowBox[{"0.8", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"c1", ",", "300"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h11", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h12", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h13", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h14", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h15", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h16", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h17", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h18", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h19", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h110", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h111", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h112", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "-", "llcline2totmax", "+", "2"}]}]}],
     "}"}]}], "]"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "1"}], "]"}], ",", 
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nbpoint"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.1"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.58265317991616*^9, 3.582653196640175*^9}, {
   3.5826532617196207`*^9, 3.5826532667820787`*^9}, 3.582653387273225*^9, {
   3.583850996551854*^9, 3.583851022426045*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "1"}], "]"}], ",", 
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nbpoint"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.584077869415843*^9, 3.584077869790244*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9lHtIU1Ecx6+iLcuh2YMWpEvKnL3UiSiUu5mVkaH1R7ogCTMFJdOkKEhb
ZUGktMLK+cAFKZkZlIbYy62w51pXSspKW6Uzy2Q637rdfj/Pzw6My4dzzvf+
9jm/c5elHNp1wJXjuL3ww2fH1UL7XGkwX6rD0dQ8/ZQF8xyXsHF71unmNBwB
yO67S60NKuX0ANY0FZS+aFFxOHhkc1RYpqB6a4IRh+uljQuENtV0nhrnvV3K
fb6opvPSgC0hH/JlFpaXC6wXLtwv+cHyNDhfnj5H0s3yCnH/RNyV1B6Wp8P1
Sa8O3u1ledU4f1ha+/cPy6sHNtRKU2X9LM8AnG26k7jExvJMuP/t9Va/AZbX
jutL3FctHWR5VmBheWaWj53l2YH5wJpq0c7yuBCe845QdHYNsTxPYE2Bxvfp
MMuT4XzU4JFrIywvAFhoUf1OHSV/wJaa2nNBY+QP2FbscatnjPwByyNd/cvG
yR9wgtm3P2aC/OH6qC8buifIXwj6PuR2YpL8AetrLiZ6TJE/YO3CJbFFU+QP
64nO75Y4yB/mGcXw4w7yhzyakvzdQf4wb/xKMu8kf8D8JeuWq07yh7wwPOCn
k/xhPevkc1eK5A/33/Z0SxHJXyichzrCr1gkf8C2O00Zj0Xyh3z0zFCHSP6A
9+WkvR6mPCVwQoxHnivHM3/AhpYLL905nvkD/jR+2OzGsb5W4/5T74JEyksD
5k2S2D7Ky8X5FzdcWqk+DbCwsTK1juorxHr2vs87RfXpgLUSlz07KK8a60k3
uc+jvHrk+CdFJif5A/a+GeM8OeMPWP713v5VM/6wflX0azOdhxVYc9QnKoPO
w4772xVvHFPkTwn88UjeeTpfT2C5+s0+KZ2vDFhY1qM5P0n+kBVZvQ7qFyVw
sPNvVcYE9R+wfmmH8d049Z8S6y+LXTPTf8jOnM1nxsgfcLa2+Fkr9XMuMP9I
bl48Sv6wnk7f7KQR8ofv23G6QUv3Q4f11CiqjUPkD9gQ+i3+D923elzvo34k
pftmANbWRY4EDpI/nLd5zd4wc3/xfbrEqW028of1SOwPKvvJH/4/y7XMij7y
FwbnXbbCr+g3+QO2jIm9Wb/IH7BckW6JtpI/5J3HFnl0kT9gg9davfE7+QPm
R4z+7Z3kD5jbpJ2c/5n8Ic+yDyjbyB+yV9vqSIH8If80Vm19Tv6QCyRBQiP5
Q464vF51lvwh3/Tr+nWv+aF2IPlkRdj/7/c/pU1buw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{16., 0},
  ImageSize->{960., Automatic},
  PlotRange->{{16., 20.95}, {-0.1, 2.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.584077870492245*^9}]
}, Open  ]],

Cell["\<\
==> sigma = 18.263524442109716 [16.11 - 20.56] km/generation^1/2
Because the width of the cline w is  sigma *(2*\[Pi]*T)^0.5, this also gives\
\>", "Text",
 CellChangeTimes->{{3.582456174457368*^9, 3.582456225225039*^9}, {
   3.582456425020874*^9, 3.582456467461842*^9}, {3.582598384381598*^9, 
   3.582598385668046*^9}, {3.582653480410379*^9, 3.582653523854753*^9}, {
   3.582653570170312*^9, 3.5826535868019037`*^9}, 3.582654474794179*^9, {
   3.5836388977522163`*^9, 3.583638903711673*^9}, {3.583639027556815*^9, 
   3.583639035916449*^9}, {3.583639305826778*^9, 3.58363932600632*^9}, {
   3.583733200282083*^9, 3.5837332010562153`*^9}, {3.5840810064916773`*^9, 
   3.584081027710483*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"16.11", " ", "*", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "*", "\[Pi]", "*", "4"}], ")"}], "^", 
   "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"18.263524442109716", " ", "*", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "*", "\[Pi]", "*", "4"}], ")"}], "^", 
   "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"20.56", "*", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "*", "\[Pi]", "*", "4"}], ")"}], "^", "0.5"}]}]}], "Input",
 CellChangeTimes->{{3.584081043958568*^9, 3.584081083135562*^9}}],

Cell[BoxData["80.76356300861083`"], "Output",
 CellChangeTimes->{{3.584081059193465*^9, 3.58408108550982*^9}}],

Cell[BoxData["91.55973352201316`"], "Output",
 CellChangeTimes->{{3.584081059193465*^9, 3.5840810855118856`*^9}}],

Cell[BoxData["103.07255465282672`"], "Output",
 CellChangeTimes->{{3.584081059193465*^9, 3.584081085514176*^9}}]
}, Open  ]],

Cell[TextData[{
 "==> support limits of w  = 91.5597 [80.8 - 103.1] km\n",
 Cell[BoxData[""], "Input",
  CellChangeTimes->{{3.582867926276208*^9, 3.582867933586204*^9}}]
}], "Text",
 CellChangeTimes->{{3.582456174457368*^9, 3.582456225225039*^9}, {
   3.582456425020874*^9, 3.582456467461842*^9}, {3.582598384381598*^9, 
   3.582598385668046*^9}, {3.582653480410379*^9, 3.582653523854753*^9}, {
   3.582653570170312*^9, 3.5826535868019037`*^9}, 3.582654474794179*^9, {
   3.5836388977522163`*^9, 3.583638903711673*^9}, {3.583639027556815*^9, 
   3.583639035916449*^9}, {3.583639305826778*^9, 3.58363932600632*^9}, {
   3.583733200282083*^9, 3.5837332010562153`*^9}, {3.5840810064916773`*^9, 
   3.584081027710483*^9}, {3.58408109511539*^9, 3.584081124208301*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Graphics of sigma = w/(2*\[Pi]*T)^0.5 and its support limits\
\>", "Subsection",
 CellChangeTimes->{{3.583827904417911*^9, 3.583827957694552*^9}, 
   3.583828263262854*^9, {3.5840914229154797`*^9, 3.584091424122239*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"91.5597", "/", 
      SqrtBox[
       RowBox[{"2", "*", "\[Pi]", "*", "T"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "42"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "4", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"T", ",", "\[Sigma]"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"80.76356300861083`", "/", 
      SqrtBox[
       RowBox[{"2", "*", "\[Pi]", "*", "T"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"103.07255465282672`", "/", 
      SqrtBox[
       RowBox[{"2", "*", "\[Pi]", "*", "T"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"Plot1", ",", "Plot2", ",", "Plot3"}], "]"}]}], "Input",
 CellChangeTimes->{{3.559034930689456*^9, 3.5590349318438582`*^9}, {
   3.5764702785606318`*^9, 3.576470285818873*^9}, {3.576472285564431*^9, 
   3.576472307487224*^9}, 3.582457171438074*^9, 3.582457205440475*^9, 
   3.58271602521939*^9, {3.582716136055634*^9, 3.5827161674680567`*^9}, 
   3.582716201156043*^9, {3.582716246588607*^9, 3.582716378728271*^9}, {
   3.582716411610544*^9, 3.5827164226091013`*^9}, {3.5827165393629837`*^9, 
   3.5827165419221783`*^9}, {3.583828032875387*^9, 3.583828063806233*^9}, {
   3.583828179934688*^9, 3.5838282366350718`*^9}, {3.584081143784511*^9, 
   3.584081149975379*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVzHs01HkABfCRGO/HfElaW6sinU39zIw3/a5JWYlVTKMJiTzSRuyKTXlL
TkuPxVaEVquibbZMSlmhLY+KtSpjezix6+TRmGoMDWVn/7jnns8591zL8Pgt
kfMYDIavKv/3X80jpgyGjHZ9/KA/aR0PJzSfJ2tqyGiG/xnBKfDgv6mrX09H
Rt92dVzd6M5DV9+1s+YmMrrFu/oV04mHDmmqFcdGRkvbF3uKVvHQbGFgH+Uv
o/neQcbuC3i4ksIOfFgpoyM7P3viO+qBfCr15CmPt3SZIqzMsMQDq76Um64t
f0d37Fjzcb0UGKKPj7UPvadtxpwm9+4EfIpclbKlkzR9Xr+hpY1G5bddhtaH
FPTTe/djBd1robU3JxnNU/SxChevUaU7Qt5aDkcv/kBXOSrKmSvcset6V8Gq
/Uq6zbvqHCfaDWk/luc9rZ+hz1l0zc40uyJ3ln+kgPWRFvf9NKNp7oqKdOrZ
SsEnusVz3bHcwy7Yw1sUHVE8R3ddbq37Yc4Zxu2Ts4HJDMglTM7TJGdMzcRP
xC5Ug/OzBu/WWScETIZEMtvUIGC0hkkynHCksDc5MXEeOovq5W/1ndAmFnL8
Wer4tdOz1/uiIw5W8hPFd9Rh9Y7akEc7wtU8XHh053xMnW7NTh90wD7B4L3X
RhoYdhsIS8pyQJr96COT3zUQuqzzu3IbB5RUqqfXhWhCYRbQe1Bij+U9x+sk
uky8LCtw4Ofao7FwzYl9V5iYsLbNee9iD9txvm6frxbGls6SV3IuTAxlWn8o
tVCsz7WQ1HKhcadUtKxMG7FpjeKvY7n4hnu7X9tHB1t3rH6usOLisnd4ZZNC
B7yMmoSYfzlQjC0yGi7RxYrCDr/AWg7qA7zUizz1ENDt8Vt+HAcZX+VWiIf1
sLBoJv+2IwdLX2yUVOXqo2IX7XlLnQNXx5wic7YBeAPTrCWP2AhZ3P1BrdcA
TSv23HhQyoais2BwX6YhpqNsTRgxbGyat8ZlJcsIhY5SB0tnNnQmhJvVwo1w
wXAoLUuPjewm1JTdVFlveVzeCztkBooECdrGcGIscnt/zQ4uj/o2aO80hmh0
PfnisB0GTD1ztG4Yw9xrSC9iux20rZwXeDBZMLrp032aawfpgtcjbqEsLIwd
ltfq2iGoewkrUcRCcBR7OmWYgkhQesRgjoUS6ZB4pJVCS+ufiOMTbH3j+7Pf
WQpB8kJfZjVBg3XwG7NUCve7eFT8BQLdarFm5gEK3EsKVt9FAkrNnRr9noJh
aKikupbAsqGnrjFFtW+zjdhwlUCw/dbB8P0U7EsfpuQ2EmQvm0+uJlBg8XTO
q/cSBJgdchfGUMiwaDq85zFBqnKd4F40BakiYXfvE4IzeQMZlModtf2rqyQE
N2Ly1ZlRqr3ppQbeS4Ld49vuiyMoTLz26s4cIdgYd4gmOygE3525OjJKMP2G
5qeHUug8KyraPE7Qc7TmwFgIheotZkLLCQJTs73yu8EUQhuH/2mWE/yyXliV
JKTwsORMm42C4ORRI4fBbRRcEvxqjk8RZI4FSfxUNrWujw9TEtjOL/axCaKQ
xYjd0j5DoOaZbVEsoCD7+3N76iMB4/L0rJrKodd7zE59IojMfDcet1X1fyxX
OTdHQHTixp/xKfwH4H0Y+w==
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVj2s0lAkAhgeLmaFhvs+1xKqU1jeMYViX+t6mkpZ2UVYpThGVlNuWNqWI
3dnkfskxRKtsV3PaDF2li6VWqFGoTdcdl1o+5bIusfbHe54/z3nOeS1DovzC
1Fks1pqZ/c/Hdb2GLBZD7wi/1mdtBmRr/RWvpcnQrZ0LVCdNAR/v5k5dLkPv
ilPwzYyB5vbfS0wNGDrQImeYJID7/QlWDtYMfc0m5imfDdSZ8cThPgx9JCwz
9GgPjcp9onVNZQxNC6v92DIavwgTcgqXDdKDsh8ad2jRoGyGDJee+Ei3WlVT
27uW4C2d9b7x7Sc6sP74nIG/3eGV5zbOzBumwxS7z0az3VEW16y38OAInRyu
+uwjcAN7V0o86kbpIkmcJRPjiqBBS9U28zHaeZtxJKfGBVsVzenU3nG6JsZ6
QDnLBYm5J35+Wj1BNx/MV4gTvkbqpL80nfhMF59cWs7rdkbpIeHzxQFTtM1g
UokyzBk7JbO3heZP0xPP69Xr+53AbxyeXBfPQotrUaLXHieMTkQNRJioIZef
EJnIdcLa4aAw7QY1TF0vHhaWiCHNUMbHxqrjZYqR6qmzGA1VgQ4+hAZG+0XB
Nl2OOFDmH1t1SwMO5qNGd5Mc4WYaEpi25Qssvx4tvWzniOiAN/U9+pqolo9G
TT5zQKK476HBTU2k7W8Lv5nmgIIyjUOXg7SQ+S5HxlvpgAWPsi536GhDIPne
RDEhwo0Mu+zoSm10eUsvmFwTQfDBX6d9DRvDO4nI1QdEMNBj2PfG2UjX6TN4
4SaC5i2ZfH4xB/dIqw6eugiRjtc7OV5cbJXunVtfb48Lq0PKake4UHhIQ5XH
7DHyfra+qkAHeVfztxdusEf12lUaeSt0kczkPPl3vj0Oe6aWVql0Mdn9TPvk
JyHmvfimozx1FmrYs3Nv1wvh5pySZyrigWgWXSnIFyLIvGVMTcnDqcqL3gYR
Qow8SH8TnaSHL/W2L9rqLoS3up3rYkIfRRmZ5rqkENyBQF+1EH08b+sr2Nxu
hyO1OFd8RR8HHRvvJabYIWmdPCCGw0fE0j5ms4sdXB+2e3C28OHrQTR499ni
peGKFHYNH/JXe96rTtiCY+VitEybgEGOk9b+QFv0G/X0ugcTcLtIeK4kbLG+
xYKIlROoOL7R6HSrAPIAmZQ3TWCvgNnYmy3A7Tut2O1PojXJ82j2dwKsH8pY
o11BQuZrcV5MCvBHs0QY9RsJV8VYnA0hgOPZEaL9DImgvJANlnwB9IKDOyrO
k9DZ9OePs/Rm/AZBqMclEm77IvS7uQKIZU37Um+Q+NVzd1apugCEhHtKQ0li
qnD1FauPFA6b1f60s43Egy3WHItBCv0jMTuUT0iM3R3aY8JQuH++07a8g8Sx
NEm5Tv+Mb3j2qqSLxJl/Fnl/6qUw0LOqJamXRKdd0+OG1xQ23Z241NtHwveo
+NWdVxQelMjzfD+Q6O5ewql9SaHCzzjQcoDEcnuTyqoXFIJvqN7VDc38fx0h
Ke+k0FRQ1GA9QqLLfgVV2kHBNebbc1mjJN5czLeXtVMwXFgdtXmcxIe29Izc
JxSSWRF+jRMkDnV8pcpso8A8mysWfiYx5yq14Zhypq94ZFw4RWL6dEa39PFM
PzN1fHqaRH6LV3bqIwr/AdYtIFM=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdzQs0lAkUB3DMeswoj/lCnEqiqFT6ZsYwg+8/jMZujxPRWCfkFVt5jE6N
djchWtsibxYbZVdFmVUo1qKyi9akzmxLZVNpJ1INpUkoO7v3nHvu+d3zP/fa
hMf7ReloaWmJNP3fPNxzWtYwNkFp/V9CfOv0VX6pYJK6NhS61qHPC45rp8w8
Tr2mbjYUJHsbe2GEyh3vGXlDSVwFLVcSPLG5kD8zseItFSP1cggbEaDqwC3j
VUfUVJdoe0+2WACD2HQpOt9R5JNB3twwEDxpo4xe9p5C1cPKqzFAZNOtbMdD
M5SysjcwWbNOLjj1zV/Ns9Shy2827vagkDEXkJnN/EC5G9fUb0n1QOVRpwer
xR8p+bjIO3TIHfs8raIjiuap2hBfWazQHaY9b+f8pVqYzvXh7Tnvhnez8aq9
i7Uxav9xYLGNG3a8DY7S79bG9AGhY1kRH5k5Cmliog6a6Va2gkV8dDcGsbYz
aViqG9tw+zQPX1cFJDZ20NCUNqR6vJYHvmV40HdhnyDO0CfL/oYrEsRPfhs1
0cWWNW/G6GJXJHOeyxf9qgvhmTzms0kXFFfRjl4O1gPjp2d6l0pcYHcn9/Kg
oT7ypd9fNOO5oC1nQ15CvT6mLP1qPldyse5FgOHAVgOI97wsk5Zwsch4wqBr
xgCCS9pnKW8udDvKZbYVdKTZ0a4fnnXGfvYv9+ibGYhZSL+bWe+MC5+GV7Wr
GXAYN9k1FOUM9biVibLYECmDSfVf2jmjeYeIVihcgCbJxEbDRxyk+GRUNioX
QNpSOhx4hoMVf382WJ2xEK5uk3nyaA743PRCS9IIKdJ/KvzXcBC8rP+9tsII
h3OUSfLXbKhvZj9JSDVGaSM/K/kqG1t0NvBWM01Qp1/9svUYGwxVkK92uAm4
Sk/lUV82jrWjtuKqCfqnQzMrlrCR6i8TS+imyPebbL34ggWefGATPcwUOt2t
tdxWFobNhOkGV0wh33lOaXWCBfpKV3OBPhNGcSfsJCEsvDIfHXMLYUJEe9wb
7MRCYL81M1HGxKjt4+AjeizIxOWZRvNMeDkuTzz4kMS167cRF0AgYq7jnnUj
icCpnK36NRrbnuwvzybx+y1Pp/izBArKYlWTWSTY59XMgXMELsym2/hobBwS
MlhTRyD0oG/b1AlNvntdxKYGAsU+en3bMklwyvuSMtoIdK1k+OodI8H0ZPxI
UxC4Xz9zPy2JRMqS9uP7/iRgX9HMfyAl8Uot+UJxl4C6V1jP0ri37t766kEC
5qI/ep4e1OTNzrd4PiTALnBQiA6QUI2K+lPHCBwPjeKZxpHYdWO2Yew5AWuy
r3lvLImbP8gKfV8QSLFWCLv2k6jxswiyURHgDjUWSfeRCGlTPu2cItBNkzCG
Y0j0FZd1O6gJpMlTCVeNeZJttbnvCDiMWa4viCZhtqo5fvcMAVGnokS0h0Sa
1l6/nlkCP/uplKejSEzcX8px+kDg0dMM0Vyk5n7THYvSjwRYkYUtOzXuO5kx
Mz+v+ddu4d4QQeJfe5byyA==
      "]]}}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{
    FormBox["T", TraditionalForm], 
    FormBox["\[Sigma]", TraditionalForm]},
  AxesOrigin->{1., 10.},
  GridLines->{{4}, {}},
  ImageSize->{408., Automatic},
  PlotRange->{{1, 5}, {10, 42}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.583828090687147*^9, {3.5838282148936987`*^9, 3.583828237105962*^9}, 
   3.584081152627092*^9}]
}, Open  ]],

Cell["\<\
If T varies between 2 and five, the support limits of sigma are\
\>", "Text",
 CellChangeTimes->{{3.584081473194829*^9, 3.584081490857394*^9}, {
  3.584081559148871*^9, 3.584081584864688*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"80.76356300861083`", "/", 
   SqrtBox[
    RowBox[{"2", "*", "\[Pi]", "*", "T"}]]}], "/.", 
  RowBox[{"T", "\[Rule]", "5"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"103.07255465282672`", "/", 
   SqrtBox[
    RowBox[{"2", "*", "\[Pi]", "*", "T"}]]}], "/.", 
  RowBox[{"T", "\[Rule]", "2"}]}]}], "Input",
 CellChangeTimes->{{3.584081512503788*^9, 3.584081545248047*^9}}],

Cell[BoxData["14.409222047008644`"], "Output",
 CellChangeTimes->{3.584081546749817*^9}],

Cell[BoxData["29.07623084239083`"], "Output",
 CellChangeTimes->{3.5840815467533703`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support limits of the center", "Subsection",
 CellChangeTimes->{{3.583639087296628*^9, 3.5836390973421392`*^9}}],

Cell["\<\
We compute the maxLogLikelihood for 20 values of the center, with all other \
parameters variable, and we plot the support limit\
\>", "Text",
 CellChangeTimes->{{3.582652410930936*^9, 3.582652516619972*^9}, {
  3.582653541989184*^9, 3.582653550699667*^9}, {3.583638787470213*^9, 
  3.583638872568653*^9}, {3.583639226577888*^9, 3.583639233504833*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"minim", "=", "260"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxim", "=", "330"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nbpoint", "=", "20"}], ";"}], "\n", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "0"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"(", 
     RowBox[{"nbpoint", "+", "1"}], ")"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "1"}], "]"}], "=", 
      RowBox[{"(", 
       RowBox[{"minim", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"maxim", "-", "minim"}], ")"}], "/", "nbpoint"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "2"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"FindMaximum", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"llcline2tot", "/.", 
              RowBox[{"c1", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"minim", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"maxim", "-", "minim"}], ")"}], "/", 
                   "nbpoint"}]}]}], ")"}]}]}], "/.", 
             RowBox[{"T", "\[Rule]", "4"}]}], ",", 
            RowBox[{
             RowBox[{"15", "<", "\[Sigma]1", "<", "23"}], "&&", 
             RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
             RowBox[{"h11", "<", "hp1"}], "&&", 
             RowBox[{"h12", "<", "hp2"}], "&&", 
             RowBox[{"h13", "<", "hp3"}], "&&", 
             RowBox[{"h14", "<", "hp4"}], "&&", 
             RowBox[{"h15", "<", "hp5"}], "&&", 
             RowBox[{"h16", "<", "hp6"}], "&&", 
             RowBox[{"h17", "<", "hp7"}], "&&", 
             RowBox[{"h18", "<", "hp8"}], "&&", 
             RowBox[{"h19", "<", "hp9"}], "&&", 
             RowBox[{"h110", "<", "hp10"}], "&&", 
             RowBox[{"h111", "<", "hp11"}], "&&", 
             RowBox[{"h112", "<", "hp12"}], "&&", 
             RowBox[{"0.8", "<", "angle1", "<", "1.5"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h11", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h12", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h13", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h14", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h15", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h16", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h17", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h18", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h19", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h110", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h111", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h112", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp12", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"angle1", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "-", "llcline2totmax", "+", "2"}]}]}],
     "}"}]}], "]"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "1"}], "]"}], ",", 
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nbpoint"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.58265317991616*^9, 3.582653196640175*^9}, {
   3.5826532617196207`*^9, 3.5826532667820787`*^9}, 3.582653387273225*^9, {
   3.5826537586834497`*^9, 3.582653836555855*^9}, 3.582653868312294*^9, {
   3.582653918313051*^9, 3.582653930950902*^9}, {3.582653978800293*^9, 
   3.58265398227984*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{264.1381678871392, -0.1}, {267., 0.3105416436183077}, {270.5, 
     0.7453859142633519}, {274., 1.1137842416273998`}, {277.5, 
     1.4170364072833763`}, {281., 1.656279788870961}, {284.5, 
     1.832490280005004}, {288., 1.9464939371709988`}, {291.5, 
     1.998963666610507}, {295., 1.9904050772456685`}, {298.5, 
     1.9211105392869285`}, {302., 1.7912488438323635`}, {305.5, 
     1.6007587266267365`}, {309., 1.3493598898057826`}, {312.5, 
     1.0365673555197645`}, {316., 0.6616215399244538}, {319.5, 
     0.22351922450980055`}, {321.75291027322226`, -0.1}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{260., 0},
  ImageSize->{Automatic, 401.6283810674062},
  PlotRange->{{260., 326.5}, {-0.1, 2.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.5826534429916143`*^9, 3.582653907838608*^9, 
  3.5826539608119993`*^9, 3.5826540169327803`*^9}]
}, Open  ]],

Cell["==> centre = 292.7566045078848 [265, 321] km", "Text",
 CellChangeTimes->{{3.582542603061019*^9, 3.582542650092441*^9}, {
  3.582654054098164*^9, 3.582654097548854*^9}, {3.583639192821371*^9, 
  3.583639195481523*^9}, {3.58373322982705*^9, 3.583733230251287*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Support limits of the angle", "Subsection",
 CellChangeTimes->{{3.583639200397376*^9, 3.583639213715899*^9}}],

Cell["\<\
We compute the maxLogLikelihood for 20 values of the center, with all other \
parameters variable, and we plot the support limit\
\>", "Text",
 CellChangeTimes->{{3.582652410930936*^9, 3.582652516619972*^9}, {
   3.582653541989184*^9, 3.582653550699667*^9}, {3.582653724616928*^9, 
   3.582653752167535*^9}, 3.582653863269911*^9, {3.582965921143182*^9, 
   3.5829659335259113`*^9}, {3.583639220160521*^9, 3.583639244796109*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"minim", "=", "0.96"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxim", "=", "1.20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nbpoint", "=", "20"}], ";"}], "\n", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "0"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"(", 
     RowBox[{"nbpoint", "+", "1"}], ")"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "1"}], "]"}], "=", 
      RowBox[{"(", 
       RowBox[{"minim", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"maxim", "-", "minim"}], ")"}], "/", "nbpoint"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"deltaLL", "[", 
       RowBox[{"i", ",", "2"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"FindMaximum", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"llcline2tot", "/.", 
              RowBox[{"angle1", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"minim", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"maxim", "-", "minim"}], ")"}], "/", 
                   "nbpoint"}]}]}], ")"}]}]}], "/.", 
             RowBox[{"T", "\[Rule]", "4"}]}], ",", 
            RowBox[{
             RowBox[{"250", "<", "c1", "<", "350"}], "&&", 
             RowBox[{"15", "<", "\[Sigma]1", "<", "23"}], "&&", 
             RowBox[{"0", "<", "h11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp1", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h12", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp2", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h13", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp3", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h14", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp4", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h15", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp5", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h16", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp6", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h17", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp7", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h18", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp8", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h19", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp9", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h110", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp10", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h111", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp11", "<", "1"}], "&&", 
             RowBox[{"0", "<", "h112", "<", "1"}], "&&", 
             RowBox[{"0", "<", "hp12", "<", "1"}], "&&", 
             RowBox[{"h11", "<", "hp1"}], "&&", 
             RowBox[{"h12", "<", "hp2"}], "&&", 
             RowBox[{"h13", "<", "hp3"}], "&&", 
             RowBox[{"h14", "<", "hp4"}], "&&", 
             RowBox[{"h15", "<", "hp5"}], "&&", 
             RowBox[{"h16", "<", "hp6"}], "&&", 
             RowBox[{"h17", "<", "hp7"}], "&&", 
             RowBox[{"h18", "<", "hp8"}], "&&", 
             RowBox[{"h19", "<", "hp9"}], "&&", 
             RowBox[{"h110", "<", "hp10"}], "&&", 
             RowBox[{"h111", "<", "hp11"}], "&&", 
             RowBox[{"h112", "<", "hp12"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"c1", ",", "300"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]1", ",", "16"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h11", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp1", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h12", ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp2", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h13", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp3", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h14", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp4", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h15", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp5", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h16", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp6", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h17", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp7", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h18", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp8", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h19", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp9", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h110", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp10", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h111", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp11", ",", "0.9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h112", ",", "0.21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"hp12", ",", "0.9"}], "}"}]}], "}"}], ",", 
          RowBox[{"MaxIterations", "\[Rule]", "10000"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "-", "llcline2totmax", "+", "2"}]}]}],
     "}"}]}], "]"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "1"}], "]"}], ",", 
        RowBox[{"deltaLL", "[", 
         RowBox[{"n", ",", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nbpoint"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.58265317991616*^9, 3.582653196640175*^9}, {
   3.5826532617196207`*^9, 3.5826532667820787`*^9}, 3.582653387273225*^9, {
   3.5826537586834497`*^9, 3.582653836555855*^9}, 3.582653868312294*^9, {
   3.582653918313051*^9, 3.582653930950902*^9}, {3.582653978800293*^9, 
   3.58265398227984*^9}, {3.582654149339608*^9, 3.5826542415019817`*^9}, {
   3.5826542881108828`*^9, 3.58265430283671*^9}, {3.582654355543565*^9, 
   3.5826543593655033`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQneYYcPTX8Xf2s2aCwM79W06U7Zsv9d6egeHCKrbN
Z+w3FGVMfFsD5D9YfWR/3iP7NTJRKdb3gfwGqyrziW/sQx4vnX1E4YM9Q0Bv
a8eRT/ZBO+RaXwcC+RvMpiUu/WYf0Ds9T6gZyBco5Pz15Ke9X5JAhOUWIH9C
8LQpNX/sfcw7HROeAvkOum9NUv/Ze/EwabeLfbRn+BDtHDv9v73HwyqRde5A
/oncw92sDA5u2z7/vVIB5BtYPn20/b+9S3fO898rgfwJSVN3T/lnDzTsgtJt
kHzgst/T/9jbm8bt8uT5ZM+Q0LsqdvtPe1uu64sLbIF8BYUizhdf7a3v+wNd
COQHFHrayn20twQHAJDPoBVjNvuZPdh5F4B8B/69n5ZetHdf0hn16esneHgB
AB7cngw=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  ImageSize->{Automatic, 401.6283810674062},
  PlotRange->{{0.96, 1.188}, {-0.1, 2.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.5826534429916143`*^9, 3.582653907838608*^9, 
  3.5826539608119993`*^9, 3.5826540169327803`*^9, 3.5826542757686996`*^9, 
  3.5826543262393703`*^9, 3.582654382564672*^9}]
}, Open  ]],

Cell["==> angle = 1.0810672027369257 [0.96, 1.18 ] rad", "Text",
 CellChangeTimes->{{3.582542603061019*^9, 3.582542650092441*^9}, {
  3.58254382311419*^9, 3.582543841192623*^9}, {3.5826544125893373`*^9, 
  3.5826544130837173`*^9}, {3.582654448210277*^9, 3.5826544512102623`*^9}, {
  3.58363926195347*^9, 3.583639266183824*^9}, {3.583733245373312*^9, 
  3.583733246397292*^9}}]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Linkage Disequilibrium\[CloseCurlyQuote]s method\
\>", "Title",
 CellChangeTimes->{
  3.582533320355657*^9, {3.583636028447185*^9, 3.583636035688686*^9}}],

Cell[CellGroupData[{

Cell["\<\
Theory: Maximum LD in case of a secondary contact (Barton 1982, 1993)\
\>", "Section",
 CellGroupingRules->{"SectionGrouping", Inherited},
 CellChangeTimes->{{3.58253339635996*^9, 3.582533430994843*^9}, {
  3.5825336121157017`*^9, 3.58253361832043*^9}, {3.583825250293858*^9, 
  3.583825251388516*^9}}],

Cell[BoxData[{
 RowBox[{"LDmax", "=", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[Sigma]", "2"], "r"], 
   FractionBox["1", 
    RowBox[{"w1", " ", "w2"}]]}]}], "\n", 
 RowBox[{
  RowBox[{"with", " ", "the", " ", "cline", " ", "width", "     ", 
   FractionBox["1", "wi"]}], "\[Proportional]", 
  RowBox[{
   FractionBox[
    RowBox[{"dpi", "[", 
     RowBox[{"x", ",", "T"}], "]"}], "dx"], "   ", "in", " ", "the", " ", 
   "vicinity", " ", "of", " ", "the", " ", "cline", " ", "center", "   ", 
   "so"}]}], "\n", 
 RowBox[{"LDmax", " ", "\[Proportional]", " ", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[Sigma]", "2"], "r"], 
   FractionBox[
    RowBox[{"dp1", "[", 
     RowBox[{"x", ",", "T"}], "]"}], "dx"], 
   FractionBox[
    RowBox[{"dp2", "[", 
     RowBox[{"x", ",", "T"}], "]"}], "dx"], " ", "in", " ", "the", " ", 
   "vicinity", " ", "of", " ", "the", " ", "cline", " ", "center"}]}], "\n", 
 RowBox[{
  RowBox[{
  "In", " ", "case", " ", "of", " ", "a", " ", "neutral", " ", "mixing", " ", 
   
   RowBox[{"(", 
    RowBox[{"see", " ", "above"}], ")"}], "    ", 
   RowBox[{"p", "[", 
    RowBox[{"x_", ",", "T_"}], "]"}]}], "\[Proportional]", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"c", ",", 
       RowBox[{"\[Sigma]", " ", 
        SqrtBox["T"]}]}], "]"}], ",", "x"}], "]"}], "    ", 
   "thus"}]}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{"dp1", "[", 
    RowBox[{"x", ",", "T"}], "]"}], "dx"], "\[Proportional]", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"c", ",", 
       RowBox[{"\[Sigma]", " ", 
        SqrtBox["T"]}]}], "]"}], ",", "x"}], "]"}], "    ", 
   "thus"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"dp1", "[", 
      RowBox[{"x", ",", "T"}], "]"}], "dx"], 
    FractionBox[
     RowBox[{"dp2", "[", 
      RowBox[{"x", ",", "T"}], "]"}], "dx"]}], "\[Proportional]", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"c", ",", 
        RowBox[{"\[Sigma]", " ", 
         SqrtBox[
          RowBox[{"T", "/", "2"}]]}]}], "]"}], ",", "x"}], "]"}], "   ", 
    "thus"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LDmax", " ", "\[Proportional]", " ", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[Sigma]", "2"], "r"], 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"c", ",", 
       RowBox[{"\[Sigma]", " ", 
        SqrtBox[
         RowBox[{"T", "/", "2"}]]}]}], "]"}], ",", "x"}], "]"}], "    ", "in",
    " ", "the", " ", "vicinity", " ", "of", " ", "the", " ", "cline", " ", 
   "center"}]}]}], "Text",
 CellGroupingRules->"NormalGrouping",
 CellChangeTimes->{{3.5825334526168737`*^9, 3.582533460957079*^9}, 
   3.582533515749576*^9, {3.582533555659724*^9, 3.582533597150692*^9}, 
   3.5825339280697117`*^9, 3.5836404275170717`*^9, {3.583655831928173*^9, 
   3.583655846756465*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Estimation of the k",
 StyleBox["0, 2",
  FontSize->14],
 " cumulant (LD) in each sample"
}], "Section",
 CellChangeTimes->{{3.583646881349391*^9, 3.583646903080036*^9}, 
   3.5836470037388153`*^9, {3.5836549934501953`*^9, 3.58365499659942*^9}, {
   3.583734377093689*^9, 3.583734379037479*^9}}],

Cell[CellGroupData[{

Cell["data", "Subsection",
 CellChangeTimes->{{3.583647902204917*^9, 3.583647908996045*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Barton", "'"}], "s", " ", "packages", " ", "at", " ", 
     RowBox[{"http", ":"}]}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"www", ".", "biology", ".", "ed", ".", "ac", ".", "uk"}], "/",
         "research"}], "/", "groups"}], "/", "barton"}], "/", 
     RowBox[{"index", ".", "html"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"<<", "Multilocus`EstimatingD`"}], ";", 
    RowBox[{"<<", "Multilocus`DataManipulation`"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Raw", " ", "data"}], " ", "=", " ", 
     RowBox[{
     "vector", " ", "of", " ", "individual", " ", "multilocus", " ", 
      "genotypes", " ", "in", " ", "each", " ", "of", " ", "the", " ", "13", 
      " ", "samples"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "1", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "1", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "1", ",", "0", ",", "0", ",", 
         "0", ",", "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "1", ",", "0", ",", "0", ",", 
         "\[EmptySet]", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "2", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "0", ",", "\[EmptySet]", ",", "1", ",", "0", ",",
          "\[EmptySet]", ",", "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "0", ",", "\[EmptySet]", ",", 
         "0", ",", "0", ",", "2", ",", "0", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "0", ",", "\[EmptySet]", ",", "1", ",", "0", ",",
          "\[EmptySet]", ",", "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "0", ",", "\[EmptySet]", ",", "2", ",", "1", ",",
          "\[EmptySet]", ",", "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "0", ",", "\[EmptySet]", ",", "2", ",", "1", ",",
          "\[EmptySet]", ",", "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", "0", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "1", ",", "\[EmptySet]", ",", "\[EmptySet]"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "1", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "3", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", 
         "0", ",", "\[EmptySet]", ",", "1", ",", "1", ",", "1", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "\[EmptySet]", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "\[EmptySet]", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "4", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "5", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "\[EmptySet]", ",", "2", ",", "2", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", "2", ",", "0", ",",
          "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "0", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "\[EmptySet]", ",", "1", ",", "1", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "1", ",", "2", ",", "1", ",",
          "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", 
         "0", ",", "\[EmptySet]", ",", "2", ",", "1", ",", "0", ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "2", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "\[EmptySet]", ",", "0", ",", "1", ",", "0", ",", 
         "\[EmptySet]", ",", "0", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "0", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "6", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "\[EmptySet]", ",", "1", ",", "2", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "\[EmptySet]", ",", "0", ",", "2", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "\[EmptySet]", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "0", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "7", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "0", ",", "1", ",", "1", ",", "\[EmptySet]", ",", 
         "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", 
         "0", ",", "\[EmptySet]", ",", "2", ",", "0", ",", "1", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "1", ",", "2", ",", "0", ",", "1", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "0", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "8", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "2", ",", "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "0", ",", "0", ",", "\[EmptySet]", ",", "0", ",", "1", ",", "2", ",",
          "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "1", ",", 
         "2", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",",
          "\[EmptySet]", ",", "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "0", ",", 
         "0", ",", "\[EmptySet]", ",", "0", ",", "0", ",", "2", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "0", ",", "0", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]"}], "}"}]}], 
      "}"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "9", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", "2", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "0", ",", "2", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "0", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "10", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "\[EmptySet]", ",", "0", ",", 
         "2", ",", "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "\[EmptySet]", ",", "0", ",", 
         "2", ",", "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "0", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "11", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", 
         "\[EmptySet]", ",", "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "0", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]", ",", "2", ",", "2", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "1", ",", "1", ",", "2", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "12", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "2", ",", "2", ",", "0", ",", "2", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "0", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "0", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "1", ",", 
         "1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "2", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", "1", ",", 
         "0", ",", "\[EmptySet]", ",", "2", ",", "0", ",", "2", ",", "2"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "1", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
         "\[EmptySet]", ",", "\[EmptySet]", ",", "\[EmptySet]", ",", 
         "\[EmptySet]"}], "}"}]}], "}"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rawdata", "[", "13", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "0", ",", 
         "2", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "0", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "\[EmptySet]", ",", "2", ",", "\[EmptySet]", ",", 
         "0", ",", "2", ",", "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "0", ",", "0", ",", "1", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "0", ",", "1", ",", 
         "2", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "1", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "1", ",", "0", ",", "0", ",", 
         "2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "0", ",", "2", ",", 
         "1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "0", ",", "2", ",", "2", ",", "2", ",", "0", ",", "2", ",", 
         "1", ",", "2", ",", "2", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "vector", " ", "of", " ", "frequency", " ", "differences", " ", "along", 
     " ", "the", " ", "cline", " ", "for", " ", "each", " ", "locus"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Delta]p", "=", 
     RowBox[{"{", 
      RowBox[{
      "0.750416488", ",", " ", "0.40718329", " ", ",", "0.942944208", ",", 
       " ", "0.208677425", ",", " ", "0.422220708", ",", " ", "0.149241762", 
       ",", " ", "0.849469579", ",", " ", "0.321219", ",", " ", "0.525423345",
        ",", " ", "0.879921491", ",", " ", "0.310310407"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5600012591724615`*^9, 3.56000128636331*^9}, {
   3.58364606202322*^9, 3.583646088704791*^9}, {3.58364613282493*^9, 
   3.5836461511611233`*^9}, {3.5836462881427402`*^9, 3.583646333209798*^9}, {
   3.5836465909172907`*^9, 3.583646627918898*^9}, {3.583646674396338*^9, 
   3.583646696624337*^9}, {3.583647675486895*^9, 3.583647686936365*^9}, 
   3.583812087830905*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Data", " ", "conversion"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "0"}], ",", 
      RowBox[{"i", "<", "14"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{"Data", "[", "i", "]"}], "=", 
       RowBox[{"ConvertData", "[", 
        RowBox[{"rawdata", "[", "i", "]"}], "]"}]}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "0"}], ",", 
      RowBox[{"i", "<", "14"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{"pl", "[", "i", "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"AlleleFrequencyTable", "[", 
           RowBox[{"i", ",", "13"}], "]"}], "]"}], "//", "N"}], "//", 
        "Last"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Matrix", " ", "of", " ", "cumulants"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"cc", "=", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{"0", "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "12"}], "}"}]}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"cc", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], "=", "1"}], ";", 
    RowBox[{
     RowBox[{"cc", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], "=", "k2"}], ";", 
    RowBox[{
     RowBox[{"cc", "\[LeftDoubleBracket]", 
      RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], "=", "k2"}], ";", 
    RowBox[{"cc", "//", "MatrixForm"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5297463645*^9, 3.529746367875*^9}, {
   3.529746403671875*^9, 3.529746440984375*^9}, {3.54261036015625*^9, 
   3.542610360765625*^9}, {3.542611266234375*^9, 3.542611290703125*^9}, 
   3.542612687328125*^9, {3.542612833609375*^9, 3.542612835453125*^9}, {
   3.5599962872529125`*^9, 3.5599962879639535`*^9}, {3.560059929137302*^9, 
   3.5600599320545073`*^9}, {3.560059966296567*^9, 3.560059966873768*^9}, {
   3.5600600046414347`*^9, 3.560060005234236*^9}, {3.560060147336893*^9, 
   3.5600601478672943`*^9}, {3.564321386282998*^9, 3.5643213866429987`*^9}, {
   3.583646107480172*^9, 3.5836461235037317`*^9}, {3.583646849282687*^9, 
   3.583646859665244*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "k2", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"k2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.5298340177532606`*^9, 3.5298340429473047`*^9}, 
   3.529835669031761*^9, 3.529836161306226*^9, 3.54261094746875*^9, {
   3.542610981390625*^9, 3.54261103159375*^9}, {3.560000448658842*^9, 
   3.5600005035543995`*^9}, 3.5600010859897285`*^9, 3.5600013796046734`*^9, 
   3.5600733987857504`*^9, 3.560073626128152*^9, 3.5600738858918095`*^9, 
   3.560074070861334*^9, 3.5600741117490063`*^9, 3.5605188233924885`*^9, 
   3.56051906344571*^9, 3.5605775547344446`*^9, 3.564128145756405*^9, 
   3.5643233455774555`*^9, 3.5644026953153577`*^9, 3.564467716391836*^9, 
   3.5644761742538223`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["sample 1", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD1", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"1", ",", 
      RowBox[{"pl", "[", "1", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601407619884667`*^9, 3.5601407674328766`*^9}, 
   3.5602506391434555`*^9, 3.560511660499507*^9, 3.5605769155545216`*^9, {
   3.583647513891135*^9, 3.5836475382470083`*^9}}],

Cell[BoxData[
 RowBox[{"LLLD1", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5601407852793074`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik1", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1.0430056172654036`*^60", "-", 
      RowBox[{"8.945781993294531`*^61", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0050785781445185415`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.3327986975631658`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0025000455138698076`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.16748897328888113`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.012630203037672193`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.0864317133625069`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0011599809345230528`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.045828080888253034`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0015438725078101025`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04110439795524019`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.01449976168153816`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.03975933930641509`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.002322853485191721`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.029639435528587863`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"3.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.012757780846133535`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.027189360572249483`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00045775690036660855`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.015433099940039418`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00006247479045467219`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0007203152682613617`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00005639772624415109`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.004824523198187903`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.008263562593518313`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.008135789560881797`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"4.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.016759307876911177`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.28031493795229784`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"4.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.01470114726044841`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.3170987511117995`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"3.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.016666970092465386`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.503443306603856`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"3.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.01462014920391701`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.5310296238764189`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"5.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.02031431257807417`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.5880122538153104`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.05789579084751134`", "\[VeryThinSpace]", "+", 
       RowBox[{"1.3585818798946374`", " ", "k2"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.56439036515724*^9, 3.564390369448246*^9}, 
   3.564390924953038*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik1max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik1", ",", 
      RowBox[{
       RowBox[{"-", "0.08"}], "<", "k2", "<", "0.02"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.01"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.5606689524733763`*^9, 3.5606689554061813`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "43.921737425102464`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.005143013240738222`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560159573203507*^9, 3.5601694892049236`*^9, 3.5602489336704607`*^9, 
   3.5602491191703863`*^9, 3.5605898351706142`*^9, 3.5606698113016844`*^9, 
   3.5643909316150503`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\n", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik1", "-", 
     RowBox[{"Lik1max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.583647379477694*^9, 3.5836474412522783`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8fB/ATUslKNkkqo5BKKsn7lpGViMgqM0X23te8DSFU0pIUqZDZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.02, 0.02}, {-8.169475875408654, 1.9999987090550917`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, 
   3.5601595856679287`*^9, 3.560249176188486*^9, 3.560249266294245*^9, 
   3.560589839304621*^9, 3.560669812596487*^9, 3.564390934657056*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik1", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik1max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.01"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.560249273938258*^9, 
  3.560249274359459*^9}, {3.560669002970665*^9, 3.560669005123469*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.0038637445465737378`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5601533751098204`*^9, 3.5601595895835357`*^9, 
  3.5602492815042715`*^9, 3.560589848446237*^9, 3.5606698150456915`*^9, 
  3.564390939569064*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik1", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik1max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.01"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.5606690081498737`*^9, 
  3.560669011113879*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.010782477954238404`"}], "}"}]], "Output",
 CellChangeTimes->{3.5601533814122314`*^9, 3.560159591268339*^9, 
  3.560249290443087*^9, 3.560589852221444*^9, 3.560669816075293*^9, 
  3.564390944449071*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 2", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD2", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"2", ",", 
      RowBox[{"pl", "[", "2", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.560140799132132*^9, 3.5601408109881525`*^9}, {
   3.5602506265230336`*^9, 3.5602506275682354`*^9}, 3.560574091637562*^9, 
   3.5605769251953387`*^9, {3.583647551511505*^9, 3.583647552705348*^9}}],

Cell[BoxData[
 RowBox[{"LLLD2", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.5601408386470013`*^9, 3.560140839068202*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik2", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"4.5865717985064214`*^39", "-", 
      RowBox[{"9.436582330968947`*^41", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003193628013118721`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.30433515957860907`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009928017519042981`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.2093155040226427`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009300640550933348`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.19033816025793593`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.01446525629471421`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.17771862591122684`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.007512055829600013`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.14488335311331127`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0037639187297470646`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.1438648652062439`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003374228176406765`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.05031742626669453`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004699817817137994`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.046581044235160685`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005280966583784552`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04496313543101812`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0027362918293339406`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.03806863587105651`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0004532545311591177`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.010917419857857985`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007664410327974755`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.005339552668133795`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00024101629831476892`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00957232240675266`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"6.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.005913994263365226`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.07152320426977729`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.02092644123960003`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.33573984697568393`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.03380425123320005`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.34131072484856473`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.010096861354400855`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.3936245117327991`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.019237806840929437`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.6987548652167204`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.03262062899114122`", "\[VeryThinSpace]", "+", 
       RowBox[{"1.0143181347145216`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.055313240463239474`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.430776150629906`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.5643905685365334`*^9, 3.564390571086537*^9}, 
   3.5643912306714897`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik2max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik2", ",", 
      RowBox[{
       RowBox[{"-", "0.01"}], "<", "k2", "<", "0.05"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
   3.560153993214106*^9, 3.5601540645686316`*^9}, {3.5601541076403074`*^9, 
   3.560154110541912*^9}, {3.5601542302253227`*^9, 3.560154236106533*^9}, 
   3.5601542812530117`*^9, {3.560159996713051*^9, 3.560160059939962*^9}, {
   3.5605898780082893`*^9, 3.560589915619955*^9}, {3.560669026823107*^9, 
   3.5606690295531116`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "50.885521006684776`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", 
     RowBox[{"-", "0.0009012778214018257`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, {
   3.560153983011688*^9, 3.5601540657074337`*^9}, 3.5601541140051184`*^9, {
   3.560154282813015*^9, 3.5601543013302474`*^9}, 3.560159742822605*^9, {
   3.560160013919881*^9, 3.5601600606263633`*^9}, 3.5601693798331313`*^9, 
   3.5602493418919773`*^9, {3.5605898612694597`*^9, 3.560589916087956*^9}, 
   3.560669822767705*^9, 3.5643912344824953`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik2", "-", 
     RowBox[{"Lik2max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.015"}], ",", "0.01"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.560154081307461*^9, 
  3.5601540919934797`*^9}, {3.560154141944768*^9, 3.560154162661604*^9}, {
  3.560154310627864*^9, 3.5601543518899364`*^9}, {3.560159753680224*^9, 
  3.5601597579858313`*^9}, {3.560160086491208*^9, 3.5601600894240136`*^9}, {
  3.5601601251012764`*^9, 3.5601601440085096`*^9}, {3.5601603431272593`*^9, 
  3.560160344250461*^9}, {3.560160765778802*^9, 3.560160841111334*^9}, {
  3.5602493523127956`*^9, 3.560249358225206*^9}, {3.560589920736764*^9, 
  3.560589933169986*^9}, {3.560669032173916*^9, 3.5606690349975214`*^9}, {
  3.583647446490795*^9, 3.583647447665903*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12XlYjN/bAPBRaRPtaMEIFSqkIuEeRYvSRvs27YuolJKiodJOIuSLJlQo
FSVpO4+0kBaFlLYpUZaS1mmZeX7n/eP9a67Pdd/nnOc5c+5zzlyz3i3A0pOH
QqFEL6FQ/u+zyrSCU0VNQd1raX2m1pJECVVlQVE2BREhrsObJySIug+jZu+l
U9DIHu87hi8kiA5G4cMA8RQU2D6uGBohQcyx1E3LBFMQlVVs2iwqQQhfnbrv
yJeCfM5ZSIX3ihPyB0pnKZQUZJsrYajxVJzYn6WdZTSbjFZnXfRStRQnLrrS
pr5+T0Y+zDNZZwvEiGviPEZRA8nozCrZnNp4MeLh6zd3N/Qmo1tORUjFQ4xo
WG9g4P8pGcWveSQjvlaMEBk8cptTk4yIvYzvCtqixJo00b9Z1cmIprza0nhx
BaGm26anX56MAgs9zn0lVhDm94+NXn6WjMa9ozN/HFlBpLs50KhMnH9VbbNI
6HLij87KmBV3kpFYzO8d0vrLiYPSbQ2LN5OROTXdYnrlcmKiQd+s6wrO36fS
JlMhQpirqjunReH+8l683SQiQgizBSP5XJIRa3+8DV+TMOHa9gZN2Ccj+nz+
Wr8cYaLsyXneAetkxBD95Gh8QZjwdppKrDLF/W/N/BS0W5iorenPCN2Pn3cX
22QiT4iISil9ObImGX2IVKoxzBYkOryCFjpkktF2hTLjxVhBQo2mAnXSuD/z
fHGKtyDRM5FVn7Ucjzfa+258syCxxzblsz0nCW33nGk6VCxATCl4TDb1JCH6
mJCiRzs/4Vsmvu3Zf0kotTns7nftpcTleenB4ps4zrYW8lBYSpTslU0vvZaE
aCPWXcLLlhJcQmGhIikJBbaoclt6+Ii0dzsb6iNwe6s/Resu8hHlX61cehyS
UFHhzwbXj7yECCfjioB8EhIb//iAL4WH2AH3dIVXJyFqeX9xXDgPYX3h/rSI
FH6+YPbSjV48BHNpnoOECI7fKVDKBR5Cc0Wl0prFRMSg+lS3TC4hnNf1IfWe
RGS+icl2oy8hCg8ojDvdSUT0etG5fkMK8fy4mKTwrURUVGqumqFFIUrSuZql
13D+kiffvDZSiLKfXyNWJCUi1lrq6H4KhSCuXhNA4YmIEluVVhpEovYBvnVU
GxyPbPmm6sBFUxeGjwyKJyKmH4M312AR7a7Jz/OKS0BEG9+P+FA2Ykhfr3KM
TkD0N8FicQ5s9NYnotUyKgExgP/PLRob2YkentwfloBYSaaKs8JsdNZxeM8q
b9x+y5HmDOYsqppZ39igj3231du+dQbpbr05osyP+8uO0xjXnkYm1y9s+h0T
j+gyh93y9k2g+04fMt77xyGK+J+UlsER5Gcfzmqwu4QoXi0e59/0ospH/t/B
LhZR1qRW3uVrRBZjXUOSejGI4iNzra0wDwJir953h2hEKROai4loA9LsgXor
7SKe3yqh3rV90C6+reqGygVEEdxbWO/4HbZvWsr/dQsD0Ux4IoTqfkGmy5O0
CcXziPJy4cmg5Di86eZW+fBEIvp9lgd/1AQszA97dvCcRawR+YWSK1NQJljH
s/glDDFM/tkr356BhFda8jLtpxGzTmel/1E29Nve2TLGDEY0neoiGco8yLiU
9s6HByHqVz6BiOAFaBFrlOX+PYnoIylJdVmLkLzp78K1vpOI2TkgcSlnEYz3
SPVubsbxixZBenmL8NbdOdPqyUk8fvnzkpJFeFM6seGpB3aElG5QwyKUOcqp
OnadQMSqLnfLP4uQ9cgfymv8EUtGTa54JwdCaKIeoel+iP65+VJ/GQeM51cv
0Yj1Q0zqxi+plRxQKFG49y/EDzFuKtoAwYE2Ja1O/2N+iJog8P1aAwfURJ1M
3CX9EDFC2S7XwYGR3ica5ld9EbXICu5PcMAhQn/plhQfxHJuXpa6mQvqmub3
hyN9ELN6ZdkPFS4I/7WDbH8fRD1fl7BnOxfK3E6EU01wftv3/7q0uCB1+Pro
ymU+iBItHTStx4WW1YOfeRO8ET0+JPmBExd0S8/l9MZ4IUJB/WPHZS6YSz6l
jIZ4IXpRy7maq1xwCeyxX/TwQswBLee861yI3KIjKnfIC1F+va8Ouc2FF/fY
YbZLvRBLKX3yezYXlOOCjT7GeiJCTKXlQCUXVtj6/nl7yQMxBo/u6/nBBfkX
t/Q7Qz0Qs2u4+cRPLmyVeMsc9vJArOM6lxZ/c8GwSdGK38AD7ye7/MX/ceEC
bahKT8ADUQ7xUGQWuDCl7HKlOs4dUW/ld95bQULX3DH1kng3xDKIrriwkwTH
ma0mvmFuiO5GURzWJKFvgsdrrZcbYjJGNxjtJmHod1FGvJ4bolTt/cKzj4Sx
XpElTlxXxGqNFDiiTwJPTW3r0hBXRM95/1PHloQtiRonbFzoiOkT6Hg+nIT8
S8viREzpiKV5kQiJIGFb9CDz9V7sS0cyvc+RoBGZ+mmrLB3Rr714p3uBhMie
zjDKExfEYoqXt8ST8PChobRlujNiXs402HuThGkNZfPp446Iwi/W5v2MBJUz
mQsFxtjKSYLtz0lwq1iZ67PVERE6C9LaJSS0HFjK7f7lgKhpiYWcUhIemQ7m
1fg64O9rqJ5eSYK9zx2BVG97RIT7t6bUk5CaJ1lsZGCP6NeL+eoaSKgfS3Tm
VcL2reWZe0vCztPhL0J/2CEmt8PK5j0JIhet3Z087RDrVxqMtpJQ/Z8Y2uJu
i5gbyh3PdZIw1RfnN6Rri2g1fS8YXXh+FEjpewq2iL770TvGVxJuPhr1Fx+0
QayyyDVhPSQEvmiUZdNtED1Dy3Evi4Qc9oH6ZzQcr7sWuGmAhF6dV0HHqTaI
EUzdvWyQhMM1uW/7+q0R3WOup+kbCRtaY0LrnK0RVa7WTXkYv5/E4vqo/daI
SUfTM9ipVsHNu9fieN82jZoREha7XTfm91ohquf5QtNfJHSM7G9Pc7RCzOLJ
aBjF76dSes5krxViMGusJ7F1A1Q388tbIfq6pc0PxkgonJZjhHcfQ9RDLZnz
f0mI55lTpdsfQwz+tNdRE/j5Y5Ct565jiBjN3bNpkoQ6/kvRflI4X0DkZT02
zzLJrpCWo4h2zq6EM0XC+pQu3rN5RxFFKFn92jQJNFGmWlT8UUSnZhZsnCHh
nKRqTILuUcT68uO2ziwJd9InCy6vO4qYKjaCr7HLV5V3XVu0RKyQdSd12SSw
5Qy23Su1RPQQ+TXacySc2uj69fkW7M1KA9PzeD5ylJaWCVji5635ab+A30d5
bFvVkAViPDLvr8D+oxIR23DPAjETTycFLZKwrPBAUVOEBWKdWgP12Ft2CHa3
2eK4f0/XSg4J3prp23skcPx7QXUe9qWXDg4Df80RK6xu6Tj2Q22FSz+azBFV
e051O5eEmoqRot+PzRFNokHTH3tgX2H3+CVzRAg9kXuITSFO88+44/b6cn1f
sNfq7t2xQMP5ImkRAiQJ+2p5HClrcX8voyfUsV8mpy1fNmOGWOXuB+yxp1LX
uUsXmSFm5gOvc9jq6fll6/zMEJ1STL+DHZChvWLLRjNEiSdVX2Ln36131+gz
RZTRqaZm7J9ZR1/tv2WKiPFFHRa2Yg5rhZGlKaI7RYWPYbs/OeFxVMQUUZcM
RrOxmQXzr5zqjyBWfrwdF7v3eZyoDwN7x2ccJkH2pZTnqT1HcHslOgfbtiKr
PHLKBO9fPSkz2OlITSyuALvGgvEbu/1NhedVHxPEDOzX7MEWe2tY8Z+CCaI8
7s1/i32k6bNYTo8xYvLc/1aEnfjBzavohjGiUhid17EbPv2tKDfHXvEuIQSb
rytSvE7YGBHnm6bNsHV7hbxbaw8jRuIXWSXsqIEblV3nDyOaoebsHJ7vyu8b
JIZ2H0bMArWEt9jzP4u8xyaMEOOycGsadshEowSvtxFiap0NkMV+NmPjs3w9
dnNq/Rf8fY/ND1Wt6jZE9LArjanYvrykj4qZIWKdVW+fxusnRyC5WkvIEDF4
DduzsIeWyUgdeGOAWLNKZ4ywnaV2Iqtd2J/ECpLwejyTbS2UO6GPmGtz1ipj
p2mdPcp+qo/Xi4s1gddzne3r4dsb9RHLV19qCK/3vp9DO/70H0Ks5qkbAdjs
s4KR+/47hJj59V0zuD5U7pqJscSx6ytvsXH96KsF2+9oPoiYoWbiwdh0dOPh
xfiDiBozqPsT19+1gd7dm0g9xNrU8u4trs/5Tf6ufn90EUvgzs5juJ6lXl7J
q8jVRUTJ+gP5uP7VDIunRdxxPGqaTf4jwdVvPqGw6wBiRPDQb4+T8LYg/vlU
PQ0x+ZM6buP9ZRDyFw9dpCHqT78lH/7g/elDq/7NfdiqFg0UbOcfqqXBPoCo
ii7yVni/Ug04LMDV3Yfo7ntK3v7Az3v16n/MV3tx+1WMr99JuF7cuU1vO/bz
VV+Gh0hYmPWyjV+jg6iLDmun8f75jhH9WIK9G9FXn+ns6iPBM63SWOmpBp5P
J8XGzyTcKuFlvduggegP/z259omEpo7DIf63dyIqjN6y/YjPA7muO8/i1BEh
bPzo0wcSljycHtVx247vU47W6fh80DnuRM1SU0Y0Oa0pLQLP9xItATc1JcQ6
uX75h2pczzdXjCmoKSIKPV7QswrX+xtU8VB1I76PLsu8WE5CrayCzSMVKmJa
qEol4/Ps1vVmORcrMUT8PejakYvrm8Fpf/1YBNG+5Jeo5JDwqtPlZN0jQXye
RzWef4jXd/zG7KYcCq5HQc2VWXh+flVauTmUVDP8bjWK38b1Yg8Sgp6iQA12
XLknCZ+fF07q8BSLA915d6pxAgkMq6oTjGJJoFh3P7aNw/XAsW+PLFkFhNmJ
Ys9ofH6b3vjvdOk6YAUM9B/G5/vVMP6bO3uVgFh9Oh388P6dXH09bXwnMNfS
rrw+iNf7IemNMREaQP8tu1tEF58v5PHi0/yaQL8U6mIB+H4SJNNuK68FLFCU
f6+N92ubENF1hruBVZM2GqGG90+FLYl5mXuBplA40LqShJieRnDL1QVmHvuS
0jcu7NIOFej+owuUPTLiFf1c+JW+vvWouh4wqfEPDHvwfc3sjPOhKj1gyUq2
WXzmwpqaTeeUPx4E5tjnbrkGLpTmMsrHuPrAnN/Dm/SYC8OntDQjrI2B8su3
q9SXC7t1zJZb3TQG+hXtL42eXIjn9fmu1onjff82dblyYcv1jPRBOxOg+K3J
GbLjgv+LxWkjpyNAC5QhSo24MD5bU7rawwyotb6VespcOFetJN9dZgHUysvX
B1kcyFHQEDTssgC6SU747h4OtFyiTZXMWQDNK3JD/BcOrDWza7q8xxJYtOXP
pVo4QPQnRupWWgJD9MWOwXIO8CwZ63mMjgLDmLQ9fI0DcXold8/UWwGVaRC7
BTig63paVPeHFdCcs4lGbQ4snte6sIzfGpgXjBw8NDgQWF7mce+QNTA+yt6K
3swB2x1VW2trrYHo7bgaJMkB5XX1r0Tf2ADd3jSU/wf+PTD/5XMOsgO6n1/E
z9hFuLg6wyCw3w4Ym+PlnkQtwl4t+1fapB1eX6lW7uGLUBTUc6dpvz2wyM8R
yH8Rbo2w3Ceq7IH6srp5zdFF8On4+W9fpQMwBMV1/dcugtDzheWfy5yA6KMm
yBUuwNfUE5Sj3U5AO+y0Xy93AfID+ic+cJyAsnyXnGvmApirvvnSpOsMhGn8
uqgrC3DjUWJWbZMz0NSWrNYLWICNmTKaJSwXYEXLZrNUFoBaL1dgxOcKzLOr
vsox5yHhxbHceGlXYHl76v27MQ8TD1OYDYquQGW0H6hImYfaaDLtkBE2fUet
SsQ8eB/4FnbgMs6X79GNsZqHgsonB7RXuwGtRqNjVmAedIq1PyuruAMzcmh7
lPscJHNSJGh73YHqVviSYTcHPQaDZjYm7kAXGD4fajaH77+JjbH+2JYpV/br
zEHl0h40mI+trcLeLzEH+23PP7mj6gEsyccOE1Vs0OXURIlt8wR6c9CFnGVs
SDNYVaUEnkCLu566gsKGwavH5/ebeQLxePqmz9QsRCtKnT4R4AlMT5b2RM8s
1Jp5+jUW4vaSkt52T2dB/76AVcx2L2CpPE12N56FwwYmW9g7vIEh1LqyImIG
FCfYub563kAv4rMSOzEDPHezN3Ufw15yysXCeQbKJ7jU6jBvYDHc4AZtBrbc
e7Yqpgo7vLxXkW8Glk2vXCpm5ANM3YMREDcNTfcH+pXovsC63VQvGjkFj45c
dsoI8gWmm+pigt8UxLD3dAtHY49VyP+ynYK9ptc7RrN9gerupumgOQVP5/Sb
i39jn7LaNv9nEi6b55dDmB9+n6AHk9aTYMYNTbe5fByoArUlA5ITIMEHNln3
jgOTvewDSf6DDiEBmd8Fx4H2WXoN+fsfOErfvHO+FefvC5JmvvkHfiovH2SL
+QNLPabMLegfXLKffTaZ5g+EEGU7s34cqkvDWq7cPAGUoZsz+U/G4GIlpHbl
nsDrM7+wLXwMDtUIWG4oOwEEtSMs03AMmppvfi7txPkx4jzq30fh69DLnl6Z
k0B5ln5KSnYUpiXYv7beOQm0NyfeNwT9BpWAMwJvmQFAWfhtZdY6DGVtsiJE
UQCu+wp987RhOKhRJVZGYBssjn44NgxOc0tkH7ECgKFdyTTq/AENrw+tPCgW
CBTz6Jr+zu/ANm5V3miO3VQ9k1/9Dfafo26l2gYCUVuvnHPmG8QUBKnK0wOB
dsF5fG7HNxAXl1KXCsSWc3qdfX8QtnTY6vCl4vye+AuvIgbAgT54ZKg1EBj+
q22rJfvg/tWd5qwv2HFH7acDemGkJsaypx+P1z28M7CxB0I2Kdl8+ovNJ7Vt
+dluSP51nF4rGgSUQ04bO2o6oTpk+tRDsyBgSBenrvrXDnw5+qeZNtixp2fu
qbTD4S83w+64YL+8l1Hk2QYd2nsirwfg9k1VSr7MVvjLPR8bcwV7UvR4h9A7
oCYI3vJoxbYUq7cOfAH5v2LLl3dirwzXzD78DHab8PaWsrAPtmlYKD4Bc1Hu
eqEJ7NS821nPrgIjfTLvqdQpoFDm+DOz85DIbGCL9Rrsldm3DTKeo1u2Y+Pk
JmzFNXq6YS9RkdxPTctd2J7UXaXVBBrI6kMzdtgF520avd+jk7yOg5lu2MY7
9P12taB5jy4+o+OngKF69UZu0gckofzJ6L9I7PfksbDYj0i34N1HyMT5pTmR
7D9dqEXUYGYkF8cf9ar9zepG9kG1q9OKcDxv+eERt150SgM5Db3G8RukYVss
C90vLxmOH8J+E3zlVtwQUpNXF1YfxfZaGAy9+x2VnytU6Z4+BTT9qbhVVT9Q
O+1JkKpAMDDGgBsv/xM531e63iEaDETYi+98zr/QL97s0qjV2KZhrsz834i3
IXOhbTM2Z57WdnoMpSqvWRuhHgw0equL7ORfJJ94m7ZRB1vhjsa51+NI40h6
bKhJMLDoSkWaQROIKJB4tM4Kj6clsuDhMIlMxFIb3zrh/DLN7TVHp5DHx0RR
uYBgYCr8zCgNnUHjGoLqtWE43+1AnkbOLIq8EXvsBAPnZ4QaTI6ykSCbJ2xl
As53OPl6s+U8um7HyEBXg4HKcZI82LmAqBWcCp/beHwFYSnPOA7Kl4/oE3+A
80/RYjR9SbT7PJtSkRcMYtXLWffqKERt/+kNHiX4/f40hGdTeAjzA5OHllcF
Q6DYnC7vaV6i536gT2kd7u+RHdVx71LCh28s0aUlGMyXfXqXdUmAmPI8/lTw
SzCk7po8TVYLE4yGkdZn/cFwJimjTERejNh7Ut42cCAY/v//gf8BnFxdMg==

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.015, 0.01}, {-4.83428523317681, 1.9999999733000706`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5601608350897236`*^9, 3.5601608417509356`*^9}, {
   3.5602493471959867`*^9, 3.560249358771207*^9}, {3.5605899248239717`*^9, 
   3.5605899343867884`*^9}, 3.560669824000107*^9, 3.5643912364424977`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik2", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik2max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.01"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601543948836117`*^9, 
  3.56015439929842*^9}, {3.560160164101345*^9, 3.5601601644133453`*^9}, {
  3.560160882872607*^9, 3.5601608994710364`*^9}, {3.5606690427663345`*^9, 
  3.5606690455431395`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.010009430309582772`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, 3.5601598606496115`*^9, 3.560160171604958*^9, {
   3.5601608845730104`*^9, 3.560160900422638*^9}, 3.560249415602107*^9, 
   3.560589948130412*^9, 3.56066982593451*^9, 3.5643912390635014`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik2", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik2max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.5601544021376247`*^9, 
  3.5601544051172295`*^9}, {3.5601601686097527`*^9, 3.5601601792645717`*^9}, {
  3.560160906803049*^9, 3.5601609175982685`*^9}, {3.560669048460345*^9, 
  3.560669051829951*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.004389443528531281`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, 3.560160179685772*^9, {3.560160907973051*^9, 
   3.5601609190022707`*^9}, 3.5602494188001127`*^9, 3.560589958676031*^9, 
   3.560669826901712*^9, 3.5643912424435062`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 3", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.5836472214323673`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD3", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"3", ",", 
      RowBox[{"pl", "[", "3", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.560140818023765*^9, 3.5601408259953794`*^9}, 
   3.560250615447014*^9, 3.56057415896728*^9, 3.5605769626666045`*^9, {
   3.5836475560399427`*^9, 3.583647556777536*^9}}],

Cell[BoxData[
 RowBox[{"LLLD3", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.5601408456046133`*^9, 3.5601408461350145`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik3", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"6.55400227078692`*^51", "-", 
      RowBox[{"6.269682223626508`*^53", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.013814582152699727`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.5364490925858559`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0018812129193949531`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.5355817835258697`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009766182498687517`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.28319311902212246`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005816666169557781`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.20250404016833312`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0026043153329833374`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.16041005134594666`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005580675713535724`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.13736056589663936`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.006311478485546353`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04263763455817622`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00823236324201698`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.030772411074424667`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0017449998508673346`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.026398167783548476`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004650563094613103`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.02155543488012345`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002368214083319953`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.017191489870642854`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0060659518625388285`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.005486203621886461`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0019780277812626616`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.005590231755154909`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"10.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.010084644971470803`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.2535669412132912`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.010494362772712464`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.3014914914629976`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.03255394166229172`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.3051772309814501`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"4.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.019328902861985707`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.3486773718477757`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.013688299268755387`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.5100204727090308`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0424616630377718`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.6432369378979899`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.024230840320467604`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.945473409796953`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.03288471186349174`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.0604845227275168`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.07430791031610065`", "\[VeryThinSpace]", "+", 
      RowBox[{"2.3185352770110734`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.5643905990405765`*^9, 3.564390601180579*^9}, 
   3.5643912688065434`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik3max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik3", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.02"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.001"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.5601602541291027`*^9, 3.5601602544099035`*^9}, {
  3.5606690746215906`*^9, 3.5606690779131966`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "38.00369249388726`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", 
     RowBox[{"-", "0.0009337738720619948`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, {3.560160247405491*^9, 
   3.5601602552211046`*^9}, 3.560160996596807*^9, 3.5601693390234594`*^9, 
   3.560249526034701*^9, 3.5602497622347155`*^9, 3.560589970079651*^9, 
   3.56066983153492*^9, 3.564391271457547*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik3", "-", 
     RowBox[{"Lik3max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.01"}], ",", "0.01"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.560160268371928*^9, 
  3.5601602924271703`*^9}, {3.5601610001068134`*^9, 3.560161045019292*^9}, {
  3.560249553303549*^9, 3.56024955403675*^9}, {3.560249624065273*^9, 
  3.560249626358477*^9}, {3.560669080440401*^9, 3.5606690858692102`*^9}, {
  3.5643912773575554`*^9, 3.5643912796175585`*^9}, {3.583647451804165*^9, 
  3.58364745268652*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk8VdsXAPATlV6kQShJN5GQSoYQ1pVZyJCZui4yhlcqCd0iU5KGV16T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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.01, 0.01}, {-1.5692561106756435`, 1.9999999510905582`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601602756571407`*^9, 3.560160294501974*^9}, {
   3.56016100403802*^9, 3.560161045487293*^9}, {3.5602495499963427`*^9, 
   3.5602495546607513`*^9}, 3.5602496283864803`*^9, 3.5602497638415184`*^9, 
   3.560589972357255*^9, 3.5606698347017255`*^9, {3.56439127358755*^9, 
   3.564391282108562*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik3", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik3max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.008"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.5601610583105154`*^9, 3.5601610633961244`*^9}, {
  3.5602495630067654`*^9, 3.5602496392440996`*^9}, {3.560249771641532*^9, 
  3.5602497724215336`*^9}, {3.560250565386526*^9, 3.5602505662133274`*^9}, {
  3.560669089816017*^9, 3.5606690935600243`*^9}, {3.564391291069575*^9, 
  3.564391292859577*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.009716046035621245`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.560161053443307*^9, 3.560161063848525*^9}, {
   3.5602495651595697`*^9, 3.5602495738643847`*^9}, 3.5602496061564417`*^9, 
   3.560249640554502*^9, {3.560249756868306*^9, 3.560249777163942*^9}, 
   3.560250571517337*^9, 3.560589976881263*^9, 3.5606698369793296`*^9, 
   3.564391293949579*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik3", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik3max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.003"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
  3.5601545558290944`*^9}, {3.560161067062131*^9, 3.560161084814962*^9}, {
  3.560250518477244*^9, 3.560250519226045*^9}, {3.5602505689433327`*^9, 
  3.560250569114933*^9}, {3.560669100392836*^9, 3.560669103044841*^9}, {
  3.5643912995005865`*^9, 3.564391302780591*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.0031991460750730983`"}], "}"}]], "Output",
 CellChangeTimes->{3.560250579301751*^9, 3.560589980531669*^9, 
  3.560669838523732*^9, 3.564391304030593*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 4", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.583647223678446*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD4", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"4", ",", 
      RowBox[{"pl", "[", "4", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.560140850300222*^9, 3.560140870096657*^9}, 
   3.560250388061015*^9, 3.560574644424533*^9, 3.560577032351927*^9, {
   3.583647559600334*^9, 3.583647560306045*^9}}],

Cell[BoxData[
 RowBox[{"LLLD4", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.5601408834658804`*^9, 3.5601408839806814`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik4", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"6.640987538883745`*^51", "-", 
      RowBox[{"2.8756005714930885`*^53", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.023311746628990604`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.2238167507771513`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0056964609620493625`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.2149461629864612`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.017369536703953796`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.1333719848015975`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.01092599889442255`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.1121833000855477`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.006878876054456244`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.09612699657373085`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00713496120499112`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.07542886260939119`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009264924942291135`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.07132941236321921`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0013290614009297194`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.06785478715984948`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0012813592650457715`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.024463019825390023`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0013243635023542483`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.02427235839744923`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001088416796301896`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0178152352050649`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002624902115548573`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.007242483232175072`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.3037548856240393`*^-7", "+", 
      RowBox[{"0.0000721628727294895`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.9166120968211513`*^-6", "+", 
      RowBox[{"0.00045381114726226486`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.4602202077884207`*^-6", "+", 
      RowBox[{"0.0010752380779477152`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.005462999447211275`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.008316628990872689`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.011655873314495302`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.030061449464763988`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009264924942291135`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.06060025332024725`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0068971855765989866`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.20078733195525694`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"7.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.01128584559022561`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.2862907801302426`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.010964756557670187`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.41117448419882097`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.04969412655050956`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.9120298132832163`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.023394440104826657`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.9155346153900292`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.029431714970588378`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.9251401624304727`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.03139780119331996`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.0167115198402843`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.5643906221026087`*^9, 3.5643906256736135`*^9}, 
   3.5643913350236363`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik4max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik4", ",", 
      RowBox[{
       RowBox[{"-", "0.05"}], "<", "k2", "<", "0.02"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
   3.5601548251011677`*^9, 3.560154876596858*^9}, {3.5601549483257837`*^9, 
   3.56015499754387*^9}, 3.560157782569962*^9, {3.5601593384074945`*^9, 
   3.560159390199586*^9}, {3.5601611847487373`*^9, 3.560161190567548*^9}, {
   3.560669124292078*^9, 3.5606691278332844`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "66.53595506659552`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.012760176520450675`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, {
   3.5601548338059826`*^9, 3.5601548772208586`*^9}, {3.560154950759388*^9, 
   3.560154999244273*^9}, 3.5601593144614525`*^9, {3.560159344897106*^9, 
   3.5601593926019897`*^9}, 3.5601611512398787`*^9, {3.56016118641794*^9, 
   3.5601611912071486`*^9}, 3.560249706558218*^9, 3.5605899886124835`*^9, 
   3.5605928686115417`*^9, 3.560669846354946*^9, 3.5643913390536423`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik4", "-", 
     RowBox[{"Lik4max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.005"}], ",", "0.02"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.560157713929841*^9, 
  3.5601577180794487`*^9}, {3.5601581092189355`*^9, 3.5601581096557364`*^9}, {
  3.560161167885108*^9, 3.560161168119108*^9}, {3.560161199646764*^9, 
  3.5601612049039726`*^9}, {3.560161278083701*^9, 3.5601612942297297`*^9}, {
  3.560669132700493*^9, 3.560669135134097*^9}, {3.5643913485456553`*^9, 
  3.5643913624866753`*^9}, {3.583647456828485*^9, 3.583647457606998*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk8VO8XB/BBlpJkT1EoVJYoqajOCEWWbEmLSCiUbGkhJgkhe7ITQons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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.005, 0.02}, {-6.889817115738706, 1.9999998550308646`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.560161170271912*^9, 3.5601612054967737`*^9}, {3.5601612838401117`*^9, 
   3.560161297755336*^9}, 3.56024971348463*^9, 3.560589993089691*^9, 
   3.560592877144757*^9, 3.560669847493748*^9, {3.564391341134645*^9, 
   3.5643913640966773`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik4", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik4max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.003"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601577884979725`*^9, 
  3.5601577916491776`*^9}, {3.560249729630658*^9, 3.560249730941061*^9}, {
  3.5606691404225063`*^9, 3.560669144322513*^9}, {3.5643913712676873`*^9, 
  3.564391376028694*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.004130598305530508`"}], "}"}]], "Output",
 CellChangeTimes->{3.5601533751098204`*^9, 3.560161313214963*^9, 
  3.5602497325946636`*^9, 3.5605899967088976`*^9, 3.560669849521752*^9, 
  3.5643913772586956`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik4", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik4max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.018"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.5601577939267817`*^9, 
  3.560157796282386*^9}, {3.560161331810196*^9, 3.5601613328085976`*^9}, {
  3.5606691503129234`*^9, 3.5606691531365285`*^9}, {3.5606698504733534`*^9, 
  3.560669852267357*^9}, {3.564391382918704*^9, 3.5643914098127413`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.018738814603826953`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, {3.5601613238073816`*^9, 3.5601613335885987`*^9}, 
   3.560249737539872*^9, 3.5605899992829022`*^9, 3.5606698533437586`*^9, {
   3.5643913841397057`*^9, 3.5643914106227427`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 5", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.583647225198308*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD5", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"5", ",", 
      RowBox[{"pl", "[", "5", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601408876622877`*^9, 3.5601409038395157`*^9}, 
   3.5602501032825146`*^9, 3.5605747842007785`*^9, {3.5605770443951483`*^9, 
   3.560577046563552*^9}, {3.583647563336602*^9, 3.5836475640101137`*^9}}],

Cell[BoxData[
 RowBox[{"LLLD5", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.5601408931378975`*^9, 3.5601408935122976`*^9}, 
   3.56058211850786*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik5", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"4.3669654838298525`*^50", "-", 
      RowBox[{"2.260763088005438`*^51", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00021455088862979918`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0015882096600634906`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00031342475106450494`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0014132085706195193`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00035715843725955213`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.001413036463196018`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002183396251389441`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0011142417737762043`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00010314434024811462`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0007661154103615857`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00008840943449838394`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0006257738804015085`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0000650791670613104`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0006156663948391631`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003249506837061026`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005996767504740886`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0001562185274462878`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005749982208447509`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00009126135174026729`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005692009582979681`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00009286580813757734`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005134449184948434`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000048346977466948413`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0002985919505564988`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007961087550537443`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.000232746086059852`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00003052900786026439`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00018783789425210536`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00041210335555723235`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00015839980383260165`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000038561517822915744`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00015106064197124768`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00001094071231915357`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00010436554835705676`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00014469214314375713`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00008463571021323534`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.209956858704109`*^-6", "-", 
      RowBox[{"0.0000460188965418654`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"7.487718757453107`*^-7", "-", 
      RowBox[{"0.00003201323069569306`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3.4936159609451483`*^-6", "-", 
      RowBox[{"0.00002556227231593433`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000012173716727249399`", "\[VeryThinSpace]", "-", 
      RowBox[{"1.1765256627489692`*^-6", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.663298648951572`*^-6", "+", 
      RowBox[{"5.685301402491372`*^-6", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000011998658557562286`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0001895882229736362`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00016247534185305127`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0002767845115049549`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00001999022762919358`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00038297718520641444`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000030959975257784604`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00044798111577482394`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00006457466163108303`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0005186762544526287`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00017596643643273395`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.001108115281192697`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00034381446749371546`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0013849686761320565`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00016582356015622062`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0014207092598307143`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00042317863323783307`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002271269432069838`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00026653692984941036`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.004315293633702283`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00010298017744181765`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0049340328057548575`", " ", "k2"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5643906370946302`*^9, 3.564390639294633*^9}, 
   3.5643914554168053`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik5max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik5", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.03"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560157839213661*^9, 3.5601578432852683`*^9}, {
  3.5601680124127293`*^9, 3.5601680484487925`*^9}, {3.5606691864737873`*^9, 
  3.560669195022602*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "212.49810053117696`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", 
     RowBox[{"-", "0.000599071246505054`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.5601613697962627`*^9, {
   3.5601680145655336`*^9, 3.5601680492131944`*^9}, 3.5602498635880938`*^9, {
   3.5605900055073133`*^9, 3.5605900258965487`*^9}, 3.5606698589285684`*^9, 
   3.564391459226811*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik5", "-", 
     RowBox[{"Lik5max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.03"}], ",", "0.1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.560157845999673*^9, 
  3.5601578482304773`*^9}, {3.5601580863336954`*^9, 3.5601580867704964`*^9}, {
  3.5601613999979153`*^9, 3.560161437469181*^9}, {3.560249873852912*^9, 
  3.560249906316569*^9}, {3.560669197799407*^9, 3.5606692006854124`*^9}, {
  3.583647460869032*^9, 3.58364746169559*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk4VV8XB/CjEorSRFKGDOlmSFRIloSUlLFEZGhAk0IRccgcRYRmQqWB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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.03, 0.1}, {-1.611866913124092, 1.99999994108461}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601614034923215`*^9, 
   3.5601614380463824`*^9}, {3.5602498760525155`*^9, 3.560249909998175*^9}, 
   3.560590031044558*^9, 3.560669860426171*^9, 3.564391460886813*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik5", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik5max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.01"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.5601578518808837`*^9, 3.5601578606324987`*^9}, {
  3.560158081825288*^9, 3.5601580822308884`*^9}, {3.5601614539584103`*^9, 
  3.5601614542080107`*^9}, {3.560249916472186*^9, 3.5602499222909966`*^9}, {
  3.56066920524062*^9, 3.5606692080798254`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.018870796220975854`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, 3.560161454863212*^9, {3.560249919108591*^9, 
   3.5602499231801987`*^9}, 3.560590035084965*^9, 3.560669862235774*^9, 
   3.564391467157822*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik5", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik5max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.02"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
  3.5601545558290944`*^9}, {3.5601578629413033`*^9, 3.5601578660145082`*^9}, {
  3.5601580790172825`*^9, 3.560158079282483*^9}, {3.5601614641452284`*^9, 
  3.560161503145297*^9}, {3.56024992971661*^9, 3.56024993580062*^9}, {
  3.560590042073777*^9, 3.5605900434309797`*^9}, {3.5606692111686306`*^9, 
  3.5606692133526344`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.020522870878063072`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, {3.56016146490963*^9, 3.5601614744724464`*^9}, 
   3.560161506265302*^9, 3.5602499368146224`*^9, {3.560590037300169*^9, 
   3.5605900439769807`*^9}, 3.5606698635149765`*^9, 3.5643914695378256`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 6", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.58364722635023*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD6", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"6", ",", 
      RowBox[{"pl", "[", "6", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601410751590166`*^9, 3.5601410814614277`*^9}, 
   3.560250193871874*^9, {3.560574959560686*^9, 3.5605749719003077`*^9}, 
   3.560575020790794*^9, 3.560577196495415*^9, {3.583647567120986*^9, 
   3.5836475678109293`*^9}}],

Cell[BoxData[
 RowBox[{"LLLD6", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.560141087763839*^9, 3.56014108826304*^9}, {
  3.5605749633358927`*^9, 3.5605749644278946`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik6", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"2.4487034412409348`*^39", "-", 
      RowBox[{"1.59157513172815`*^40", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009186906859412706`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.004886507071213334`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000537111046849654`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.003680023366926606`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007988614660358873`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.003191670256257539`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0019855530553722113`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.002781258390260437`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0004192424973756337`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0025054181597882223`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002938280750837774`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.002314508219682454`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0006800021166224566`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0021108229401361747`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00019969922919752154`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0018477506149545062`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00009316649834891188`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0010035111500679111`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00010801739062818257`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0008060255676779743`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00010996313737071406`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0002044801251717858`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"5.7186723587330345`*^-8", "+", 
      RowBox[{"0.000010514335062453981`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"4.732938737277452`*^-7", "+", 
      RowBox[{"0.000028622558522418213`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.3808833184295247`*^-6", "+", 
      RowBox[{"0.00010293383880692439`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"8.845555988584798`*^-6", "+", 
      RowBox[{"0.00019766448127178237`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"5.84086183897814`*^-6", "+", 
      RowBox[{"0.00021969594916921412`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00009228982306638375`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00026553404014940615`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00003600627605887796`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00034940979461947066`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00011592929791684187`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0013525922317387377`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00034257299091998135`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.008258920628467843`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0021761003117621485`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.011947626674459935`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0017265678742367056`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.015406916731518252`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0014946951636346066`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01806902091295654`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004708289765449012`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.06071193311290462`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0023020904989822745`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.06881490826374305`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004094165013433923`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.07135828061518976`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0033572153110158166`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.08119722617265483`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003597016404659804`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.1775118320948194`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.564390654375654*^9, 3.564390656896658*^9}, 
   3.5643915007318697`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik6max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik6", ",", 
      RowBox[{
       RowBox[{"-", "0.2"}], "<", "k2", "<", "0.1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560157928258618*^9, 3.5601579327826257`*^9}, {
  3.5602503170496902`*^9, 3.560250319077694*^9}, {3.5605749790763206`*^9, 
  3.5605749830699277`*^9}, {3.560590113443903*^9, 3.5605901240207214`*^9}, {
  3.560669231448666*^9, 3.560669234412671*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "138.46650140565873`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.06522919076346666`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.5601630156147532`*^9, 
   3.5602502045734925`*^9, 3.5602503196080947`*^9, 3.560250739514032*^9, 
   3.5605900752082357`*^9, {3.5605901164703083`*^9, 3.5605901247071223`*^9}, 
   3.560669869115386*^9, 3.564391506532878*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik6", "-", 
     RowBox[{"Lik6max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0", ",", "0.1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.5601579355282307`*^9, 
  3.5601579414406404`*^9}, {3.5601580367100086`*^9, 3.5601580369908085`*^9}, {
  3.5601630204039617`*^9, 3.5601630522124176`*^9}, {3.560250224198327*^9, 
  3.560250238753153*^9}, {3.5605749859559326`*^9, 3.5605749903551407`*^9}, {
  3.5605901345819397`*^9, 3.56059014625076*^9}, {3.560669238219078*^9, 
  3.560669240527882*^9}, {3.583647465309444*^9, 3.583647466089328*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VG8bwPFBJCmyRJItW0JpteWWElH9pJKiSIjsW0lehkpZKiREKpTI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.1}, {-9.657839432600156, 1.9999999307983671`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601630334143844`*^9, 3.560163052930019*^9}, {
   3.5602502193623185`*^9, 3.5602502393615537`*^9}, 3.5602507452548423`*^9, 
   3.560590099825079*^9, {3.560590136344743*^9, 3.560590147342762*^9}, 
   3.5606698703165884`*^9, 3.564391509662882*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik6", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik6max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.0001"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
   3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
   3.5601545450806756`*^9}, {3.560157961439876*^9, 3.5601579642790813`*^9}, {
   3.5601580254779882`*^9, 3.5601580257275887`*^9}, {3.5601630571732264`*^9, 
   3.5601630917584867`*^9}, 3.560250246521966*^9, {3.560574993459546*^9, 
   3.5605749978899536`*^9}, {3.5606692475634947`*^9, 3.5606692505274997`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.03239470934359308`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.560163072570453*^9, 3.5601630926320887`*^9}, 
   3.5602502471303673`*^9, 3.5605901514923697`*^9, 3.560669872406992*^9, 
   3.564391512413886*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik6", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik6max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.08"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
  3.5601545558290944`*^9}, {3.5601579666502852`*^9, 3.56015796953629*^9}, {
  3.560158030298397*^9, 3.560158030485597*^9}, {3.560163061650434*^9, 
  3.560163062680036*^9}, {3.5601631160321293`*^9, 3.560163116812131*^9}, {
  3.560575003256363*^9, 3.5605750089971733`*^9}, {3.5605901594795837`*^9, 
  3.560590160165985*^9}, {3.5606692528207035`*^9, 3.5606692555195084`*^9}, {
  3.5643915180338936`*^9, 3.5643915200038967`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.08883113086161232`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, 3.5601631175453324`*^9, 3.560250252668377*^9, 
   3.5605901605559855`*^9, 3.560669873623794*^9, {3.56439151538389*^9, 
   3.564391520964898*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 7", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.5836472284391117`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD7", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"7", ",", 
      RowBox[{"pl", "[", "7", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601410751590166`*^9, 3.5601410814614277`*^9}, 
   3.560250193871874*^9, 3.5605755580557375`*^9, 3.5605772415950947`*^9, {
   3.583647570897402*^9, 3.58364757156327*^9}}],

Cell[BoxData[
 RowBox[{"LLLD7", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.560141087763839*^9, 3.56014108826304*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik7", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"8.190985204205286`*^56", "-", 
      RowBox[{"6.419275564778786`*^57", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005250388835636238`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0030948447657750877`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00038885122066949045`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00293505798667776`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002072445148733081`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.002893714054312062`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00016693394240111507`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0023140291988717164`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.0005730263084054604`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.0021858768147981714`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00010001382440586223`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0007690037210705026`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00005241276312404258`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005908942165623322`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003856174069465759`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005183437034113734`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00006203959716723407`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00010370589945913884`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3.8167639920361635`*^-6", "-", 
      RowBox[{"0.00004511283658601872`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.2276921925615103`*^-6", "+", 
      RowBox[{"0.00002765654536917924`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000019127207212252397`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00020814714934445718`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.0280765196326955`*^-6", "+", 
      RowBox[{"0.00021579941060538015`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000015586773309224025`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00021813483226630252`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"9.734877770539283`*^-6", "+", 
      RowBox[{"0.0003085401798902958`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000026022595392217997`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00036740563467501486`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000405728972388234`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00047741484111956615`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.097364755490541`*^-6", "+", 
      RowBox[{"0.0004803617933445846`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00012663051385650745`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0005205939318428161`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00008476906511501649`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0018747972371693984`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00009990792271087046`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0019499215820332765`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007131954592761926`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.001960385372791878`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.000672655927906809`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.0027061777462010625`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0015967441320916872`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.004121282778138611`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0014039144555933777`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.006267185577660267`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005665146458099438`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00958157417377874`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0008707489834277518`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.011151450107407083`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001902077649513609`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01874352051577408`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00032691959601015145`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01990902063939185`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001348973490905046`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.022028819030376994`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0012263395371864055`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.029879275639534346`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0014608433358333358`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.02995992158503911`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0021670098935530043`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.04193630786103343`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002507284174358848`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.054800717499491995`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0021058716833900664`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0619956777171975`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.564390692549708*^9, 3.564390695389712*^9}, 
   3.564391546657934*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik7max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik7", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560157928258618*^9, 3.5601579327826257`*^9}, {
  3.5602503170496902`*^9, 3.560250319077694*^9}, {3.560669274613942*^9, 
  3.560669280229952*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "176.46950336888426`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.05195161386459513`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.5601630156147532`*^9, 
   3.5602502045734925`*^9, 3.5602503196080947`*^9, 3.560250739514032*^9, 
   3.560590169962802*^9, 3.5606698857762156`*^9, 3.564391552388942*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik7", "-", 
     RowBox[{"Lik7max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0", ",", "0.1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.5601579355282307`*^9, 
  3.5601579414406404`*^9}, {3.5601580367100086`*^9, 3.5601580369908085`*^9}, {
  3.5601630204039617`*^9, 3.5601630522124176`*^9}, {3.560250224198327*^9, 
  3.560250238753153*^9}, {3.560669287187564*^9, 3.560669290057969*^9}, {
  3.5643915572989492`*^9, 3.5643915718509693`*^9}, {3.583647472446294*^9, 
  3.583647473136684*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk8VG0UB/DJlpCtkTVJKlGStwWpQyUiUkq28HqRrSyJFmVCsrTYEknZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.1}, {-11.813770508913223`, 1.9999993232542295`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601630334143844`*^9, 3.560163052930019*^9}, {
   3.5602502193623185`*^9, 3.5602502393615537`*^9}, 3.5602507452548423`*^9, 
   3.560590174970411*^9, 3.560669887242618*^9, {3.5643915539289446`*^9, 
   3.5643915731109715`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik7", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik7max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.025"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
   3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
   3.5601545450806756`*^9}, {3.560157961439876*^9, 3.5601579642790813`*^9}, {
   3.5601580254779882`*^9, 3.5601580257275887`*^9}, {3.5601630571732264`*^9, 
   3.5601630917584867`*^9}, 3.560250246521966*^9, {3.560669295533579*^9, 
   3.5606692984351835`*^9}, {3.5643915810919824`*^9, 3.5643915859629893`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.028458163848016173`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.560163072570453*^9, 3.5601630926320887`*^9}, 
   3.5602502471303673`*^9, 3.56059018018082*^9, 3.5606698892862215`*^9, 
   3.5643915868229904`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik7", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik7max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.06"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
   3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
   3.5601545558290944`*^9}, {3.5601579666502852`*^9, 3.56015796953629*^9}, {
   3.560158030298397*^9, 3.560158030485597*^9}, {3.560163061650434*^9, 
   3.560163062680036*^9}, {3.5601631160321293`*^9, 3.560163116812131*^9}, {
   3.5605901885112343`*^9, 3.5605902285877047`*^9}, {3.560669303473993*^9, 
   3.5606693072179995`*^9}, 3.5643915919329977`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.0672872793997524`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, 3.5601631175453324`*^9, 3.560250252668377*^9, {
   3.560590184814028*^9, 3.560590229757707*^9}, 3.560669893732229*^9, 
   3.5643915933139997`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 8", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.583647229695245*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD8", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"8", ",", 
      RowBox[{"pl", "[", "8", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601411006962614`*^9, 3.5601411074198737`*^9}, 
   3.560250269875207*^9, {3.583647574585844*^9, 3.583647575235735*^9}}],

Cell[BoxData[
 RowBox[{"LLLD8", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5601411137534847`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik8", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1.2392786073745507`*^49", "-", 
      RowBox[{"4.983407501769156`*^49", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00014353758178677525`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0012028470132572056`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0004042450206114092`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0008073691181978288`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007460425673202012`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0005776791477002614`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00004205840041362842`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0002493171492940964`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00016771675042020714`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00022999426949038408`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00002717860101865318`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0002076076295924303`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00024088939389608447`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00017535252276621967`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00003545162750857721`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00016183714294243202`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00020448348549730966`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00011211449938086486`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"7.289644795515754`*^-6", "-", 
      RowBox[{"0.00009583623781868022`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.6509941576779173`*^-6", "-", 
      RowBox[{"0.000028104766319294395`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3.219035705699337`*^-6", "+", 
      RowBox[{"4.341522866416096`*^-6", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00008639293583352406`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.000016065077177180556`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.3452974427238033`*^-6", "+", 
      RowBox[{"0.00011195896281185192`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.091650443259863`*^-6", "+", 
      RowBox[{"0.00014738320772417462`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"9.477094225857586`*^-6", "+", 
      RowBox[{"0.0002253444327539667`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.684992357925433`*^-6", "+", 
      RowBox[{"0.00032009928284417713`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.592998938210308`*^-6", "+", 
      RowBox[{"0.0003949845398457422`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000024350557399144675`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.000489810301389311`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000016613061648005824`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0005061042991546717`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00003207322517166563`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0006343199309093283`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007885562414042657`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0006837595300233559`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000023002700743392682`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.000741106340227144`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000018917587260222217`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.000932247795806157`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00008590607211612491`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0011038750612097133`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00004926998821901012`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.001639963380347036`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000040796460096767164`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0023119033122099867`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00004079646009676715`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002664322430807691`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00006719416957114591`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0031371628914902885`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000035900884885155105`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0033576680077787207`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00005293548842760117`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.003599716886510179`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.00009907711737786311`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.005294449775910258`", " ", "k2"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5643907142727385`*^9, 3.564390717802743*^9}, 
   3.564391637160063*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik8max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik8", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560158349287757*^9, 3.5601583528601637`*^9}, {
  3.5602503058644705`*^9, 3.560250307143673*^9}, {3.5606693308052406`*^9, 
  3.560669333862846*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "208.9952360314737`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.06624033071273898`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.5601631502585897`*^9, {
   3.560250300435661*^9, 3.5602503077052736`*^9}, 3.5602507703708863`*^9, 
   3.560590242456129*^9, 3.560590283375001*^9, 3.5606699029050455`*^9, 
   3.5643916404710674`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik8", "-", 
     RowBox[{"Lik8max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.02", ",", "0.1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
   3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
   3.5601545298862486`*^9}, {3.5601545843615446`*^9, 
   3.5601546139235964`*^9}, {3.5601547380218143`*^9, 3.560154742826623*^9}, {
   3.5601583545605664`*^9, 3.5601583584917736`*^9}, {3.560163157871403*^9, 
   3.5601631763574357`*^9}, 3.560250332556117*^9, {3.5606693403836575`*^9, 
   3.5606693431292624`*^9}, {3.58364747711873*^9, 3.583647477793214*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc8lW0YB/CDikpUkpFUsksvCWV0SYqQWV4ZWRHC+ypJGlYlmzjK1rAy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.02, 0},
  PlotRange->{{0.02, 0.1}, {-6.440200599132055, 1.9999992906454622`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.560163160242607*^9, 3.5601631775898376`*^9}, {
   3.5602503275017085`*^9, 3.5602503334453187`*^9}, 3.5605902860426064`*^9, 
   3.5606699057598505`*^9, 3.56439164229107*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik8", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik8max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.01"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
   3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
   3.5601545450806756`*^9}, {3.560158363202982*^9, 3.560158366806588*^9}, {
   3.560163182706647*^9, 3.5601631950306683`*^9}, 3.560250338203327*^9, {
   3.5606693466236687`*^9, 3.5606693492444735`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.045165484411524404`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.5601631899918594`*^9, 3.560163197370672*^9}, 
   3.5602503391237288`*^9, 3.5605902905198135`*^9, 3.5606699081154547`*^9, 
   3.5643916442310724`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik8", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik8max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.075"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
  3.5601545558290944`*^9}, {3.5601583676177893`*^9, 3.5601583695365925`*^9}, {
  3.5601631870746546`*^9, 3.560163187277455*^9}, {3.5602503422749343`*^9, 
  3.560250370978985*^9}, {3.560669352068078*^9, 3.5606693546108823`*^9}, {
  3.564391648682079*^9, 3.56439164976208*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.07541985803342582`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, {3.5602503442405376`*^9, 3.5602503717589865`*^9}, 
   3.5605902940454197`*^9, 3.5606699106582594`*^9, {3.564391645411074*^9, 
   3.564391650942082*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 9", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, 3.583647230751075*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD9", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"9", ",", 
      RowBox[{"pl", "[", "9", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.560141119993496*^9, 3.5601411307107143`*^9}, 
   3.560250803255744*^9, {3.583647578522128*^9, 3.583647579252255*^9}}],

Cell[BoxData[
 RowBox[{"LLLD9", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.5601411461703415`*^9, 3.560141147168743*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik9", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"2.3140803529380704`*^29", "-", 
      RowBox[{"6.771614345402205`*^29", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000423474537572866`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0003914726822368446`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000047590057537870434`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00009859765141146347`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.8517143214470046`*^-6", "-", 
      RowBox[{"0.000023247071351718865`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.6311282882541836`*^-9", "+", 
      RowBox[{"5.599372113715638`*^-7", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2.745609607378083`*^-9", "+", 
      RowBox[{"8.786645268976079`*^-7", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.0570640304311075`*^-7", "+", 
      RowBox[{"0.000015213865303038462`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.688918093733913`*^-7", "+", 
      RowBox[{"0.000029288113344793754`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002946622362832869`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00039761737422431865`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.000025483838636751335`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.000936029971527558`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00005642849983852085`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0014431309676879187`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0001555670590737692`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0014758021107182022`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00015556705907376922`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0015536230003004403`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000053009614945109815`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0016289761595276817`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00011424363792533704`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002727127338691406`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0004492824717651712`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002811224660666093`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00024266301811564804`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0029053261658483903`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00017871704234008646`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00336090584313759`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005455572871434218`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00591909397848641`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00027404872668994546`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0066149796233765604`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00041634635071471655`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.009664778057659234`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007002188625656597`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.010108418606555794`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007556114297868786`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.012891198871524994`", " ", "k2"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.564390727893758*^9, 3.5643907300837603`*^9}, 
   3.5643916986771493`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik9max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik9", ",", 
      RowBox[{"0.02", "<", "k2", "<", "0.13"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.06"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.5601583865094223`*^9, 3.5601583886310263`*^9}, {
  3.5601640126125045`*^9, 3.560164015264509*^9}, {3.560164180156799*^9, 
  3.5601641803283987`*^9}, {3.5601642598105383`*^9, 3.560164276112567*^9}, {
  3.560250872363866*^9, 3.5602509105995326`*^9}, {3.5606695157279654`*^9, 
  3.5606695183643703`*^9}, {3.56439170665816*^9, 3.56439172068918*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "145.7155870587713`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.11386761569342088`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.560163411371848*^9, 
   3.560163598977778*^9, 3.560164016418911*^9, 3.5601641822472024`*^9, {
   3.5601642643033466`*^9, 3.560164276783368*^9}, 3.560164436246848*^9, 
   3.5602508176701694`*^9, {3.560250875405871*^9, 3.5602509116759343`*^9}, 
   3.5605903037018366`*^9, 3.560669919472275*^9, {3.5643917013371525`*^9, 
   3.5643917214301815`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik9", "-", 
     RowBox[{"Lik9max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.05", ",", "0.2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.56015839078383*^9, 
  3.5601583942782364`*^9}, {3.5601634189222617`*^9, 3.5601635668573217`*^9}, {
  3.560163895674699*^9, 3.560163905783517*^9}, {3.560164027916131*^9, 
  3.5601640406145535`*^9}, {3.560164192995621*^9, 3.5601641939472227`*^9}, {
  3.560250836842603*^9, 3.5602508462026196`*^9}, {3.5606695209539747`*^9, 
  3.560669523247179*^9}, {3.564391727010189*^9, 3.5643917337911987`*^9}, {
  3.583647480911776*^9, 3.58364748158573*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Hk41GsbB/Bp6EQbshRZOihZsoRCnW4KqSQVJTtlSZJEC8VUOjSWhBIp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.06, 0},
  PlotRange->{{0.05, 0.2}, {-6.668890763984507, 1.9999993431061966`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.560163424959472*^9, 3.5601635698369265`*^9}, {
   3.560163897811903*^9, 3.5601639063451176`*^9}, {3.56016402139532*^9, 
   3.5601640412229548`*^9}, 3.560164195054825*^9, 3.560164437588451*^9, {
   3.5602508336289973`*^9, 3.5602508471542215`*^9}, 3.5602509179939456`*^9, 
   3.560590321891469*^9, 3.5606699214378777`*^9, {3.5643917292501917`*^9, 
   3.5643917345611997`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik9", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik9max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.08"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.5601583969926414`*^9, 3.560158424308289*^9}, {
  3.5601639140515313`*^9, 3.56016392459715*^9}, {3.560250947337597*^9, 
  3.5602509542640095`*^9}, {3.5606695260551834`*^9, 3.5606695283015876`*^9}, {
  3.564391738231205*^9, 3.564391739672207*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.08695334976964915`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.5601639155023336`*^9, 3.5601639253615513`*^9}, 
   3.5601640488357677`*^9, 3.5601644391484537`*^9, 3.5602509555588117`*^9, 
   3.5605903258226757`*^9, 3.5606699238402824`*^9, 3.5643917412422085`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik9", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik9max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.12"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
   3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
   3.5601545558290944`*^9}, {3.5601584038722534`*^9, 
   3.5601584258526917`*^9}, {3.5601639408523784`*^9, 3.560163985593257*^9}, {
   3.5601640552473793`*^9, 3.560164085168232*^9}, {3.560164120018693*^9, 
   3.5601641703599815`*^9}, 3.5601642063024445`*^9, {3.5601644111932044`*^9, 
   3.5601644174176154`*^9}, {3.5602509355595765`*^9, 3.560250937010379*^9}, {
   3.5606695313435926`*^9, 3.5606695334339967`*^9}, {3.564391744602214*^9, 
   3.5643917514632235`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.12219421591513384`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, {3.5601639464683886`*^9, 3.5601639859832573`*^9}, {
   3.5601640530477753`*^9, 3.5601640860106335`*^9}, {3.560164126679905*^9, 
   3.560164166225974*^9}, 3.560164207035646*^9, {3.5601644187592173`*^9, 
   3.5601644405836563`*^9}, {3.5602509280403633`*^9, 3.560250938242781*^9}, 
   3.560590329317082*^9, 3.560669926086686*^9, {3.5643917465522165`*^9, 
   3.564391752283224*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 10", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, {3.583647232958897*^9, 3.583647233183181*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD10", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"10", ",", 
      RowBox[{"pl", "[", "10", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601411517395515`*^9, 3.560141158369563*^9}, 
   3.560250976260048*^9, {3.583647581898529*^9, 3.583647582661304*^9}}],

Cell[BoxData[
 RowBox[{"LLLD10", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5601411667155776`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik10", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"2.50100382108593`*^25", "-", 
      RowBox[{"1.2153114936317619`*^26", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002028409993725091`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.012803282582269773`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0010142049968625455`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.006699483908441901`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009682410265613867`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00645354825494815`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00012473770723102367`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.004621960720186363`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00037770392986605163`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.003807751785422266`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00023186824583443715`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0014371401859489996`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1.8921599293327068`*^-6", "-", 
      RowBox[{"0.00012091145381062866`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00019318190416429452`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0000917547552937364`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0008915886119586103`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0013065401665351955`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003922272677042649`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002177919992723596`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007758668225998473`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0028117649014864354`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007087245014133219`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01380185943399`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001936899398392842`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.014423775804859632`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0050832653894472765`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.017960253600461284`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005200933569758554`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.04468045477826629`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.006142279012248791`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.04746356809751693`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0072012926350503055`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.09460002844000237`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004320775581030184`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.12368071892603075`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.009361680425565401`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.12617600000400125`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.008001436261167005`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.1265183004678169`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.564390746294783*^9, 3.564390748345786*^9}, 
   3.564391800498292*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik10max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik10", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.5"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.5601584793295856`*^9, 3.560158482839592*^9}, {
  3.5601642345696945`*^9, 3.560164251152523*^9}, {3.5606695524348297`*^9, 
  3.560669555102435*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "79.54684820593785`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", 
     RowBox[{"-", "0.0018614415607146684`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, {3.560164226052079*^9, 
   3.560164252150925*^9}, 3.560250992967677*^9, 3.560590353075924*^9, 
   3.560669933309499*^9, 3.564391807959303*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik10", "-", 
     RowBox[{"Lik10max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.04"}], ",", "0.015"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.560158486396398*^9, 
  3.5601584922776084`*^9}, {3.560164293381798*^9, 3.560164369743932*^9}, {
  3.5602510177405205`*^9, 3.560251030797744*^9}, {3.5606695576764393`*^9, 
  3.5606695607028446`*^9}, {3.5643918155103135`*^9, 3.5643918502243624`*^9}, {
  3.583647486903543*^9, 3.5836474875871687`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8V18YB/CbkESSVIokTUkDLfJcpULLiBBCsrJCNl2zouQnUlakkojM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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.04, 0.015}, {-2.995046538077871, 1.9999997890325716`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601643022738132`*^9, 3.560164370555133*^9}, {
   3.5602510249165335`*^9, 3.560251032638547*^9}, 3.5605903603299365`*^9, 
   3.5606699360395036`*^9, {3.5643918097093053`*^9, 3.5643918532843666`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik10", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik10max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.02"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.560158494726813*^9, 3.560158500046422*^9}, {
  3.560164376061943*^9, 3.5601643819743533`*^9}, {3.56066956396325*^9, 
  3.560669568580858*^9}, {3.5643918571553717`*^9, 3.5643918615453777`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.026492057303171057`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5601533751098204`*^9, 3.560164382925955*^9, 
  3.5602510395493593`*^9, 3.5605903639179425`*^9, 3.560669938441908*^9, 
  3.564391862165379*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik10", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik10max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.012"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
   3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
   3.5601545558290944`*^9}, {3.560158502370826*^9, 3.5601585094532385`*^9}, {
   3.560164387902364*^9, 3.560164392098771*^9}, {3.560251046319771*^9, 
   3.56025105717739*^9}, {3.5606695714980636`*^9, 3.5606695754448705`*^9}, 
   3.5643918654563837`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.014042087491007509`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, 3.5601643930815725`*^9, {3.5602510488001757`*^9, 
   3.560251058206992*^9}, 3.560590371093955*^9, 3.5606699403139114`*^9, 
   3.564391868207388*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 11", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, {3.58364723428717*^9, 3.5836472344467993`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD11", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"11", ",", 
      RowBox[{"pl", "[", "11", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.560141170334784*^9, 3.5601411705531845`*^9}, 
   3.5602510740566196`*^9, {3.583647585675149*^9, 3.583647586324978*^9}}],

Cell[BoxData[
 RowBox[{"LLLD11", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5601411780723977`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik11", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1.0839799898840468`*^46", "-", 
      RowBox[{"9.064177247618393`*^46", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.008729111431905495`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.07633880059865555`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00877529720667748`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.05764156402275422`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005390418824159648`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04156108697273203`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004392074982762034`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.03310892295865621`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002771146486319203`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.026016832817860398`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0035548417595995235`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.01580112428937435`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002733940232033633`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.013330301881117215`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009165894356870654`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.012857852675228935`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002771806440233545`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0037443784909570008`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000058132480343627414`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0034712569289281634`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000011715804817052714`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00014517677624758737`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00022845819393252785`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0001382467059426076`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"3.533337960698439`*^-6", "-", 
      RowBox[{"0.000016777814313577315`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000913945427699507`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01199863403609572`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000026558276539755273`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.014973913735882366`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0032540474568641792`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.05354064870363481`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.004700290771026036`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.05362657127915792`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0039937111126365004`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.06182275738222587`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.019963801145191275`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.09058047364774104`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.004007299182990147`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.12159754851354632`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.0056284994526992465`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.14000516607941954`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"3.`", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.018428124134022714`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.16764729916895954`", " ", "k2"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.023486824876695615`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.30011024582418544`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"0.016260109530020044`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.30611400019915735`", " ", "k2"}]}], "]"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5643907930898495`*^9, 3.5643907949298515`*^9}, 
   3.564391901080434*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik11max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik11", ",", 
      RowBox[{
       RowBox[{"-", "0.002"}], "<", "k2", "<", "0.01"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0.0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560158541838896*^9, 3.560158546097703*^9}, {
  3.560164465028899*^9, 3.560164470020908*^9}, {3.5606695880340924`*^9, 
  3.5606695925893*^9}, {3.5643919216044636`*^9, 3.564391934247483*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "81.58751967304629`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.007930802931791455`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, {3.5601644601616907`*^9, 
   3.560164471861711*^9}, 3.5601649525765553`*^9, 3.5601673938248434`*^9, 
   3.5602510897190475`*^9, 3.56059038510278*^9, 3.5606699499703283`*^9, {
   3.5643919057914405`*^9, 3.564391935008484*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik11", "-", 
     RowBox[{"Lik11max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.001"}], ",", "0.018"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.560158548562507*^9, 
  3.5601585738657513`*^9}, {3.560164569205882*^9, 3.56016461386876*^9}, {
  3.560251098845063*^9, 3.5602511134934893`*^9}, {3.560669598595311*^9, 
  3.5606696013409157`*^9}, {3.5643919431784954`*^9, 3.564391984955555*^9}, {
  3.5836474907922297`*^9, 3.58364749151475*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8le0fB/C7pMSvkwpJhYzskt3ge6RhZYWiUlRWQ4OczGML0ePJXgnp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.001, 0.018}, {-1.186215519748682, 1.9999998539109214`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.5601645786906986`*^9, 3.560164614664362*^9}, 
   3.5601649538869576`*^9, 3.560167395977647*^9, {3.5602511012942677`*^9, 
   3.560251114725891*^9}, 3.5605903913427906`*^9, 3.5606699546503363`*^9, {
   3.5643919486795034`*^9, 3.564391989289564*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik11", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik11max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.0009"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.560158555254919*^9, 3.560158565285737*^9}, {
  3.560164633509195*^9, 3.560164645458816*^9}, {3.5602511706207895`*^9, 
  3.5602511756595984`*^9}, {3.560669605443723*^9, 3.5606696075341268`*^9}, {
  3.56439199372957*^9, 3.5643920016505814`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.0007542930520658245`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533751098204`*^9, {3.560164637674402*^9, 3.5601646468628187`*^9}, 
   3.5601649554469604`*^9, 3.5601673986452513`*^9, 3.5602511770480003`*^9, 
   3.560590396209999*^9, 3.560669957411541*^9, {3.564391996020573*^9, 
   3.564392003230583*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik11", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik11max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.012"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
   3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
   3.5601545558290944`*^9}, {3.560158559669727*^9, 3.560158567890941*^9}, {
   3.5601646764872704`*^9, 3.5601647683246317`*^9}, 3.560164837463953*^9, {
   3.5601649388953314`*^9, 3.560164974369794*^9}, {3.560167374028408*^9, 
   3.560167381079621*^9}, {3.560167445258134*^9, 3.5601674536509485`*^9}, {
   3.5601675094522467`*^9, 3.560167509764247*^9}, {3.5602511867044177`*^9, 
   3.560251223333282*^9}, {3.5605904138692303`*^9, 3.5605904149768324`*^9}, {
   3.560669610139331*^9, 3.560669612416935*^9}, 3.564392009841593*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.01576160821024348`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5601533814122314`*^9, {3.560164690808096*^9, 3.5601647306973658`*^9}, {
   3.5601647624746213`*^9, 3.5601647694010334`*^9}, {3.560164939971733*^9, 
   3.5601649760701966`*^9}, {3.5601673834352245`*^9, 3.5601674023112583`*^9}, 
   3.5601674474265375`*^9, 3.5601675113398495`*^9, {3.5602511886856213`*^9, 
   3.560251224019683*^9}, {3.5605903989712043`*^9, 3.5605904158816338`*^9}, 
   3.5606699595955453`*^9, 3.5643920113415947`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 12", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, {3.583647235935213*^9, 3.583647238207559*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD12", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"12", ",", 
      RowBox[{"pl", "[", "12", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601411866056128`*^9, 3.5601411917224216`*^9}, 
   3.5602512296980934`*^9, {3.583647589899589*^9, 3.583647590589406*^9}}],

Cell[BoxData[
 RowBox[{"LLLD12", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.5601411973384314`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik12", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"2.527410240186534`*^59", "-", 
      RowBox[{"1.7384401806004238`*^60", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001753662830639192`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.014887193569687505`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001374858438405`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00773986803244593`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0017353168194878903`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.006548945323958594`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007173833881583729`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0055011059690560395`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005904213784554758`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00453814072978111`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003891578123003523`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0034333250936262657`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000679346862319687`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.003299539217239771`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0006128580377044134`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0032843088884129974`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003769255283353954`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.003150338246685571`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001721544463777669`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.002826153113401039`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0040903896459357405`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00219037523207327`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001055783547679971`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.002185561102987027`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002599136303134311`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0019215402164410758`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00035721695068289904`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0018354144722748662`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00011360987083836548`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0012634221393633478`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005824008503760728`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0012407643210408325`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0002494098248020184`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0004417782205951837`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00005474701058729143`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00020227994592207247`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"9.270139275875397`*^-6", "-", 
      RowBox[{"0.00012503925590898505`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00004608808165009742`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00007780295483433516`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00007716500181317184`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0001745015219039056`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00019384544014838117`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00028668291525525664`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0000720183492950051`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0004148736506166326`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"6.5581771465620115`*^-6", "+", 
      RowBox[{"0.0005100559526285504`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000029686731486874646`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0006492846908607774`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0008197830779893662`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0007719678241015489`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00016673809379803156`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.001156040006196983`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005802675139278087`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0032799602359218517`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0012781163443197846`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.005295080924563017`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009146120394432713`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.006196505069965538`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0023768480375032`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.008393536234672566`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0001778412298917471`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.00944945627748911`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009230370234219886`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.016392263762992933`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001122849601995087`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.017355431442818602`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003710103987243302`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.03148364894296563`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002368141634435423`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.03173643758604559`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0030256806083378586`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.05249387614029938`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0027544711420442692`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0563732850689056`", " ", "k2"}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.564390813542878*^9, 3.5643908166828823`*^9}, {
  3.564392051086651*^9, 3.5643920610076647`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik12max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik12", ",", 
      RowBox[{
       RowBox[{"-", "0.1"}], "<", "k2", "<", "0.05"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
   3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
   3.5601546730165005`*^9}, {3.5601585903549805`*^9, 3.560158593927387*^9}, {
   3.5601650920564003`*^9, 3.560165092259201*^9}, {3.560593351884791*^9, 
   3.5605933533043933`*^9}, {3.56066963222897*^9, 3.5606696346001744`*^9}, {
   3.564392066688673*^9, 3.5643920673986735`*^9}, 3.564392102313724*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "155.43143012361284`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", "0.029004370800716543`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, 3.5601649920602245`*^9, 
   3.560165093288802*^9, 3.560251245641321*^9, 3.5605904275036545`*^9, 
   3.5605933352395616`*^9, 3.5606699704219637`*^9, {3.564392055137656*^9, 
   3.564392068058675*^9}, 3.5643921032947254`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik12", "-", 
     RowBox[{"Lik12max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.05"}], ",", "0.08"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601651903053727`*^9, 3.5601651933941784`*^9}, {
   3.5601652676503086`*^9, 3.5601652691011114`*^9}, {3.5601654156945686`*^9, 
   3.5601654367546053`*^9}, 3.560165474803073*^9, {3.5601656074033055`*^9, 
   3.560165621895731*^9}, {3.560167257184203*^9, 3.5601672609438095`*^9}, {
   3.5602512771689763`*^9, 3.560251322970657*^9}, {3.56059336289841*^9, 
   3.560593364380413*^9}, {3.560669637330179*^9, 3.5606696400445843`*^9}, {
   3.5643920758396854`*^9, 3.564392141719781*^9}, {3.583647494536763*^9, 
   3.5836474981716013`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk4VV8XB/BjHpKZQhJJE5IyFFkqTZpQIclMEhGFpNyQITKUZCoUKaUy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.05, 0.08}, {-5.819470578542084, 1.9999994003264874`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560165394322531*^9, 3.560165439765411*^9}, 
   3.560165475692274*^9, {3.560165611771313*^9, 3.560165623424534*^9}, 
   3.5601672659046183`*^9, {3.5602512687293615`*^9, 3.5602513237818584`*^9}, 
   3.5605904304364595`*^9, {3.5605933404655704`*^9, 3.5605933700120225`*^9}, 
   3.5606699734171696`*^9, {3.564392073119682*^9, 3.5643921421597815`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik12", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik12max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
  3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
  3.5601545450806756`*^9}, {3.5601586087942133`*^9, 3.560158612351019*^9}, {
  3.560165639648562*^9, 3.5601656398825626`*^9}, {3.5601672430973787`*^9, 
  3.5601672460613832`*^9}, {3.5606696477509975`*^9, 3.5606696511050034`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.0004026183108611256`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5601533751098204`*^9, 3.5601656465593743`*^9, 
  3.560167246700985*^9, 3.56025133033387*^9, 3.560590432994864*^9, 
  3.5606699758039737`*^9, 3.5643921469997883`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik12", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik12max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.06"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
  3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
  3.5601545558290944`*^9}, {3.5601586145194235`*^9, 3.5601586174366283`*^9}, {
  3.560165643408169*^9, 3.560165643704569*^9}, {3.5606696547554097`*^9, 
  3.560669657298214*^9}, {3.5643921757738285`*^9, 3.564392176133829*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.06007698165645848`"}], "}"}]], "Output",
 CellChangeTimes->{3.5601533814122314`*^9, 3.560251335700279*^9, 
  3.5605904354128685`*^9, 3.5606699776603765`*^9, 3.5643921766138296`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["sample 13", "Subsection",
 CellChangeTimes->{{3.583647010591333*^9, 3.583647017038809*^9}, 
   3.58364717448275*^9, {3.583647240279574*^9, 3.583647240543695*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Computation", " ", "and", " ", "simplification", " ", "of", " ", "the", 
    " ", "LogLikelihood", " ", "of", " ", "the", " ", "genotypes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LLLD13", "=", 
    RowBox[{"LogLikelihoodDisequilibrium", "[", 
     RowBox[{"13", ",", 
      RowBox[{"pl", "[", "13", "]"}], ",", "\[Delta]p", ",", "cc"}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52974676046875*^9, 3.529746775234375*^9}, {
   3.529746808765625*^9, 3.5297468135625*^9}, {3.52974691478125*^9, 
   3.529746970703125*^9}, {3.5297470739375*^9, 3.52974708375*^9}, {
   3.529747138046875*^9, 3.529747139640625*^9}, {3.5297472045625*^9, 
   3.52974721384375*^9}, 3.52974744909375*^9, {3.529747575828125*^9, 
   3.52974757603125*^9}, {3.52974775065625*^9, 3.529747750875*^9}, 
   3.529747868296875*^9, 3.529748317328125*^9, {3.529748443875*^9, 
   3.52974845178125*^9}, {3.529748488*^9, 3.529748488890625*^9}, 
   3.529749146125*^9, 3.529749238453125*^9, 3.529749811109375*^9, {
   3.529752712359375*^9, 3.52975273228125*^9}, {3.529753961890625*^9, 
   3.529753964078125*^9}, {3.52975418790625*^9, 3.529754193109375*^9}, {
   3.52975477828125*^9, 3.529754779265625*^9}, 3.529755060421875*^9, {
   3.52975519746875*^9, 3.52975519971875*^9}, 3.560079319897431*^9, {
   3.5600793593335752`*^9, 3.5600793632538*^9}, {3.5601406247394257`*^9, 
   3.5601406307610364`*^9}, {3.5601412018312397`*^9, 3.560141207135249*^9}, 
   3.560251360098722*^9, 3.56051219155564*^9, 3.56057642482446*^9, {
   3.583647593508135*^9, 3.583647594142683*^9}}],

Cell[BoxData[
 RowBox[{"LLLD13", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.560141212454858*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lik13", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"2.5155746403037994`*^59", "-", 
      RowBox[{"1.3926453299503897`*^60", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003336387189620238`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.01004940955218088`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.001347387134269712`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.009222376639983166`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005490627349650501`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.008523854342416695`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00004471305074128859`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00838784603737494`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005560645316033731`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.007898894020912182`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0034144965887083377`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.006618874855251651`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000854966323509124`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00595330732065116`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0006223225979633526`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.004379453332135492`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0004249172364138983`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0033767806245921846`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0005467657936166946`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0027408344613230953`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00021721163141474507`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0026519708618969657`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000319437967025387`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.001887054863499612`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00024340536209901882`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0015845610656921292`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007166227408400216`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0015529342937086969`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0001869450628278317`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.0012697638277238018`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00024035793792149792`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00026332386434517983`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0024660253140671323`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00012819382065932042`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000016396142082633077`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00011759701072027351`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.000019895790333761128`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.00006268908958252894`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003342013920791197`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.000505762563981008`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0009590098443594407`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0007739272972139292`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0026124500975596553`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0019763957358338593`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0013504424338939064`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0022995332824597447`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00011374080990928023`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.002501031499285628`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0003077692503427583`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.004402566145273073`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.00564750241678337`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.010666380323028`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0013254342406736484`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.012024247783190214`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0006323702890553693`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.012917577691906957`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0033428231216989803`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.013939643430483295`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0007569954127709785`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.01484386385667483`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0011360864920059847`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.017646577726743936`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.005838677581835417`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.019228157908875748`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0017663226297989498`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.022262755979850737`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0028652769614562687`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.0273307517905054`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.003992612413251549`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.030471323354872487`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0018262304010794054`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.03133786788265185`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.0014949271103250103`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.03444895162447775`", " ", "k2"}]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"0.002562732189128589`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.08574998491770816`", " ", "k2"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5643908344559073`*^9, 3.56439083643591*^9}, 
   3.564392193765854*^9, {3.564476101963295*^9, 3.564476108827307*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lik13max", "=", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Lik13", ",", 
      RowBox[{
       RowBox[{"-", "0.02"}], "<", "k2", "<", "0.05"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5601533128813114`*^9, 3.5601533152837152`*^9}, {
  3.560154509200612*^9, 3.560154513880621*^9}, {3.560154666417689*^9, 
  3.5601546730165005`*^9}, {3.560158662583108*^9, 3.5601586664831142`*^9}, {
  3.5601658078012576`*^9, 3.5601658170208735`*^9}, {3.560669669762636*^9, 
  3.5606696734442425`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "137.7934547973236`"}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", "\[Rule]", 
     RowBox[{"-", "0.003218256244694974`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5601533366869535`*^9, 3.5601533457817693`*^9}, 
   3.560154564112709*^9, 3.5601546765889063`*^9, {3.5601658048996525`*^9, 
   3.5601658186276765`*^9}, 3.560251372500744*^9, 3.5602517644670324`*^9, 
   3.5605904450224853`*^9, 3.56066998492999*^9, 3.564392196955858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "and", " ", "roots", " ", "to", " ", "find", " ", "the", " ",
      "support", " ", "limits", " ", "of", " ", 
     StyleBox[
      RowBox[{"k", 
       StyleBox["0",
        FontSize->8]}]]}], 
    StyleBox[",",
     FontSize->8], 
    StyleBox["2",
     FontSize->8]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Lik13", "-", 
     RowBox[{"Lik13max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"k2", ",", 
      RowBox[{"-", "0.05"}], ",", "0.02"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.56015331774852*^9, 3.5601533205565248`*^9}, {
  3.5601533576377897`*^9, 3.560153358526992*^9}, {3.5601545200582314`*^9, 
  3.5601545298862486`*^9}, {3.5601545843615446`*^9, 3.5601546139235964`*^9}, {
  3.5601547380218143`*^9, 3.560154742826623*^9}, {3.560158636593462*^9, 
  3.5601586455010777`*^9}, {3.5601658257880893`*^9, 3.5601658715429697`*^9}, {
  3.560251770738243*^9, 3.5602517804414606`*^9}, {3.5606696782958508`*^9, 
  3.560669681181856*^9}, {3.583647502145505*^9, 3.583647502908119*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk8VN8bB/CbNmQLXy22lGhBQspSj8qWhNJmyU72rWSJuoVU31ZJklAp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.05, 0.02}, {-5.7368935761297415`, 1.9999999962701338`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.560153348137373*^9, 3.5601533614129963`*^9}, {
   3.5601545735195255`*^9, 3.5601546155615993`*^9}, {3.560154732421405*^9, 
   3.5601547445270257`*^9}, {3.56016582655249*^9, 3.5601658724009705`*^9}, {
   3.5602517678210382`*^9, 3.5602517810654616`*^9}, 3.56059044781489*^9, 
   3.5606699878315945`*^9, 3.564392200056863*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik13", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik13max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", 
     RowBox[{"-", "0.02"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.560153322802929*^9, 3.5601533242537313`*^9}, {
   3.5601533715998144`*^9, 3.5601533740334187`*^9}, {3.5601545416018696`*^9, 
   3.5601545450806756`*^9}, {3.560158648667883*^9, 3.56015866974352*^9}, 
   3.5601658814177866`*^9, {3.56025178593267*^9, 3.560251786385071*^9}, {
   3.5606696848790627`*^9, 3.5606696876870675`*^9}, {3.5643922048168693`*^9, 
   3.5643922054868703`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", 
   RowBox[{"-", "0.020062038822920226`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5601533751098204`*^9, 3.560165888390999*^9, 
  3.5602517868062716`*^9, 3.560590451340496*^9, 3.5606699904991994`*^9, 
  3.5643922063968716`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Lik13", "\[Equal]", 
    RowBox[{
     RowBox[{"Lik13max", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k2", ",", "0.005"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5601533300101414`*^9, 3.560153332038145*^9}, {
   3.56015338042943*^9, 3.5601533808350306`*^9}, {3.560154549979084*^9, 
   3.5601545558290944`*^9}, {3.5601586712723227`*^9, 3.5601586737371273`*^9}, 
   3.5602518028743*^9, {3.560669691353074*^9, 3.5606696951282806`*^9}, {
   3.5643922099178762`*^9, 3.5643922113978786`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k2", "\[Rule]", "0.004793746642130072`"}], "}"}]], "Output",
 CellChangeTimes->{{3.5602517963222885`*^9, 3.5602518033111005`*^9}, 
   3.560590455100103*^9, 3.5606699920748024`*^9, 3.5643922119978795`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Spatial fit of the k",
 StyleBox["0, 2",
  FontSize->12],
 " cumulant (LD) by simulated annealing"
}], "Section",
 CellChangeTimes->{{3.5836479321995707`*^9, 3.583647953199254*^9}, {
   3.583654771461445*^9, 3.583654777261804*^9}, {3.5836549591410217`*^9, 
   3.58365500425835*^9}, {3.58367052733914*^9, 3.58367053175906*^9}, 
   3.5837342201116133`*^9}],

Cell[CellGroupData[{

Cell["data and likelihood", "Subsection",
 CellChangeTimes->{{3.58364797634783*^9, 3.5836479956766577`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "geographic", " ", "coordinates", " ", "of", " ", "the", " ", "samples"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"distX1", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "58", ",", "302", ",", "340", ",", " ", "333", ",", "369", 
       ",", "334", ",", "377", ",", "424", " ", ",", "462", ",", " ", "462", 
       ",", " ", "710", ",", " ", "888"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"distY1", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "99", ",", "85", ",", " ", "84", ",", " ", "130", ",", " ", 
       "120", ",", " ", "148", ",", " ", "137", ",", " ", "144", " ", ",", 
       "162", ",", " ", "175", ",", " ", "227", ",", " ", "338"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5643221857778177`*^9, 3.564322255728341*^9}, {
  3.5829425585288954`*^9, 3.582942563052903*^9}, {3.583648028862721*^9, 
  3.583648041807001*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"transformed", " ", "geographic", " ", "coordinates"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Coord", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"distX1", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"distY1", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ")"}], "^", "2"}]}], "]"}], "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"angle1", "-", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"distY1", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/", 
           RowBox[{"distX1", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "distX1", "]"}]}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{
  3.5642913398486595`*^9, {3.5643904131163125`*^9, 3.564390413476313*^9}, 
   3.564390520441466*^9, 3.582544556001593*^9, {3.582692450868533*^9, 
   3.5826924637264977`*^9}, {3.583648045655476*^9, 3.583648063749515*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "LogLikelihood", " ", "of", " ", "the", " ", "genotypes", " ", "per", " ", 
    "sample", " ", "and", " ", "total", " ", "Loglikelilihood"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Lik1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1.0430056172654036`*^60", "-", 
         RowBox[{"8.945781993294531`*^61", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0050785781445185415`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.3327986975631658`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0025000455138698076`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.16748897328888113`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.012630203037672193`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.0864317133625069`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0011599809345230528`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.045828080888253034`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0015438725078101025`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.04110439795524019`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.01449976168153816`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.03975933930641509`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.002322853485191721`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.029639435528587863`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"3.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.012757780846133535`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.027189360572249483`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00045775690036660855`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.015433099940039418`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00006247479045467219`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0007203152682613617`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00005639772624415109`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.004824523198187903`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.008263562593518313`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.008135789560881797`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"4.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.016759307876911177`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.28031493795229784`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"4.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.01470114726044841`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.3170987511117995`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"3.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.016666970092465386`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.503443306603856`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"3.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.01462014920391701`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.5310296238764189`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"5.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.02031431257807417`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.5880122538153104`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.05789579084751134`", "\[VeryThinSpace]", "+", 
          RowBox[{"1.3585818798946374`", " ", "k2"}]}], "]"}]}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik2", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"4.5865717985064214`*^39", "-", 
         RowBox[{"9.436582330968947`*^41", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003193628013118721`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.30433515957860907`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009928017519042981`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.2093155040226427`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009300640550933348`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.19033816025793593`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.01446525629471421`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.17771862591122684`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.007512055829600013`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.14488335311331127`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0037639187297470646`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.1438648652062439`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003374228176406765`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.05031742626669453`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004699817817137994`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.046581044235160685`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005280966583784552`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.04496313543101812`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0027362918293339406`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.03806863587105651`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0004532545311591177`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.010917419857857985`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007664410327974755`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.005339552668133795`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00024101629831476892`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00957232240675266`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"6.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.005913994263365226`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.07152320426977729`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.02092644123960003`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.33573984697568393`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.03380425123320005`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.34131072484856473`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.010096861354400855`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.3936245117327991`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.019237806840929437`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.6987548652167204`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.03262062899114122`", "\[VeryThinSpace]", "+", 
          RowBox[{"1.0143181347145216`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.055313240463239474`", "\[VeryThinSpace]", "+", 
         RowBox[{"1.430776150629906`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik3", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"6.55400227078692`*^51", "-", 
         RowBox[{"6.269682223626508`*^53", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.013814582152699727`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.5364490925858559`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0018812129193949531`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.5355817835258697`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009766182498687517`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.28319311902212246`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005816666169557781`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.20250404016833312`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0026043153329833374`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.16041005134594666`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005580675713535724`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.13736056589663936`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.006311478485546353`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.04263763455817622`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00823236324201698`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.030772411074424667`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0017449998508673346`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.026398167783548476`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004650563094613103`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.02155543488012345`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002368214083319953`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.017191489870642854`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0060659518625388285`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.005486203621886461`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0019780277812626616`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.005590231755154909`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"10.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.010084644971470803`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.2535669412132912`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.010494362772712464`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.3014914914629976`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.03255394166229172`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.3051772309814501`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"4.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.019328902861985707`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.3486773718477757`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.013688299268755387`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.5100204727090308`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0424616630377718`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.6432369378979899`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.024230840320467604`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.945473409796953`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.03288471186349174`", "\[VeryThinSpace]", "+", 
         RowBox[{"1.0604845227275168`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.07430791031610065`", "\[VeryThinSpace]", "+", 
         RowBox[{"2.3185352770110734`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik4", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"6.640987538883745`*^51", "-", 
         RowBox[{"2.8756005714930885`*^53", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.023311746628990604`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.2238167507771513`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0056964609620493625`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.2149461629864612`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.017369536703953796`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.1333719848015975`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.01092599889442255`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.1121833000855477`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.006878876054456244`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.09612699657373085`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00713496120499112`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.07542886260939119`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009264924942291135`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.07132941236321921`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0013290614009297194`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.06785478715984948`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0012813592650457715`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.024463019825390023`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0013243635023542483`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.02427235839744923`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001088416796301896`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0178152352050649`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002624902115548573`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.007242483232175072`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.3037548856240393`*^-7", "+", 
         RowBox[{"0.0000721628727294895`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.9166120968211513`*^-6", "+", 
         RowBox[{"0.00045381114726226486`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.4602202077884207`*^-6", "+", 
         RowBox[{"0.0010752380779477152`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.005462999447211275`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.008316628990872689`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.011655873314495302`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.030061449464763988`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009264924942291135`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.06060025332024725`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0068971855765989866`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.20078733195525694`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"7.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.01128584559022561`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.2862907801302426`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.010964756557670187`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.41117448419882097`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.04969412655050956`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.9120298132832163`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.023394440104826657`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.9155346153900292`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.029431714970588378`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.9251401624304727`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.03139780119331996`", "\[VeryThinSpace]", "+", 
         RowBox[{"1.0167115198402843`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik5", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"4.3669654838298525`*^50", "-", 
         RowBox[{"2.260763088005438`*^51", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00021455088862979918`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0015882096600634906`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00031342475106450494`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0014132085706195193`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00035715843725955213`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.001413036463196018`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002183396251389441`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0011142417737762043`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00010314434024811462`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0007661154103615857`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00008840943449838394`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0006257738804015085`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0000650791670613104`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0006156663948391631`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003249506837061026`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005996767504740886`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0001562185274462878`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005749982208447509`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00009126135174026729`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005692009582979681`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00009286580813757734`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005134449184948434`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000048346977466948413`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0002985919505564988`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007961087550537443`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.000232746086059852`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00003052900786026439`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00018783789425210536`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00041210335555723235`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00015839980383260165`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000038561517822915744`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00015106064197124768`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00001094071231915357`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00010436554835705676`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00014469214314375713`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00008463571021323534`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.209956858704109`*^-6", "-", 
         RowBox[{"0.0000460188965418654`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"7.487718757453107`*^-7", "-", 
         RowBox[{"0.00003201323069569306`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"3.4936159609451483`*^-6", "-", 
         RowBox[{"0.00002556227231593433`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000012173716727249399`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.1765256627489692`*^-6", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.663298648951572`*^-6", "+", 
         RowBox[{"5.685301402491372`*^-6", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000011998658557562286`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0001895882229736362`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00016247534185305127`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0002767845115049549`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00001999022762919358`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00038297718520641444`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000030959975257784604`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00044798111577482394`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00006457466163108303`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0005186762544526287`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00017596643643273395`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.001108115281192697`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00034381446749371546`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0013849686761320565`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00016582356015622062`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0014207092598307143`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00042317863323783307`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002271269432069838`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00026653692984941036`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.004315293633702283`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00010298017744181765`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0049340328057548575`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "5", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik6", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"2.4487034412409348`*^39", "-", 
         RowBox[{"1.59157513172815`*^40", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009186906859412706`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.004886507071213334`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000537111046849654`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.003680023366926606`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007988614660358873`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.003191670256257539`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0019855530553722113`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.002781258390260437`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0004192424973756337`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0025054181597882223`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002938280750837774`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.002314508219682454`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0006800021166224566`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0021108229401361747`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00019969922919752154`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0018477506149545062`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00009316649834891188`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0010035111500679111`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00010801739062818257`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0008060255676779743`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00010996313737071406`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0002044801251717858`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"5.7186723587330345`*^-8", "+", 
         RowBox[{"0.000010514335062453981`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"4.732938737277452`*^-7", "+", 
         RowBox[{"0.000028622558522418213`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.3808833184295247`*^-6", "+", 
         RowBox[{"0.00010293383880692439`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"8.845555988584798`*^-6", "+", 
         RowBox[{"0.00019766448127178237`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"5.84086183897814`*^-6", "+", 
         RowBox[{"0.00021969594916921412`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00009228982306638375`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00026553404014940615`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00003600627605887796`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00034940979461947066`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00011592929791684187`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0013525922317387377`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00034257299091998135`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.008258920628467843`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0021761003117621485`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.011947626674459935`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0017265678742367056`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.015406916731518252`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0014946951636346066`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01806902091295654`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004708289765449012`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.06071193311290462`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0023020904989822745`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.06881490826374305`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004094165013433923`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.07135828061518976`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0033572153110158166`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.08119722617265483`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003597016404659804`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.1775118320948194`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "6", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik7", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"8.190985204205286`*^56", "-", 
         RowBox[{"6.419275564778786`*^57", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005250388835636238`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0030948447657750877`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00038885122066949045`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00293505798667776`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002072445148733081`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.002893714054312062`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00016693394240111507`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0023140291988717164`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.0005730263084054604`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.0021858768147981714`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00010001382440586223`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0007690037210705026`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00005241276312404258`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005908942165623322`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003856174069465759`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005183437034113734`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00006203959716723407`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00010370589945913884`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"3.8167639920361635`*^-6", "-", 
         RowBox[{"0.00004511283658601872`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.2276921925615103`*^-6", "+", 
         RowBox[{"0.00002765654536917924`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000019127207212252397`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00020814714934445718`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.0280765196326955`*^-6", "+", 
         RowBox[{"0.00021579941060538015`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000015586773309224025`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00021813483226630252`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"9.734877770539283`*^-6", "+", 
         RowBox[{"0.0003085401798902958`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000026022595392217997`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00036740563467501486`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000405728972388234`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00047741484111956615`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.097364755490541`*^-6", "+", 
         RowBox[{"0.0004803617933445846`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00012663051385650745`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0005205939318428161`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00008476906511501649`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0018747972371693984`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00009990792271087046`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0019499215820332765`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007131954592761926`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.001960385372791878`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.000672655927906809`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.0027061777462010625`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0015967441320916872`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.004121282778138611`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0014039144555933777`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.006267185577660267`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005665146458099438`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00958157417377874`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0008707489834277518`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.011151450107407083`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001902077649513609`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01874352051577408`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00032691959601015145`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01990902063939185`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001348973490905046`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.022028819030376994`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0012263395371864055`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.029879275639534346`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0014608433358333358`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.02995992158503911`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0021670098935530043`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.04193630786103343`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002507284174358848`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.054800717499491995`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0021058716833900664`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0619956777171975`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "7", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik8", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1.2392786073745507`*^49", "-", 
         RowBox[{"4.983407501769156`*^49", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00014353758178677525`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0012028470132572056`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0004042450206114092`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0008073691181978288`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007460425673202012`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0005776791477002614`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00004205840041362842`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0002493171492940964`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00016771675042020714`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00022999426949038408`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00002717860101865318`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0002076076295924303`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00024088939389608447`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00017535252276621967`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00003545162750857721`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00016183714294243202`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00020448348549730966`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00011211449938086486`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"7.289644795515754`*^-6", "-", 
         RowBox[{"0.00009583623781868022`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.6509941576779173`*^-6", "-", 
         RowBox[{"0.000028104766319294395`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"3.219035705699337`*^-6", "+", 
         RowBox[{"4.341522866416096`*^-6", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00008639293583352406`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.000016065077177180556`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.3452974427238033`*^-6", "+", 
         RowBox[{"0.00011195896281185192`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.091650443259863`*^-6", "+", 
         RowBox[{"0.00014738320772417462`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"9.477094225857586`*^-6", "+", 
         RowBox[{"0.0002253444327539667`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.684992357925433`*^-6", "+", 
         RowBox[{"0.00032009928284417713`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.592998938210308`*^-6", "+", 
         RowBox[{"0.0003949845398457422`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000024350557399144675`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.000489810301389311`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000016613061648005824`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0005061042991546717`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00003207322517166563`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0006343199309093283`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007885562414042657`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0006837595300233559`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000023002700743392682`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.000741106340227144`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000018917587260222217`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.000932247795806157`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00008590607211612491`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0011038750612097133`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00004926998821901012`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.001639963380347036`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000040796460096767164`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0023119033122099867`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00004079646009676715`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002664322430807691`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00006719416957114591`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0031371628914902885`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000035900884885155105`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0033576680077787207`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00005293548842760117`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.003599716886510179`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.00009907711737786311`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.005294449775910258`", " ", "k2"}]}], "]"}]}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "8", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik9", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"2.3140803529380704`*^29", "-", 
         RowBox[{"6.771614345402205`*^29", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000423474537572866`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0003914726822368446`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000047590057537870434`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00009859765141146347`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.8517143214470046`*^-6", "-", 
         RowBox[{"0.000023247071351718865`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.6311282882541836`*^-9", "+", 
         RowBox[{"5.599372113715638`*^-7", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"2.745609607378083`*^-9", "+", 
         RowBox[{"8.786645268976079`*^-7", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.0570640304311075`*^-7", "+", 
         RowBox[{"0.000015213865303038462`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.688918093733913`*^-7", "+", 
         RowBox[{"0.000029288113344793754`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002946622362832869`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00039761737422431865`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.000025483838636751335`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.000936029971527558`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00005642849983852085`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0014431309676879187`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0001555670590737692`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0014758021107182022`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00015556705907376922`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0015536230003004403`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000053009614945109815`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0016289761595276817`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00011424363792533704`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002727127338691406`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0004492824717651712`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002811224660666093`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00024266301811564804`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0029053261658483903`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00017871704234008646`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00336090584313759`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005455572871434218`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00591909397848641`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00027404872668994546`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0066149796233765604`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00041634635071471655`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.009664778057659234`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007002188625656597`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.010108418606555794`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007556114297868786`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.012891198871524994`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "9", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik10", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"2.50100382108593`*^25", "-", 
         RowBox[{"1.2153114936317619`*^26", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002028409993725091`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.012803282582269773`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0010142049968625455`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.006699483908441901`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009682410265613867`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00645354825494815`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00012473770723102367`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.004621960720186363`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00037770392986605163`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.003807751785422266`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00023186824583443715`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0014371401859489996`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1.8921599293327068`*^-6", "-", 
         RowBox[{"0.00012091145381062866`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00019318190416429452`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0000917547552937364`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0008915886119586103`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0013065401665351955`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003922272677042649`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002177919992723596`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007758668225998473`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0028117649014864354`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007087245014133219`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01380185943399`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001936899398392842`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.014423775804859632`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0050832653894472765`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.017960253600461284`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005200933569758554`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.04468045477826629`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.006142279012248791`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.04746356809751693`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0072012926350503055`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.09460002844000237`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004320775581030184`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.12368071892603075`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.009361680425565401`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.12617600000400125`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.008001436261167005`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.1265183004678169`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "10", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik11", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1.0839799898840468`*^46", "-", 
         RowBox[{"9.064177247618393`*^46", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.008729111431905495`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.07633880059865555`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00877529720667748`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.05764156402275422`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005390418824159648`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.04156108697273203`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004392074982762034`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.03310892295865621`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002771146486319203`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.026016832817860398`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0035548417595995235`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.01580112428937435`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002733940232033633`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.013330301881117215`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009165894356870654`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.012857852675228935`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002771806440233545`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0037443784909570008`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000058132480343627414`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0034712569289281634`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000011715804817052714`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00014517677624758737`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00022845819393252785`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0001382467059426076`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"3.533337960698439`*^-6", "-", 
         RowBox[{"0.000016777814313577315`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000913945427699507`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01199863403609572`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000026558276539755273`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.014973913735882366`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0032540474568641792`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.05354064870363481`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.004700290771026036`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.05362657127915792`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0039937111126365004`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.06182275738222587`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.019963801145191275`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.09058047364774104`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.004007299182990147`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.12159754851354632`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.0056284994526992465`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.14000516607941954`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"3.`", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.018428124134022714`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.16764729916895954`", " ", "k2"}]}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.023486824876695615`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.30011024582418544`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"0.016260109530020044`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.30611400019915735`", " ", "k2"}]}], "]"}]}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "11", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik12", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"2.527410240186534`*^59", "-", 
         RowBox[{"1.7384401806004238`*^60", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001753662830639192`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.014887193569687505`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001374858438405`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00773986803244593`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0017353168194878903`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.006548945323958594`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007173833881583729`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0055011059690560395`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005904213784554758`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00453814072978111`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003891578123003523`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0034333250936262657`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000679346862319687`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.003299539217239771`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0006128580377044134`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0032843088884129974`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003769255283353954`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.003150338246685571`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001721544463777669`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.002826153113401039`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0040903896459357405`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00219037523207327`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001055783547679971`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.002185561102987027`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002599136303134311`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0019215402164410758`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00035721695068289904`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0018354144722748662`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00011360987083836548`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0012634221393633478`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005824008503760728`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0012407643210408325`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0002494098248020184`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0004417782205951837`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00005474701058729143`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00020227994592207247`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"9.270139275875397`*^-6", "-", 
         RowBox[{"0.00012503925590898505`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00004608808165009742`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00007780295483433516`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00007716500181317184`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0001745015219039056`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00019384544014838117`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00028668291525525664`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0000720183492950051`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0004148736506166326`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"6.5581771465620115`*^-6", "+", 
         RowBox[{"0.0005100559526285504`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000029686731486874646`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0006492846908607774`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0008197830779893662`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0007719678241015489`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00016673809379803156`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.001156040006196983`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005802675139278087`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0032799602359218517`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0012781163443197846`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.005295080924563017`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009146120394432713`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.006196505069965538`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0023768480375032`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.008393536234672566`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0001778412298917471`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.00944945627748911`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009230370234219886`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.016392263762992933`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001122849601995087`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.017355431442818602`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003710103987243302`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.03148364894296563`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002368141634435423`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.03173643758604559`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0030256806083378586`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.05249387614029938`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0027544711420442692`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0563732850689056`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "12", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Lik13", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"2.5155746403037994`*^59", "-", 
         RowBox[{"1.3926453299503897`*^60", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003336387189620238`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.01004940955218088`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.001347387134269712`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.009222376639983166`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005490627349650501`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.008523854342416695`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00004471305074128859`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00838784603737494`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005560645316033731`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.007898894020912182`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0034144965887083377`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.006618874855251651`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000854966323509124`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00595330732065116`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0006223225979633526`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.004379453332135492`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0004249172364138983`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0033767806245921846`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0005467657936166946`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0027408344613230953`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00021721163141474507`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0026519708618969657`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000319437967025387`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.001887054863499612`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00024340536209901882`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0015845610656921292`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007166227408400216`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0015529342937086969`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0001869450628278317`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.0012697638277238018`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00024035793792149792`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00026332386434517983`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0024660253140671323`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00012819382065932042`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000016396142082633077`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00011759701072027351`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.000019895790333761128`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.00006268908958252894`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003342013920791197`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.000505762563981008`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0009590098443594407`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0007739272972139292`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0026124500975596553`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0019763957358338593`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0013504424338939064`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0022995332824597447`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00011374080990928023`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.002501031499285628`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0003077692503427583`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.004402566145273073`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.00564750241678337`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.010666380323028`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0013254342406736484`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.012024247783190214`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0006323702890553693`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.012917577691906957`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0033428231216989803`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.013939643430483295`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0007569954127709785`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.01484386385667483`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0011360864920059847`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.017646577726743936`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.005838677581835417`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.019228157908875748`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0017663226297989498`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.022262755979850737`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0028652769614562687`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.0273307517905054`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.003992612413251549`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.030471323354872487`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0018262304010794054`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.03133786788265185`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.0014949271103250103`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.03444895162447775`", " ", "k2"}]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"0.002562732189128589`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.08574998491770816`", " ", "k2"}]}], "]"}]}], "/.", 
      RowBox[{"k2", "\[Rule]", 
       RowBox[{"a0", "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "b0"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coord", "[", 
              RowBox[{"[", "13", "]"}], "]"}], "-", "c0"}], ")"}], 
           "2"]}]]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"LLTot", "=", 
     RowBox[{"(", 
      RowBox[{
      "Lik1", "+", "Lik2", "+", "Lik3", "+", "Lik4", "+", "Lik5", "+", "Lik6",
        "+", "Lik7", "+", "Lik8", "+", "Lik9", "+", "Lik10", "+", "Lik11", 
       "+", "Lik12", "+", "Lik13"}], ")"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.56439036515724*^9, 3.564390369448246*^9}, 
   3.564390924953038*^9, 3.564393909512517*^9, {3.5643942172909503`*^9, 
   3.5643942175809507`*^9}, {3.564476084694065*^9, 3.5644760940852814`*^9}, 
   3.582654873613055*^9, 3.5836480231658993`*^9, {3.583648066265192*^9, 
   3.583648096848062*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Simulated annealing: Global search", "Subsection",
 CellChangeTimes->{{3.583569442157041*^9, 3.583569445300948*^9}, 
   3.5835725370547256`*^9, {3.583641983961051*^9, 3.5836419862680387`*^9}, 
   3.5836421181496887`*^9, {3.583654915290317*^9, 3.583654922934939*^9}}],

Cell["\<\
Adapted from \"Markov Chain Monte Carlo Simulation Using the Metropolis \
Algorithm\" from the Wolfram Demonstrations Project
http : // \
demonstrations.wolfram.com/\
MarkovChainMonteCarloSimulationUsingTheMetropolisAlgorithm/Contributed by : \
Philip Gregory (Physics and Astronomy, University of British Columbia)
and from the metropolis algorithm adapted from the work of Szymura and Barton \
(1986)\
\>", "Text",
 CellChangeTimes->{{3.583724047658164*^9, 3.583724057290538*^9}, 
   3.583734345044071*^9}],

Cell["\<\
The function FindMaximum cannot be used here to find the maximum likelihood \
because the loglikelihood function is very often a complex number. We thus \
use a simulated annealing followed by a FindMaximum in the vicinity of the \
simulated annealing results.\
\>", "Text",
 CellChangeTimes->{{3.58373225901156*^9, 3.583732362031522*^9}, {
   3.583732579361553*^9, 3.583732612597625*^9}, {3.5837326823434362`*^9, 
   3.583732722736969*^9}, {3.583734487218501*^9, 3.5837344962604237`*^9}, 
   3.5837345403456707`*^9}],

Cell[CellGroupData[{

Cell["Initialisation", "Subsubsection",
 CellChangeTimes->{{3.583642129791251*^9, 3.583642131836997*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdf", "=", "LLTot"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sr", "=", "123"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SeedRandom", "[", "sr", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Initialisation", " ", "of", " ", "the", " ", "variables"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0ini", "=", "0.051"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0ini", "=", "0.003"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0ini", "=", "320"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"angle1ini", "=", "1.03"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0min", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0max", "=", "0.15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0min", "=", "0.0009"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0max", "=", "0.015"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0min", "=", "260"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0max", "=", "330"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle1min", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"angle1max", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Initialisation", " ", "of", " ", "Metropolis"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nst", "=", "15"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "chains", " ", "with", " ", "a", " ", "given", " ", "temperature"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ntr", "=", "15"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "temperatures", " ", "between", " ", "Tmax", " ", "and", " ", "Tmin"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maxrep", "=", "100"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"changes", " ", "of", " ", "Tmin"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"climbrate", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proposalSigma", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tmax", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tmin", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "=", "Tmax"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xy", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "99999"}], ",", 
       RowBox[{"-", "99999"}], ",", 
       RowBox[{"-", "99999"}], ",", 
       RowBox[{"-", "99999"}], ",", 
       RowBox[{"-", "99999"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "nst"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xylist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xy", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "a0ini"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xy", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "b0ini"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xy", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", "c0ini"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xy", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "4"}], "]"}], "]"}], "=", "angle1ini"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xy", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"pdf", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a0", "\[Rule]", "a0ini"}], ",", 
      RowBox[{"b0", "\[Rule]", "b0ini"}], ",", 
      RowBox[{"c0", "\[Rule]", "c0ini"}], ",", 
      RowBox[{"angle1", "\[Rule]", "angle1ini"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xyverybest", "=", 
    RowBox[{"xy", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"na", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.583089171484829*^9, 3.5830891981731157`*^9}, 
   3.583089329884547*^9, 3.583089443974455*^9, {3.583089622792983*^9, 
   3.583089644667513*^9}, {3.583089742240078*^9, 3.5830899032496853`*^9}, {
   3.583090000457184*^9, 3.583090003001787*^9}, {3.583090084122107*^9, 
   3.583090102791319*^9}, {3.5830901479747677`*^9, 3.583090163619355*^9}, 
   3.5830901965156717`*^9, 3.583090314009354*^9, 3.583090417909534*^9, 
   3.583090519779067*^9, {3.583091134383566*^9, 3.583091183796324*^9}, 
   3.583093380184441*^9, {3.5831268033901587`*^9, 3.583126830789845*^9}, {
   3.583127409761971*^9, 3.583127585620861*^9}, {3.583127631559978*^9, 
   3.5831279953692913`*^9}, {3.5831280263302*^9, 3.583128048351942*^9}, {
   3.5831280938581543`*^9, 3.583128129145993*^9}, {3.583128486155053*^9, 
   3.583128556867256*^9}, {3.583128862514991*^9, 3.5831288885746317`*^9}, {
   3.583128939838935*^9, 3.5831289500344677`*^9}, {3.583129016673107*^9, 
   3.5831290241517763`*^9}, {3.583129160367444*^9, 3.58312918194797*^9}, {
   3.583129509583907*^9, 3.583129516295949*^9}, {3.583129617501132*^9, 
   3.5831296192608767`*^9}, {3.583129750428898*^9, 3.583129759725101*^9}, 
   3.583131425297472*^9, {3.583131644818181*^9, 3.583131712241647*^9}, {
   3.583132287459156*^9, 3.5831323150443907`*^9}, {3.5831323496839113`*^9, 
   3.583132377559463*^9}, {3.583133095323834*^9, 3.583133101659338*^9}, {
   3.583133161130851*^9, 3.5831331852062283`*^9}, 3.583137764093918*^9, {
   3.583137821810114*^9, 3.583137822744946*^9}, {3.583138124439849*^9, 
   3.58313813914428*^9}, {3.583138236131812*^9, 3.583138249591673*^9}, {
   3.5831384519185743`*^9, 3.5831385052601223`*^9}, {3.583138818843689*^9, 
   3.583138819988241*^9}, {3.583138875449478*^9, 3.583138956424096*^9}, {
   3.583138988265127*^9, 3.5831390177528257`*^9}, 3.583139092733539*^9, {
   3.583139273238467*^9, 3.583139305198701*^9}, {3.583139592989183*^9, 
   3.583139621885755*^9}, {3.5831397463225393`*^9, 3.5831397502670813`*^9}, {
   3.5831398635453243`*^9, 3.583139863672514*^9}, {3.5831399577231617`*^9, 
   3.583139958162657*^9}, {3.583140001989305*^9, 3.5831400083769827`*^9}, {
   3.5831400607897463`*^9, 3.583140082777298*^9}, {3.583140114715349*^9, 
   3.5831401157397413`*^9}, {3.583140197761917*^9, 3.5831402050484056`*^9}, {
   3.5831403303800163`*^9, 3.5831403411941767`*^9}, {3.583140411199678*^9, 
   3.583140412558544*^9}, {3.5831445686960993`*^9, 3.583144582361662*^9}, {
   3.5831446839878063`*^9, 3.583144773891554*^9}, {3.5831448150235023`*^9, 
   3.583144872516013*^9}, {3.5831449540482473`*^9, 3.583144985213776*^9}, 
   3.583145016619563*^9, {3.583145239201309*^9, 3.583145290526779*^9}, {
   3.583145362399886*^9, 3.5831453971548977`*^9}, {3.5831454320136967`*^9, 
   3.583145471029716*^9}, 3.583145550942163*^9, {3.5831456084731417`*^9, 
   3.583145617986061*^9}, 3.583145664919853*^9, {3.583145695690959*^9, 
   3.583145696210867*^9}, 3.583146173713894*^9, 3.58314622945053*^9, {
   3.583146274884934*^9, 3.583146307853118*^9}, {3.583146487991391*^9, 
   3.5831465045428667`*^9}, 3.583146571133768*^9, {3.583146640161368*^9, 
   3.58314679283346*^9}, {3.583146831559039*^9, 3.5831470149205427`*^9}, 
   3.583147073174946*^9, {3.5831472040171413`*^9, 3.583147204552552*^9}, {
   3.583147235692321*^9, 3.583147245873741*^9}, 3.583147318872514*^9, {
   3.5831473716684933`*^9, 3.583147371760201*^9}, {3.5831474531777773`*^9, 
   3.583147453793787*^9}, {3.58314750169981*^9, 3.5831475181371737`*^9}, {
   3.583147574115218*^9, 3.583147574641914*^9}, {3.583147710282464*^9, 
   3.5831477107262173`*^9}, {3.5831477540362873`*^9, 3.583147777887104*^9}, {
   3.583147896854649*^9, 3.583147897090151*^9}, {3.5831479736251583`*^9, 
   3.5831479751243067`*^9}, {3.5831483371424637`*^9, 3.5831483411832647`*^9}, 
   3.583148463805283*^9, {3.5831510859739313`*^9, 3.583151176833201*^9}, {
   3.583151215516975*^9, 3.5831512495031853`*^9}, 3.583151285012075*^9, {
   3.583151674935296*^9, 3.583151680846838*^9}, {3.583151733758422*^9, 
   3.583151736312929*^9}, {3.583151766416544*^9, 3.583151777224333*^9}, {
   3.58315182801613*^9, 3.583151834736611*^9}, {3.5831529441447487`*^9, 
   3.5831529614165*^9}, {3.583152994538847*^9, 3.5831530894370337`*^9}, {
   3.5831531483004208`*^9, 3.5831531501294203`*^9}, {3.583153204575643*^9, 
   3.583153276528555*^9}, {3.583153307388197*^9, 3.583153315277828*^9}, 
   3.583153352134186*^9, {3.58315341092943*^9, 3.583153423931581*^9}, {
   3.583153454576878*^9, 3.583153473234494*^9}, {3.583153541835244*^9, 
   3.5831535874140167`*^9}, {3.58315390757933*^9, 3.583153922575851*^9}, {
   3.583154263500352*^9, 3.583154297487009*^9}, {3.583154510147697*^9, 
   3.5831545277598467`*^9}, {3.583154599973061*^9, 3.5831546360206347`*^9}, {
   3.583155011255414*^9, 3.583155018308446*^9}, {3.58315521670674*^9, 
   3.583155251490162*^9}, {3.583155315390492*^9, 3.5831553465122223`*^9}, {
   3.583155432898179*^9, 3.583155457502988*^9}, {3.5831555035534983`*^9, 
   3.583155503896686*^9}, {3.5831555597842693`*^9, 3.583155570289002*^9}, {
   3.5831556143171797`*^9, 3.5831556295434217`*^9}, {3.5831557099714746`*^9, 
   3.583155759156426*^9}, 3.583155789994589*^9, 3.583155844864048*^9, {
   3.583155917256791*^9, 3.583155917759635*^9}, {3.583155948092431*^9, 
   3.583156000093672*^9}, {3.5831561120407*^9, 3.583156164299955*^9}, {
   3.5831563806338453`*^9, 3.583156471282837*^9}, {3.5831565747013063`*^9, 
   3.5831565910861197`*^9}, {3.583156804192432*^9, 3.583156848098669*^9}, {
   3.5831569416970367`*^9, 3.583157005423263*^9}, {3.583157074066688*^9, 
   3.5831570743029346`*^9}, {3.583157110428018*^9, 3.583157117002636*^9}, {
   3.583157184569107*^9, 3.5831571938331423`*^9}, {3.5831572632490387`*^9, 
   3.583157266021697*^9}, {3.583157953749482*^9, 3.583157994349598*^9}, {
   3.583158077266254*^9, 3.5831582442470703`*^9}, {3.583158318346889*^9, 
   3.583158322552949*^9}, 3.5831583983555326`*^9, {3.5831584704298353`*^9, 
   3.583158498051676*^9}, {3.583212138566042*^9, 3.583212164227059*^9}, 
   3.58321230411664*^9, {3.583212786443095*^9, 3.58321278950707*^9}, {
   3.583212907189035*^9, 3.58321291066159*^9}, {3.583213003729616*^9, 
   3.583213014948071*^9}, {3.583213428126506*^9, 3.583213434259951*^9}, {
   3.58321449460058*^9, 3.583214497598407*^9}, {3.583216820868598*^9, 
   3.5832168236368103`*^9}, {3.5832169915025253`*^9, 3.583217004511581*^9}, {
   3.583217064078535*^9, 3.5832170677401323`*^9}, {3.583217138246957*^9, 
   3.583217140086825*^9}, {3.5832171896713257`*^9, 3.583217192578455*^9}, {
   3.583217484916484*^9, 3.583217511637074*^9}, {3.5832224494398212`*^9, 
   3.583222450899377*^9}, {3.583222491881431*^9, 3.583222559762422*^9}, {
   3.583222598368932*^9, 3.5832226087850437`*^9}, {3.583222851159773*^9, 
   3.5832228737497807`*^9}, {3.583234421434054*^9, 3.583234554043696*^9}, {
   3.58323459057271*^9, 3.5832346034995737`*^9}, {3.583234650157022*^9, 
   3.5832346930508423`*^9}, 3.5832347896629553`*^9, {3.583234835247031*^9, 
   3.583234842615155*^9}, {3.583234898457325*^9, 3.5832349414829273`*^9}, {
   3.5832349717909107`*^9, 3.5832350075349197`*^9}, {3.583235050272808*^9, 
   3.583235200194121*^9}, {3.583235283720292*^9, 3.5832353274613447`*^9}, {
   3.583235390532556*^9, 3.583235474207786*^9}, {3.5834655245051517`*^9, 
   3.583465538277565*^9}, {3.583465586204266*^9, 3.5834656296083803`*^9}, {
   3.583465675555904*^9, 3.5834656788800097`*^9}, {3.583465732060588*^9, 
   3.5834657376001987`*^9}, {3.583465799127481*^9, 3.583465800589994*^9}, {
   3.5834658776123953`*^9, 3.5834659126483717`*^9}, {3.58346606157854*^9, 
   3.583466066300439*^9}, {3.583466148044964*^9, 3.583466185900167*^9}, {
   3.583466711938437*^9, 3.583466808145631*^9}, {3.583466864492936*^9, 
   3.583467010031311*^9}, {3.583467086594759*^9, 3.5834671733991213`*^9}, 
   3.583467224105744*^9, 3.583467330523609*^9, {3.583467363994133*^9, 
   3.583467372603118*^9}, {3.5834674547929983`*^9, 3.583467464199443*^9}, {
   3.583468264789732*^9, 3.583468272228311*^9}, {3.5834683118962603`*^9, 
   3.5834683132038927`*^9}, {3.583468350604887*^9, 3.5834683538205338`*^9}, {
   3.583468658589335*^9, 3.5834686930405416`*^9}, {3.583468727959092*^9, 
   3.5834688028779*^9}, {3.583468852110284*^9, 3.583468876181922*^9}, {
   3.583468930803689*^9, 3.5834689738974123`*^9}, {3.5834693469930058`*^9, 
   3.583469352374536*^9}, {3.583469841555047*^9, 3.583469848842288*^9}, {
   3.583469894682259*^9, 3.583469996695385*^9}, {3.583470122881917*^9, 
   3.58347016721109*^9}, {3.583470378615693*^9, 3.583470418752684*^9}, {
   3.58347050277149*^9, 3.583470528474708*^9}, {3.583470564629096*^9, 
   3.583470609254898*^9}, {3.583470704695134*^9, 3.5834707879895906`*^9}, 
   3.583470838078171*^9, {3.583471235517097*^9, 3.583471381155587*^9}, {
   3.583471411768969*^9, 3.5834714121019287`*^9}, {3.583471483618484*^9, 
   3.583471558124257*^9}, 3.583471619476289*^9, 3.58349503132734*^9, {
   3.583495062680553*^9, 3.583495071803547*^9}, {3.583495260157338*^9, 
   3.583495266171816*^9}, {3.5835541279462976`*^9, 3.583554150304131*^9}, {
   3.583554187769133*^9, 3.583554188416552*^9}, {3.583554241445527*^9, 
   3.583554241608161*^9}, {3.583554282824271*^9, 3.5835543123568563`*^9}, {
   3.583554908263455*^9, 3.5835550489673367`*^9}, {3.583555107236611*^9, 
   3.583555112082492*^9}, 3.5835552358171597`*^9, {3.583555321620788*^9, 
   3.583555383066883*^9}, {3.583555448232027*^9, 3.583555457197586*^9}, 
   3.583555716619791*^9, {3.5835601885198927`*^9, 3.583560196739373*^9}, 
   3.583560471316019*^9, 3.583560601927203*^9, 3.5835609189543324`*^9, {
   3.583561414599146*^9, 3.5835614280648327`*^9}, {3.583567757555258*^9, 
   3.583567770825284*^9}, {3.583568976767107*^9, 3.583568998467184*^9}, {
   3.583569047673585*^9, 3.583569048823688*^9}, {3.583569170002599*^9, 
   3.5835691734087687`*^9}, {3.583572549573821*^9, 3.583572559339912*^9}, {
   3.583572892267663*^9, 3.583572893293185*^9}, 3.583575645747017*^9, {
   3.583576779405559*^9, 3.583576788826035*^9}, {3.583577941901683*^9, 
   3.583577950572422*^9}, {3.583642146723364*^9, 3.58364214953959*^9}, {
   3.583649368234748*^9, 3.583649382076468*^9}, {3.583724091289918*^9, 
   3.583724194609885*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strings of variable perturbations", "Subsubsection",
 CellChangeTimes->{{3.583642129791251*^9, 3.583642131836997*^9}, {
  3.583642171020894*^9, 3.583642184912251*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Global", " ", "search"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nm", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"nm", "<", "maxrep"}], ")"}], "&&", 
       RowBox[{"(", 
        RowBox[{"Tmin", ">", "0"}], ")"}], "&&", 
       RowBox[{"(", 
        RowBox[{"climbrate", ">", "0"}], ")"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"nm", "=", 
        RowBox[{"nm", "+", "1"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"sumLL", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"ssqLL", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"beta", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Tmin", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"Tmax", ">", "0"}], ")"}]}], ",", 
          FractionBox[
           RowBox[{"Tmax", "-", "Tmin"}], 
           RowBox[{"ntr", " ", "Tmin", " ", "Tmax"}]], ",", "0"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"T", "=", "Tmax"}], ";", "\[IndentingNewLine]", 
       RowBox[{"nt", "=", "0"}], ";", "\n", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"nt", "<", "ntr"}], ")"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"nt", "=", 
           RowBox[{"nt", "+", "1"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"T", "=", 
           RowBox[{"Max", "[", 
            RowBox[{"0", ",", 
             FractionBox["T", 
              RowBox[{"1", "+", 
               RowBox[{"beta", " ", "T"}]}]]}], "]"}]}], ";", 
          RowBox[{"(*", 
           StyleBox[
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<T = \>\"", 
               RowBox[{"PaddedForm", "[", 
                RowBox[{"T", ",", "8"}], "]"}]}], "]"}], ";"}],
            FontColor->RGBColor[1, 0.5, 0]], "*)"}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"iter", "=", "0"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"xypts", "=", 
           RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"iter", "=", 
               RowBox[{"iter", "+", "1"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"x1", "=", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"x2", "=", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "2"}], "]"}], "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"x3", "=", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "3"}], "]"}], "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"x4", "=", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "4"}], "]"}], "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"x5", "=", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "5"}], "]"}], "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"p2", "=", 
               RowBox[{"3", "+", 
                RowBox[{"2", "*", "I"}]}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Im", "[", "p2", "]"}], ">", "0"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"x1p", "=", 
                  RowBox[{"-", "9999"}]}], ";", 
                 RowBox[{"x2p", "=", 
                  RowBox[{"-", "9999"}]}], ";", 
                 RowBox[{"x3p", "=", 
                  RowBox[{"-", "9999"}]}], ";", 
                 RowBox[{"x4p", "=", 
                  RowBox[{"-", "9999"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{"While", "[", 
                  RowBox[{
                   RowBox[{"!", 
                    RowBox[{"a0min", "<", "x1p", "<", "a0max"}]}], ",", 
                   RowBox[{"x1p", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"NormalDistribution", "[", 
                    RowBox[{"x1", ",", 
                    RowBox[{"proposalSigma", "*", 
                    RowBox[{"(", 
                    RowBox[{"a0max", "-", "a0min"}], ")"}]}]}], "]"}], 
                    "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"While", "[", 
                  RowBox[{
                   RowBox[{"!", 
                    RowBox[{"b0min", "<", "x2p", "<", "b0max"}]}], ",", 
                   RowBox[{"x2p", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"NormalDistribution", "[", 
                    RowBox[{"x2", ",", 
                    RowBox[{"proposalSigma", "*", 
                    RowBox[{"(", 
                    RowBox[{"b0max", "-", "b0min"}], ")"}]}]}], "]"}], 
                    "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"While", "[", 
                  RowBox[{
                   RowBox[{"!", 
                    RowBox[{"c0min", "<", "x3p", "<", "c0max"}]}], ",", 
                   RowBox[{"x3p", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"NormalDistribution", "[", 
                    RowBox[{"x3", ",", 
                    RowBox[{"proposalSigma", "*", 
                    RowBox[{"(", 
                    RowBox[{"c0max", "-", "c0min"}], ")"}]}]}], "]"}], 
                    "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"While", "[", 
                  RowBox[{
                   RowBox[{"!", 
                    RowBox[{"angle1min", "<", "x4p", "<", "angle1max"}]}], 
                   ",", 
                   RowBox[{"x4p", "=", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"NormalDistribution", "[", 
                    RowBox[{"x4", ",", 
                    RowBox[{"proposalSigma", "*", 
                    RowBox[{"(", 
                    RowBox[{"angle1max", "-", "angle1min"}], ")"}]}]}], "]"}],
                     "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"p2", "=", 
                  RowBox[{"pdf", "/.", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a0", "\[Rule]", "x1p"}], ",", 
                    RowBox[{"b0", "\[Rule]", "x2p"}], ",", 
                    RowBox[{"c0", "\[Rule]", "x3p"}], ",", 
                    RowBox[{"angle1", "->", "x4p"}]}], "}"}]}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"r", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"pdf", "/.", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"a0", "\[Rule]", "x1p"}], ",", 
                    RowBox[{"b0", "\[Rule]", "x2p"}], ",", 
                    RowBox[{"c0", "\[Rule]", "x3p"}], ",", 
                    RowBox[{"angle1", "->", "x4p"}]}], "}"}]}], ")"}], "-", 
                RowBox[{"(", 
                 RowBox[{"pdf", "/.", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"a0", "\[Rule]", "x1"}], ",", 
                    RowBox[{"b0", "\[Rule]", "x2"}], ",", 
                    RowBox[{"c0", "\[Rule]", "x3"}], ",", 
                    RowBox[{"angle1", "->", "x4"}]}], "}"}]}], ")"}]}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"u2", "=", 
               RowBox[{"Log", "[", 
                RowBox[{"RandomReal", "[", "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"acc", "=", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"T", ">", "0"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"u2", "\[LessEqual]", 
                   RowBox[{"r", "/", "T"}]}], ")"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"r", ">", "0"}], ")"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{"acc", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"xy", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "=", 
                  RowBox[{"{", 
                   RowBox[{"x1p", ",", "x2p", ",", "x3p", ",", "x4p", ",", 
                    RowBox[{"pdf", "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a0", "\[Rule]", "x1p"}], ",", 
                    RowBox[{"b0", "\[Rule]", "x2p"}], ",", 
                    RowBox[{"c0", "\[Rule]", "x3p"}], ",", 
                    RowBox[{"angle1", "->", "x4p"}]}], "}"}]}]}], "}"}]}], 
                 ";", 
                 RowBox[{"na", "=", 
                  RowBox[{"na", "+", "1"}]}]}], ",", 
                RowBox[{
                 RowBox[{"xy", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "=", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", 
                   RowBox[{"pdf", "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a0", "\[Rule]", "x1"}], ",", 
                    RowBox[{"b0", "\[Rule]", "x2"}], ",", 
                    RowBox[{"c0", "\[Rule]", "x3"}], ",", 
                    RowBox[{"angle1", "->", "x4"}]}], "}"}]}]}], "}"}]}]}], 
               "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"xylist", ",", 
                RowBox[{"xy", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"xy", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"i", ",", "2", ",", "nst"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"sumLL", "=", 
           RowBox[{"sumLL", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"xy", "[", 
                RowBox[{"[", 
                 RowBox[{"k", ",", "5"}], "]"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", 
                 RowBox[{"Length", "[", "xy", "]"}], ",", "1"}], "}"}]}], 
              "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"ssqLL", "=", 
           RowBox[{"ssqLL", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"k", ",", "5"}], "]"}], "]"}], "2"], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", 
                 RowBox[{"Length", "[", "xy", "]"}], ",", "1"}], "}"}]}], 
              "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"xybest", "=", 
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"xy", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "5"}], "]"}], "]"}], ",", 
                RowBox[{"_", "?", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "==", 
                    RowBox[{"Max", "[", 
                    RowBox[{"xy", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "5"}], "]"}], "]"}], "]"}]}], "&"}], 
                  ")"}]}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"xyverybest", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["xybest", 
                RowBox[{
                "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}]], ">", 
               
               SubscriptBox["xyverybest", 
                RowBox[{
                "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}]]}], 
              ")"}], ",", "xybest", ",", "xyverybest"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"xyder", "=", 
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"Length", "[", "xy", "]"}], "]"}], "]"}]}], ";", 
          RowBox[{"(*", 
           StyleBox[
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<xyder = \>\"", 
               RowBox[{"PaddedForm", "[", 
                RowBox[{"xyder", ",", "8"}], "]"}]}], "]"}], ";"}],
            FontColor->RGBColor[1, 0.5, 0]], 
           StyleBox["*)",
            FontColor->RGBColor[1, 0.5, 0]]}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"xy", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "99999"}], ",", 
               RowBox[{"-", "99999"}], ",", 
               RowBox[{"-", "99999"}], ",", 
               RowBox[{"-", "99999"}], ",", 
               RowBox[{"-", "99999"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "nst"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
           RowBox[{"xyder", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
           RowBox[{"xyder", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
           RowBox[{"xyder", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], "=", 
           RowBox[{"xyder", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xy", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "5"}], "]"}], "]"}], "=", 
           RowBox[{"xyder", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"meanLL", "=", 
        RowBox[{"sumLL", "/", 
         RowBox[{"(", 
          RowBox[{"ntr", "*", "nst"}], ")"}]}]}], ";", 
       RowBox[{"(*", 
        StyleBox[
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<MeanLL = \>\"", 
            RowBox[{"PaddedForm", "[", 
             RowBox[{"meanLL", ",", "8"}], "]"}]}], "]"}], ";"}],
         FontColor->RGBColor[1, 0.5, 0]], 
        StyleBox["*)",
         FontColor->RGBColor[1, 0.5, 0]]}], "\[IndentingNewLine]", 
       RowBox[{"varLL", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ssqLL", "-", 
           RowBox[{
            SuperscriptBox["meanLL", "2"], "*", "ntr", "*", "nst"}]}], ")"}], 
         "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ntr", "*", "nst"}], "-", "1"}], ")"}]}]}], ";", 
       RowBox[{"(*", 
        StyleBox[
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<varLL = \>\"", 
            RowBox[{"PaddedForm", "[", 
             RowBox[{"varLL", ",", "8"}], "]"}]}], "]"}], ";"}],
         FontColor->RGBColor[1, 0.5, 0]], 
        StyleBox["*)",
         FontColor->RGBColor[1, 0.5, 0]]}], 
       StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"specificheat", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Tmin", ">", "0"}], ",", 
           RowBox[{"varLL", "/", 
            SuperscriptBox["Tmin", "2"]}], ",", "0"}], "]"}]}],
        FontColor->GrayLevel[0]], 
       StyleBox[";",
        FontColor->GrayLevel[0]], 
       RowBox[{
        StyleBox["(*",
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Heat = \>\"", 
            RowBox[{"PaddedForm", "[", 
             RowBox[{"specificheat", ",", "8"}], "]"}]}], "]"}], ";"}],
         FontColor->RGBColor[1, 0.5, 0]], 
        StyleBox["*)",
         FontColor->RGBColor[1, 0.5, 0]]}], 
       StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"Tminnew", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{"Tmin", "-", 
            RowBox[{"climbrate", "/", "specificheat"}]}]}], "]"}]}],
        FontColor->GrayLevel[0]], 
       StyleBox[";",
        FontColor->GrayLevel[0]], 
       StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
       RowBox[{"climbrate", "=", 
        RowBox[{
         StyleBox["Which",
          FontColor->GrayLevel[0]], 
         StyleBox["[",
          FontColor->GrayLevel[0]], 
         StyleBox["\[IndentingNewLine]",
          FontColor->GrayLevel[0]], 
         RowBox[{
          StyleBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Tminnew", "/", "Tmin"}], ")"}], ">", "0.9"}],
           FontColor->GrayLevel[0]], 
          StyleBox[",",
           FontColor->GrayLevel[0]], 
          StyleBox[
           RowBox[{"(", 
            RowBox[{"climbrate", "*", "3"}], ")"}],
           FontColor->GrayLevel[0]], 
          StyleBox[",",
           FontColor->GrayLevel[0]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->GrayLevel[0]], 
          StyleBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Tminnew", "/", "Tmin"}], ")"}], "<", "0.1"}],
           FontColor->GrayLevel[0]], 
          StyleBox[",",
           FontColor->GrayLevel[0]], 
          StyleBox[
           RowBox[{"(", 
            RowBox[{"climbrate", "/", "3"}], ")"}],
           FontColor->GrayLevel[0]], 
          StyleBox[",",
           FontColor->GrayLevel[0]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->GrayLevel[0]], 
          RowBox[{
           StyleBox["0.1",
            FontColor->GrayLevel[0]], 
           StyleBox["\[LessEqual]",
            FontColor->GrayLevel[0]], " ", 
           StyleBox[
            RowBox[{"(", 
             RowBox[{"Tminnew", "/", "Tmin"}], ")"}],
            FontColor->GrayLevel[0]], 
           StyleBox["\[LessEqual]",
            FontColor->GrayLevel[0]], " ", 
           StyleBox["0.9",
            FontColor->GrayLevel[0]]}], 
          StyleBox[",",
           FontColor->GrayLevel[0]], 
          StyleBox["climbrate",
           FontColor->GrayLevel[0]]}], 
         StyleBox["\[IndentingNewLine]",
          FontColor->GrayLevel[0]], 
         StyleBox["]",
          FontColor->GrayLevel[0]]}]}], 
       StyleBox[";",
        FontColor->GrayLevel[0]], 
       StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"Tmin", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"specificheat", ">", "0"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"0", ",", 
             RowBox[{"Tmin", "-", 
              RowBox[{"climbrate", "/", "specificheat"}]}]}], "]"}], ",", 
           "Tmin"}], "]"}]}],
        FontColor->GrayLevel[0]]}]}], 
     StyleBox["\[IndentingNewLine]",
      FontColor->GrayLevel[0]], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], 
    StyleBox[";",
     FontColor->GrayLevel[0]]}]}]}]], "Input",
 CellChangeTimes->{{3.5835593482316427`*^9, 3.5835593563766537`*^9}, {
   3.583559425671177*^9, 3.583559425967462*^9}, 3.583560586883518*^9, {
   3.583560851518412*^9, 3.5835608858630333`*^9}, {3.583560934630138*^9, 
   3.583560953978416*^9}, {3.5835610483667917`*^9, 3.5835610509739523`*^9}, {
   3.5835612188637247`*^9, 3.583561220358501*^9}, {3.5835614427106247`*^9, 
   3.583561444340116*^9}, {3.583564456521715*^9, 3.583564458059677*^9}, {
   3.5835645000187683`*^9, 3.583564510526819*^9}, {3.583566949780923*^9, 
   3.583566950995661*^9}, {3.583567272624839*^9, 3.583567304031786*^9}, {
   3.583567338550774*^9, 3.583567340926186*^9}, {3.583567388608707*^9, 
   3.5835673906779537`*^9}, {3.583567443844198*^9, 3.583567476350518*^9}, {
   3.5835676440078297`*^9, 3.58356773767651*^9}, {3.5835678221673822`*^9, 
   3.58356795484188*^9}, {3.583568241835225*^9, 3.583568346594301*^9}, {
   3.583568378993441*^9, 3.583568437009447*^9}, {3.583568475276313*^9, 
   3.583568498525338*^9}, {3.583568898938962*^9, 3.583568905174672*^9}, 
   3.583568973968708*^9, {3.583569018880302*^9, 3.583569044619009*^9}, 
   3.583569076608664*^9, {3.583569179351227*^9, 3.5835691949113417`*^9}, {
   3.583572585046742*^9, 3.583572695576187*^9}, 3.5835727682029552`*^9, {
   3.5835728441020613`*^9, 3.583572880775896*^9}, {3.583573190944151*^9, 
   3.5835732163132467`*^9}, {3.58357328259518*^9, 3.583573283760913*^9}, {
   3.583574911141981*^9, 3.583574946716921*^9}, 3.5835759277814693`*^9, {
   3.583576015333879*^9, 3.583576027193232*^9}, {3.583576083365796*^9, 
   3.583576135459977*^9}, {3.583576201339698*^9, 3.5835762315857487`*^9}, {
   3.58357702988218*^9, 3.5835771062425137`*^9}, {3.5835771731819277`*^9, 
   3.583577221613875*^9}, {3.583577278747999*^9, 3.583577389844228*^9}, {
   3.5835774695172653`*^9, 3.5835774800978394`*^9}, {3.5835776316055117`*^9, 
   3.583577634345368*^9}, {3.583577759662105*^9, 3.58357792082518*^9}, {
   3.5836493419198914`*^9, 3.583649345570463*^9}, {3.583649411074086*^9, 
   3.583649438641581*^9}, {3.583724205085614*^9, 3.583724292083356*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Figures", "Subsubsection",
 CellChangeTimes->{{3.583642129791251*^9, 3.583642131836997*^9}, {
  3.5836422495910263`*^9, 3.5836422547250357`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x1points", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"xylist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a0min", ",", "a0max"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<a0\>\"", ",", "Italic"}], "]"}], "}"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<iteration\>\"", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<x\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"35", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "25"}], "}"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"x2points", "=", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"xylist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"b0min", ",", "b0max"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<b0\>\"", ",", "Italic"}], "]"}], "}"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<iteration\>\"", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"35", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "25"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x3points", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"xylist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"c0min", ",", "c0max"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<c0\>\"", ",", "Italic"}], "]"}], "}"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<iteration\>\"", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"35", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "25"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x4points", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"xylist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"angle1min", ",", "angle1max"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<angle1\>\"", ",", "Italic"}], "]"}], "}"}], "]"}]}], 
     ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<iteration\>\"", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<y\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"35", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "25"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"llpoints", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"xylist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "5"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<LL\>\"", ",", "Italic"}], "]"}], "}"}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<iteration\>\"", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<LL\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"35", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "25"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1points", ",", "x2points"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x3points", ",", "x4points"}], "}"}], ",", 
    RowBox[{"{", "llpoints", "}"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", "xyverybest"}], "Input",
 CellChangeTimes->{{3.583578136974759*^9, 3.5835781488234997`*^9}, {
  3.58365434486073*^9, 3.583654361958321*^9}, {3.583654470207282*^9, 
  3.583654470767251*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, 
        {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxc3X1YTdv6N/CkTRKSkLQJISQhhORGknZIkiRZCCEkSZKsXlQqtXp/ryUh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